/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoManager;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyCaret;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.strings.StringHelper;
import java.awt.Point;
import java.awt.event.KeyEvent;

public abstract class CAbstractKeyBehavior {
    private ZyLabelContent m_labelContent = null;
    private final CUndoManager m_undoManager;
    private KeyEvent m_event = null;
    private boolean m_alt;
    private boolean m_ctrl;
    private boolean m_shift;

    public CAbstractKeyBehavior(CUndoManager undoManager) {
        this.m_undoManager = Preconditions.checkNotNull(undoManager, "Error: Undo manager can't be null.");
    }

    private ZyCaret getCaret() {
        return this.m_labelContent.getCaret();
    }

    private String getSingleLineCommentText(ZyLineContent lineContent) {
        StringBuilder commentText = new StringBuilder();
        String lineText = lineContent.getText();
        boolean hasDelimiter = false;
        for (IZyEditableObject lineObject : lineContent.getLineFragmentObjectList()) {
            if (lineObject.isCommentDelimiter()) {
                hasDelimiter = true;
                continue;
            }
            if (!hasDelimiter) continue;
            String subString = lineText.substring(lineObject.getStart(), lineObject.getEnd());
            commentText.append(subString);
        }
        return commentText.toString();
    }

    private void setModifier(KeyEvent event) {
        this.m_ctrl = false;
        this.m_shift = false;
        this.m_alt = false;
        if (event.getModifiersEx() == 192) {
            this.m_ctrl = true;
            this.m_shift = true;
        } else if (event.getModifiersEx() == 640) {
            this.m_ctrl = true;
            this.m_alt = true;
        } else if (event.getModifiersEx() == 576) {
            this.m_alt = true;
            this.m_shift = true;
        } else if (event.isAltDown()) {
            this.m_alt = true;
        } else if (event.isControlDown()) {
            this.m_ctrl = true;
        } else if (event.isShiftDown()) {
            this.m_shift = true;
        }
    }

    private void updateLabelSize() {
        ZyLabelContent labelContent = this.getLabelContent();
        IZyEditableObject labelModel = labelContent.getModel();
        labelContent.getLineEditor().recreateLabelLines(labelContent, labelModel);
    }

    protected int correctMouseReleasedX(int mouseReleased_X, int mouseReleased_Y, int mousePressed_Y) {
        int lastReleasedXPos = this.getLastLineXPos(mouseReleased_Y);
        if (mouseReleased_X > lastReleasedXPos && mouseReleased_Y == mousePressed_Y) {
            return lastReleasedXPos;
        }
        return mouseReleased_X;
    }

    protected void deleteSelection() {
        if (this.isSelection() && this.isDeleteableSelection()) {
            ZyLineContent curLineContent;
            int lineIndex;
            int mouseStartX = Math.min(this.getCaretMousePressedX(), this.getCaretMouseReleasedX());
            int mouseEndX = Math.max(this.getCaretMousePressedX(), this.getCaretMouseReleasedX());
            int mouseStartY = Math.min(this.getCaretMousePressedY(), this.getCaretMouseReleasedY());
            int mouseEndY = Math.max(this.getCaretMousePressedY(), this.getCaretMouseReleasedY());
            int caretStartX = Math.min(this.getCaretStartPosX(), this.getCaretEndPosX());
            int firstModelLine = this.m_labelContent.getFirstLineIndexOfModelAt(mouseStartY);
            int noneCommentLine = this.m_labelContent.getNonPureCommentLineIndexOfModelAt(mouseStartY);
            int lastModelLine = this.m_labelContent.getLastLineIndexOfModelAt(mouseStartY);
            int firstObjectLine = firstModelLine;
            int lastObjectLine = lastModelLine;
            if (noneCommentLine != -1) {
                if (mouseStartY < noneCommentLine) {
                    lastObjectLine = noneCommentLine - 1;
                } else {
                    firstObjectLine = noneCommentLine;
                }
            }
            StringBuilder changedText = new StringBuilder();
            ZyLineContent lineContent = this.getLineContent(mouseStartY);
            IZyEditableObject editObject = lineContent.getLineFragmentObjectAt(mouseStartX);
            if (editObject == null) {
                for (lineIndex = firstObjectLine; lineIndex <= lastObjectLine && (editObject = (curLineContent = this.getLineContent(lineIndex)).getLineFragmentObjectAt(mouseStartX)) == null; ++lineIndex) {
                }
            }
            if (firstObjectLine == lastObjectLine && !this.isComment(caretStartX, mouseStartY)) {
                if (editObject.isCommentDelimiter()) {
                    mouseStartX = editObject.getEnd();
                    caretStartX = editObject.getEnd();
                    editObject = lineContent.getLineFragmentObjectAt(caretStartX);
                }
                String text2 = lineContent.getText();
                changedText = new StringBuilder(String.format("%s%s", text2.substring(editObject.getStart(), mouseStartX), text2.substring(mouseEndX)));
            } else {
                for (lineIndex = firstObjectLine; lineIndex <= lastObjectLine; ++lineIndex) {
                    curLineContent = this.getLineContent(lineIndex);
                    IZyEditableObject curEditObject = curLineContent.getLineFragmentObjectAt(mouseStartX);
                    if (curEditObject == null) {
                        curEditObject = curLineContent.getLineFragmentObjectAt(this.getLastLineXPos(lineIndex));
                    }
                    int tempMouseStartX = mouseStartX;
                    int tempMouseEndX = mouseEndX;
                    if (curEditObject.isCommentDelimiter() && mouseEndX < (tempMouseStartX = (curEditObject = curLineContent.getLineFragmentObjectAt(curEditObject.getEnd())).getStart())) {
                        tempMouseEndX = tempMouseStartX;
                    }
                    String text3 = curLineContent.getText();
                    int curEndX = Math.min(text3.length(), tempMouseEndX);
                    if (lineIndex >= mouseStartY && lineIndex <= mouseEndY && text3.length() > tempMouseStartX) {
                        String afterDeletion = String.format("%s%s", text3.substring(curEditObject.getStart(), tempMouseStartX), text3.substring(curEndX));
                        if (afterDeletion.equals("\n") || afterDeletion.equals("\r")) continue;
                        changedText.append(afterDeletion);
                        continue;
                    }
                    changedText.append(curLineContent.getText(curEditObject));
                }
            }
            if (changedText.toString().endsWith("\n")) {
                changedText = new StringBuilder(changedText.substring(0, changedText.length() - 1));
            }
            if (!changedText.toString().endsWith("\r")) {
                changedText.append("\r");
            }
            if (editObject != null && editObject.isCommentDelimiter()) {
                caretStartX = editObject.getEnd();
                mouseStartX = editObject.getEnd();
            }
            for (int lineIndex2 = firstObjectLine; lineIndex2 <= lastObjectLine; ++lineIndex2) {
                lineContent = this.getLineContent(lineIndex2);
                if (lineContent.getText().length() < mouseStartX || mouseStartY > lineIndex2) continue;
                mouseStartY = lineIndex2;
                caretStartX = mouseStartX;
                break;
            }
            if (editObject != null) {
                editObject.update(changedText.toString());
                this.getLabelContent().getLineEditor().recreateLabelLines(this.getLabelContent(), editObject.getPersistentModel());
            }
            this.setCaret(caretStartX, mouseStartX, mouseStartY, caretStartX, mouseStartX, mouseStartY);
        }
    }

    protected int getCaretEndPosX() {
        return this.getCaret().getCaretEndPos();
    }

    protected int getCaretMousePressedX() {
        return this.getCaret().getXmousePressed();
    }

    protected int getCaretMousePressedY() {
        return this.getCaret().getYmousePressed();
    }

    protected int getCaretMouseReleasedX() {
        return this.getCaret().getXmouseReleased();
    }

    protected int getCaretMouseReleasedY() {
        return this.getCaret().getYmouseReleased();
    }

    protected int getCaretStartPosX() {
        return this.getCaret().getCaretStartPos();
    }

    protected KeyEvent getEvent() {
        return this.m_event;
    }

    protected ZyLabelContent getLabelContent() {
        return this.m_labelContent;
    }

    protected int getLastLineXPos(int lineYPos) {
        ZyLineContent lineContent = this.getLineContent(lineYPos);
        String text2 = lineContent.getText();
        if (text2.endsWith("\n") || text2.endsWith("\r")) {
            return text2.length() - 1;
        }
        return text2.length();
    }

    protected ZyLineContent getLineContent(int line) {
        return this.m_labelContent.getLineContent(line);
    }

    protected int getMaxLineLength(int startYIndex, int endYIndex) {
        return this.getCaret().getMaxLineLength(startYIndex, endYIndex);
    }

    protected String getMultilineComment(int lineYPos, String changedLine) {
        int endIndex;
        StringBuilder commentText = new StringBuilder();
        int nonCommentLine = this.m_labelContent.getNonPureCommentLineIndexOfModelAt(lineYPos);
        int firstModelLine = this.m_labelContent.getFirstLineIndexOfModelAt(lineYPos);
        int lastModelLine = this.m_labelContent.getLastLineIndexOfModelAt(lineYPos);
        int startIndex = this.isAboveLineComment(lineYPos) ? firstModelLine : nonCommentLine;
        int n2 = endIndex = this.isAboveLineComment(lineYPos) ? nonCommentLine - 1 : lastModelLine;
        if (nonCommentLine == -1) {
            startIndex = firstModelLine;
            endIndex = lastModelLine;
        }
        for (int index = startIndex; index <= endIndex; ++index) {
            if (index == lineYPos) {
                commentText.append(changedLine);
                continue;
            }
            ZyLineContent curLineContent = this.m_labelContent.getLineContent(index);
            String lineText = this.getSingleLineCommentText(curLineContent);
            commentText.append(lineText);
        }
        return commentText.toString().equals("") ? changedLine : commentText.toString();
    }

    protected String getMultiLineComment(int lineYPos) {
        int endIndex;
        StringBuilder commentText = new StringBuilder();
        int nonCommentLine = this.m_labelContent.getNonPureCommentLineIndexOfModelAt(lineYPos);
        int firstModelLine = this.m_labelContent.getFirstLineIndexOfModelAt(lineYPos);
        int lastModelLine = this.m_labelContent.getLastLineIndexOfModelAt(lineYPos);
        int startIndex = this.isAboveLineComment(lineYPos) ? firstModelLine : nonCommentLine;
        int n2 = endIndex = this.isAboveLineComment(lineYPos) ? nonCommentLine - 1 : lastModelLine;
        if (nonCommentLine < 0) {
            startIndex = firstModelLine;
            endIndex = lastModelLine;
        }
        for (int index = startIndex; index <= endIndex; ++index) {
            ZyLineContent curLineContent = this.m_labelContent.getLineContent(index);
            String lineText = this.getSingleLineCommentText(curLineContent);
            commentText.append(lineText);
        }
        return commentText.toString();
    }

    protected ZyLineContent getNextModelLineContent(int lineYPos) {
        ZyLineContent lineContent = this.m_labelContent.getLineContent(lineYPos);
        IZyEditableObject lineObject = lineContent.getLineObject();
        for (int index = lineYPos + 1; index < this.m_labelContent.getLineCount(); ++index) {
            ZyLineContent nextLineContent = this.m_labelContent.getLineContent(index);
            if (nextLineContent == null) {
                return null;
            }
            IZyEditableObject nextLineObject = nextLineContent.getLineObject();
            if (lineObject == nextLineObject || nextLineObject.isPlaceholder()) continue;
            return nextLineContent;
        }
        return null;
    }

    protected int getNextModelLineIndex(int lineYPos) {
        ZyLineContent lineContent = this.getNextModelLineContent(lineYPos);
        for (int index = lineYPos + 1; index < this.m_labelContent.getLineCount(); ++index) {
            if (lineContent == null || lineContent.getLineObject().isPlaceholder()) continue;
            return this.getLabelContent().getLineIndex(lineContent);
        }
        return -1;
    }

    protected String getSelectedText() {
        if (!this.isSelection()) {
            return "";
        }
        int yStart = Math.min(this.getCaretMousePressedY(), this.getCaretMouseReleasedY());
        int yEnd = Math.max(this.getCaretMousePressedY(), this.getCaretMouseReleasedY());
        int xStart = Math.min(this.getCaretMousePressedX(), this.getCaretMouseReleasedX());
        int xEnd = Math.max(this.getCaretMousePressedX(), this.getCaretMouseReleasedX());
        StringBuilder clipboardText = new StringBuilder();
        for (int lineIndex = yStart; lineIndex <= yEnd; ++lineIndex) {
            ZyLineContent lineContent = this.getLineContent(lineIndex);
            int lineLength = lineContent.getText().length();
            if (xStart < lineLength) {
                String lineText;
                String fragment;
                int xTempEnd = xEnd;
                if (xEnd > lineLength) {
                    xTempEnd = lineLength;
                }
                if (!(fragment = (lineText = lineContent.getText()).substring(xStart, xTempEnd)).endsWith("\n") && lineIndex != yEnd) {
                    fragment = String.valueOf(fragment).concat("\n");
                }
                if (fragment.endsWith("\r") || lineIndex == yEnd && fragment.endsWith("\n")) {
                    fragment = fragment.substring(0, fragment.length() - 1);
                }
                clipboardText.append(fragment);
                continue;
            }
            if (lineIndex == yEnd) continue;
            clipboardText.append("\n");
        }
        return clipboardText.toString();
    }

    protected abstract void initUndoHistory();

    protected boolean isAboveLineComment(int lineYPos) {
        int nonCommentLineYPos = this.getLabelContent().getNonPureCommentLineIndexOfModelAt(lineYPos);
        if (nonCommentLineYPos < 0) {
            return false;
        }
        return nonCommentLineYPos > lineYPos;
    }

    protected boolean isAltPressed() {
        return this.m_alt;
    }

    protected boolean isBehindLineComment(int lineXPos, int lineYPos) {
        int nonCommentLineYPos = this.getLabelContent().getNonPureCommentLineIndexOfModelAt(lineYPos);
        if (nonCommentLineYPos < 0) {
            return false;
        }
        if (nonCommentLineYPos < lineYPos) {
            return true;
        }
        if (nonCommentLineYPos == lineYPos) {
            ZyLineContent lineContent = this.getLabelContent().getLineContent(lineYPos);
            if (lineContent == null) {
                return false;
            }
            for (IZyEditableObject obj : lineContent.getLineFragmentObjectList()) {
                if (!obj.isCommentDelimiter()) continue;
                return obj.getStart() <= lineXPos;
            }
        }
        return false;
    }

    protected boolean isComment(int lineXPos, int lineYPos) {
        ZyLineContent lineContent = this.getLabelContent().getLineContent(lineYPos);
        if (lineContent != null) {
            boolean commentDelimiterFound = false;
            for (IZyEditableObject obj : lineContent.getLineFragmentObjectList()) {
                if (obj.isCommentDelimiter()) {
                    commentDelimiterFound = true;
                }
                if (lineXPos < obj.getStart() || !commentDelimiterFound) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isCtrlPressed() {
        return this.m_ctrl;
    }

    protected boolean isDeleteableSelection() {
        int mouseStartY = Math.min(this.getCaretMousePressedY(), this.getCaretMouseReleasedY());
        int mouseEndY = Math.max(this.getCaretMousePressedY(), this.getCaretMouseReleasedY());
        int caretStartX = Math.min(this.getCaretStartPosX(), this.getCaretEndPosX());
        int caretEndX = Math.max(this.getCaretStartPosX(), this.getCaretEndPosX());
        ZyLineContent firstLineContent = this.getLineContent(mouseStartY);
        ZyLineContent lastLineContent = this.getLineContent(mouseEndY);
        IZyEditableObject firstEditObject = firstLineContent.getLineFragmentObjectAt(caretStartX);
        IZyEditableObject lastEditObject = firstLineContent.getLineFragmentObjectAt(caretEndX);
        if (firstLineContent.getLineObject() != lastLineContent.getLineObject()) {
            return false;
        }
        if (this.isComment(caretStartX, mouseStartY)) {
            int noneCommentLine;
            if (mouseEndY > mouseStartY && (noneCommentLine = this.m_labelContent.getNonPureCommentLineIndexOfModelAt(mouseStartY)) != -1) {
                if (mouseStartY < noneCommentLine && mouseEndY >= noneCommentLine) {
                    return false;
                }
                if (mouseStartY >= noneCommentLine && mouseEndY < noneCommentLine) {
                    return false;
                }
            }
        } else if (firstEditObject != lastEditObject || firstEditObject == null && lastEditObject == null) {
            return false;
        }
        return true;
    }

    protected boolean isEditable(int lineXPos, int lineYPos) {
        ZyLineContent lineContent = this.getLabelContent().getLineContent(lineYPos);
        return lineContent.isEditable(lineXPos);
    }

    protected boolean isLabelComment(int lineYPos) {
        return this.getLabelContent().getNonPureCommentLineIndexOfModelAt(lineYPos) == -1;
    }

    protected boolean isSelection() {
        return this.getCaret().isSelection();
    }

    protected boolean isShiftPressed() {
        return this.m_shift;
    }

    protected Point pasteClipboardText() {
        int nonModelLineY;
        int caretX = this.getCaretEndPosX();
        int caretY = this.getCaretMouseReleasedY();
        boolean isNewComment = false;
        ZyLineContent lineContent = this.getLineContent(caretY);
        IZyEditableObject editObject = lineContent.getLineFragmentObjectAt(caretX);
        if (editObject == null && caretX == lineContent.getText().length() && (nonModelLineY = this.getLabelContent().getNonPureCommentLineIndexOfModelAt(caretY)) != -1 && nonModelLineY == caretY) {
            editObject = lineContent.getLineObject();
            isNewComment = true;
        }
        if (editObject != null) {
            String insertText = ClipboardHelpers.getClipboardString();
            if (editObject.isCommentDelimiter() && (editObject = lineContent.getLineFragmentObjectAt(caretX = editObject.getEnd())) == null) {
                return null;
            }
            if (this.isComment(caretX, caretY)) {
                int insertedLineCount = StringHelper.count(insertText, '\n');
                int lastLineBreak = insertText.lastIndexOf("\n");
                int textCursor = caretX - editObject.getStart();
                String lineText = lineContent.getText().substring(editObject.getStart(), editObject.getEnd());
                String changedText = String.format("%s%s%s", lineText.substring(0, textCursor), insertText, lineText.substring(textCursor));
                changedText = this.getMultilineComment(caretY, changedText);
                editObject.update(changedText);
                this.getLabelContent().getLineEditor().recreateLabelLines(this.getLabelContent(), editObject.getPersistentModel());
                caretX += insertText.length() - lastLineBreak - 1;
                caretY += insertedLineCount;
            } else if (isNewComment) {
                editObject.updateComment(insertText, ECommentPlacement.BEHIND_LINE);
                if (!this.isLabelComment(caretY)) {
                    this.getLabelContent().getLineEditor().recreateLabelLines(this.getLabelContent(), editObject.getPersistentModel());
                    int insertedLineCount = StringHelper.count(insertText, '\n');
                    ZyLineContent lastInsertedLineContent = this.getLineContent(caretY += insertedLineCount);
                    caretX += lastInsertedLineContent.getText().length() - 1;
                }
            } else {
                insertText = insertText.replace("\n", "");
                insertText = insertText.replace("\r", "");
                int tempCaretX = caretX;
                String lineText = lineContent.getText();
                String changedText = lineText.substring(editObject.getStart(), editObject.getEnd());
                int insertXpos = tempCaretX - editObject.getStart();
                changedText = String.format("%s%s%s", lineText.substring(editObject.getStart(), insertXpos), insertText, lineText.substring(caretX += insertText.length(), editObject.getEnd()));
                editObject.update(changedText);
            }
        }
        return new Point(caretX, caretY);
    }

    protected void redo() {
        this.m_undoManager.redo();
    }

    protected void setCaret(int caretStartPos_X, int mousePressed_X, int mousePressed_Y, int caretEndPos_X, int mouseReleased_X, int mouseReleased_Y) {
        this.getCaret().setCaret(caretStartPos_X, mousePressed_X, mousePressed_Y, caretEndPos_X, mouseReleased_X, mouseReleased_Y);
    }

    protected void udpateUndolist(ZyLabelContent labelContent, Object persistantModel, IZyEditableObject editableObject, String changedText, boolean isAboveLineComment, boolean isBehindLineComment, boolean isLabelComment, int caretStartX, int caretMousePressedX, int caretMousePressedY, int caretEndX, int caretMouseReleasedX, int caretMouseReleasedY) {
        this.m_undoManager.addUndoState(labelContent, persistantModel, editableObject, changedText, isAboveLineComment, isBehindLineComment, isLabelComment, caretStartX, caretMousePressedX, caretMousePressedY, caretEndX, caretMouseReleasedX, caretMouseReleasedY);
    }

    protected void undo() {
        this.m_undoManager.undo();
    }

    protected abstract void updateCaret();

    protected abstract void updateClipboard();

    protected abstract void updateLabelContent();

    protected abstract void updateSelection();

    protected abstract void updateUndoHistory();

    public void keyPressed(ZyLabelContent labelContent, KeyEvent event) {
        this.m_labelContent = labelContent;
        this.m_event = event;
        this.setModifier(event);
        if (labelContent.isEditable()) {
            this.initUndoHistory();
        }
        this.updateClipboard();
        this.updateSelection();
        if (labelContent.isEditable()) {
            this.updateLabelContent();
        }
        this.updateCaret();
        if (labelContent.isEditable()) {
            this.updateUndoHistory();
            this.updateLabelSize();
        }
        this.m_alt = false;
        this.m_shift = false;
        this.m_ctrl = false;
    }
}

