/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.proximity;

import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphConverters;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.ITextNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.NodeHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.CProximityNode;
import com.google.security.zynamics.zylib.gui.zygraph.wrappers.ViewableGraph;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class ProximityNodeFunctions<NodeType extends IViewNode<?> & IGraphNode<NodeType>, U extends ZyGraphNode<NodeType>, V extends AbstractZyGraph<U, ?>> {
    private Collection<U> filterVisibleNodes(Collection<U> visibleNodes) {
        return CollectionHelpers.filter(visibleNodes, new ICollectionFilter<U>(){

            @Override
            public boolean qualifies(U node) {
                return NodeHelpers.getVisibleNode(((ZyGraphNode)node).getRawNode()) == ((ZyGraphNode)node).getRawNode();
            }
        });
    }

    private Collection<U> getNeighborhood(V graph, ZyProximityNode<NodeType> zyNode) {
        List candidates = zyNode.isIncoming() ? ((IGraphNode)((CProximityNode)zyNode.getRawNode()).getAttachedNode()).getChildren() : ((IGraphNode)((CProximityNode)zyNode.getRawNode()).getAttachedNode()).getParents();
        LinkedHashSet<IViewNode> nodes = new LinkedHashSet<IViewNode>();
        for (IViewNode candidate : candidates) {
            if (candidate.isVisible()) continue;
            if (candidate.getParentGroup() != null) {
                nodes.add(candidate.getParentGroup());
                nodes.add(candidate);
                continue;
            }
            nodes.add(candidate);
        }
        for (IViewNode node : new ArrayList(nodes)) {
            if (zyNode.isIncoming()) {
                for (IViewNode parent : ((IGraphNode)((Object)node)).getParents()) {
                    if (!(parent instanceof ITextNode)) continue;
                    nodes.add(parent);
                }
                continue;
            }
            for (IViewNode child : ((IGraphNode)((Object)node)).getChildren()) {
                if (!(child instanceof ITextNode)) continue;
                nodes.add(child);
            }
        }
        return GraphConverters.convert(graph, nodes);
    }

    protected abstract void showNodes(Window var1, V var2, List<U> var3, boolean var4);

    public void showHiddenNodes(Window parent, V graph, ZyProximityNode<NodeType> zyNode) {
        LinkedHashSet<Object> toShow = new LinkedHashSet<Object>();
        Set nodes = GraphHelpers.getVisibleNodes(ViewableGraph.wrap(graph));
        toShow.addAll(this.filterVisibleNodes(nodes));
        toShow.addAll(this.filterVisibleNodes(this.getNeighborhood(graph, zyNode)));
        this.showNodes(parent, graph, new ArrayList(toShow), false);
    }

    public void unhideAndSelect(V graph, ZyProximityNode<NodeType> node) {
        ((AbstractZyGraph)graph).selectNodes(this.getNeighborhood(graph, node), true);
    }

    public void unhideAndSelectOnly(V graph, ZyProximityNode<NodeType> node) {
        Collection<U> neighbors = this.getNeighborhood(graph, node);
        List notNeighbors = GraphHelpers.getNodes(graph);
        notNeighbors.removeAll(neighbors);
        ((AbstractZyGraph)graph).selectNodes(neighbors, notNeighbors);
    }

    public void unhideChildren(Window parent, V graph, ZyProximityNode<NodeType> node) {
        ArrayList toShow = new ArrayList();
        Set nodes = GraphHelpers.getVisibleNodes(ViewableGraph.wrap(graph));
        toShow.addAll(nodes);
        toShow.addAll(GraphConverters.convert(graph, GraphAlgorithms.getSuccessors((IGraphNode)((CProximityNode)node.getRawNode()).getAttachedNode())));
        this.showNodes(parent, graph, toShow, true);
    }

    public void unhideParents(Window parent, V graph, ZyProximityNode<NodeType> proximityNode) {
        ArrayList toShow = new ArrayList();
        Set nodes = GraphHelpers.getVisibleNodes(ViewableGraph.wrap(graph));
        toShow.addAll(nodes);
        toShow.addAll(GraphConverters.convert(graph, GraphAlgorithms.getPredecessors((IGraphNode)((CProximityNode)proximityNode.getRawNode()).getAttachedNode())));
        this.showNodes(parent, graph, toShow, true);
    }
}

