/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.nodes;

import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.util.HashSet;

public class NodeHelpers {
    public static <NodeType extends IViewNode<?>> int countInvisibleIndegree(NodeType node) {
        return CollectionHelpers.countIf(node.getIncomingEdges(), new ICollectionFilter<IViewEdge<? extends IViewNode<?>>>(){

            @Override
            public boolean qualifies(IViewEdge<? extends IViewNode<?>> item) {
                return !NodeHelpers.getVisibleNode((IViewNode)item.getSource()).isVisible();
            }
        });
    }

    public static <NodeType extends IViewNode<?>> int countInvisibleIndegreeNeighbours(NodeType node) {
        HashSet<IViewNode> nodeSet = new HashSet<IViewNode>();
        for (IViewEdge edge : node.getIncomingEdges()) {
            IViewNode source = (IViewNode)edge.getSource();
            if (source.isVisible()) continue;
            nodeSet.add(source);
        }
        return nodeSet.size();
    }

    public static <NodeType extends IViewNode<?>> int countInvisibleOutdegree(NodeType node) {
        return CollectionHelpers.countIf(node.getOutgoingEdges(), new ICollectionFilter<IViewEdge<? extends IViewNode<?>>>(){

            @Override
            public boolean qualifies(IViewEdge<? extends IViewNode<?>> item) {
                return !NodeHelpers.getVisibleNode((IViewNode)item.getTarget()).isVisible();
            }
        });
    }

    public static <NodeType extends IViewNode<?>> int countInvisibleOutdegreeNeighbours(NodeType node) {
        HashSet<IViewNode> nodeSet = new HashSet<IViewNode>();
        for (IViewEdge edge : node.getOutgoingEdges()) {
            IViewNode target = (IViewNode)edge.getTarget();
            if (target.isVisible()) continue;
            nodeSet.add(target);
        }
        return nodeSet.size();
    }

    public static IViewNode<?> getVisibleNode(IViewNode<?> node) {
        IViewNode<?> previousNode = node;
        for (IGroupNode<?, ?> parentGroup = node.getParentGroup(); parentGroup != null && parentGroup.isCollapsed(); parentGroup = parentGroup.getParentGroup()) {
            previousNode = parentGroup;
        }
        return previousNode;
    }
}

