/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.helpers;

import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class HtmlGenerator {
    private static Map<String, String> initLineCache = new HashMap<String, String>();

    public static String escapeHtml(String str) {
        StringBuffer buf = new StringBuffer();
        int len = str == null ? 0 : str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char ch2 = str.charAt(i2);
            if (Character.isLetterOrDigit(ch2)) {
                buf.append(ch2);
                continue;
            }
            char c2 = ch2;
            buf.append(new StringBuilder(14).append("&#").append((int)c2).append(";").toString());
        }
        return buf.toString();
    }

    public static String getHtml(Collection<String> strings, String fontname, boolean boldFirstLine) {
        StringBuilder html = new StringBuilder(String.format("<html><font face=\"%s\" size=\"3\" color=\"000000\">", fontname));
        boolean first = true;
        for (String string2 : strings) {
            html.append(boldFirstLine && first ? "<b>" : "");
            html.append(HtmlGenerator.escapeHtml(string2));
            html.append(boldFirstLine && first ? "</b>" : "");
            html.append("<br>");
            first = false;
        }
        html.append("</font></html>");
        return html.toString();
    }

    public static String getHtml(ZyLabelContent content, String fontname, boolean boldFirstLine) {
        return HtmlGenerator.getHtml(content, fontname, boldFirstLine, false);
    }

    public static String getHtml(ZyLabelContent content, String fontname, boolean boldFirstLine, boolean eliminateEmptyLines) {
        if (!initLineCache.containsKey(fontname)) {
            initLineCache.put(fontname, String.format("<html><font face=\"%s\" size=\"3\" color=\"000000\">", fontname));
        }
        StringBuilder html = new StringBuilder(initLineCache.get(fontname));
        int tooltipMaxLength = content.getLineCount() >= 40 ? 40 : content.getLineCount();
        for (int i2 = 0; i2 < tooltipMaxLength; ++i2) {
            String text2 = content.getLineContent(i2).getText();
            if (eliminateEmptyLines && (text2.length() < 1 || text2.equals("\n") || text2.equals("\r") || text2.equals("\t"))) continue;
            html.append(boldFirstLine && i2 == 0 ? "<b>" : "");
            html.append(HtmlGenerator.escapeHtml(text2));
            html.append(boldFirstLine && i2 == 0 ? "</b>" : "");
            html.append("<br>");
        }
        if (content.getLineCount() > 40) {
            html.append("...");
            html.append("<br>");
        }
        html.append("</font></html>");
        return html.toString();
    }

    public static String getHtml(ZyLabelContent contentOne, ZyLabelContent contentTwo, String fontname, boolean boldFirstLine) {
        return HtmlGenerator.getHtml(contentOne, contentTwo, fontname, boldFirstLine, false);
    }

    public static String getHtml(ZyLabelContent contentOne, ZyLabelContent contentTwo, String fontname, boolean boldFirstLine, boolean eliminateEmptyLines) {
        String text2;
        int i2;
        StringBuilder html = new StringBuilder(String.format("<html><font face=\"%s\" size=\"3\" color=\"000000\">", fontname));
        for (i2 = 0; i2 < contentOne.getLineCount(); ++i2) {
            text2 = contentOne.getLineContent(i2).getText();
            if (eliminateEmptyLines && (text2.length() < 1 || text2.equals("\n") || text2.equals("\r") || text2.equals("\t"))) continue;
            html.append(boldFirstLine && i2 == 0 ? "<b>" : "");
            html.append(HtmlGenerator.escapeHtml(contentOne.getLineContent(i2).getText()));
            html.append(boldFirstLine && i2 == 0 ? "</b>" : "");
            html.append("<br>");
        }
        html.append("</font>");
        html.append("<hr></hr>");
        html.append(String.format("<font face=\"%s\" size=\"3\" color=\"000000\">", fontname));
        for (i2 = 0; i2 < contentTwo.getLineCount(); ++i2) {
            text2 = contentTwo.getLineContent(i2).getText();
            if (eliminateEmptyLines && (text2.length() < 1 || text2.equals("\n") || text2.equals("\r") || text2.equals("\t"))) continue;
            html.append(boldFirstLine && i2 == 0 ? "<b>" : "");
            html.append(HtmlGenerator.escapeHtml(contentTwo.getLineContent(i2).getText()));
            html.append(boldFirstLine && i2 == 0 ? "</b>" : "");
            html.append("<br>");
        }
        html.append("</font></html>");
        return html.toString();
    }
}

