/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.helpers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;

public final class ClipboardCopier {
    public static void copyToClipboard(ZyGraphNode<?> node) {
        Preconditions.checkNotNull(node, "Error: Node argument can not be null");
        IZyNodeRealizer realizer = node.getRealizer();
        ZyLabelContent content = realizer.getNodeContent();
        if (content.isSelectable()) {
            ZyLabelContent zyContent = content;
            StringBuilder textBuilder = new StringBuilder();
            for (ZyLineContent zyLineContent : zyContent) {
                textBuilder.append(zyLineContent.getText());
                textBuilder.append("\n");
            }
            ClipboardHelpers.copyToClipboard(textBuilder.toString());
        }
    }

    public static void copyToClipboard(ZyGraphNode<?> node, int line) {
        Preconditions.checkNotNull(node, "Error: Node argument can not be null");
        IZyNodeRealizer realizer = node.getRealizer();
        ZyLabelContent content = realizer.getNodeContent();
        Preconditions.checkArgument(line >= 0 && line < content.getLineCount(), "Error: Line argument is out of bounds");
        if (content.isSelectable()) {
            ZyLabelContent zyContent = content;
            ClipboardHelpers.copyToClipboard(zyContent.getLineContent(line).getText());
        }
    }
}

