/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.sliders;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;

public class DoubleLabeledSlider
extends JPanel {
    private static final long serialVersionUID = 3181291967149555468L;
    private final JSlider m_slider;

    public DoubleLabeledSlider(String leftText, String rightText, int min, int max) {
        this.setLayout(new BorderLayout());
        JLabel leftLabel = new JLabel(leftText);
        this.m_slider = new JSlider(min, max);
        this.m_slider.setMinorTickSpacing(1);
        this.m_slider.setPaintTicks(true);
        this.m_slider.setPaintLabels(true);
        JLabel rightLabel = new JLabel(rightText);
        this.add((Component)leftLabel, "West");
        this.add(this.m_slider);
        this.add((Component)rightLabel, "East");
    }

    public DoubleLabeledSlider(String leftText, String rightText, int min, int max, boolean trackbar, Border border) {
        this(leftText, rightText, min, max);
        this.m_slider.setPaintTrack(trackbar);
        this.setBorder(border);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        DoubleLabeledSlider slider = new DoubleLabeledSlider("Low", "High", 0, 5);
        frame.add(slider);
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 400);
        frame.setVisible(true);
    }

    public int getValue() {
        return this.m_slider.getValue();
    }

    public void setInverted(boolean inverted) {
        this.m_slider.setInverted(inverted);
    }

    public void setValue(int value) {
        this.m_slider.setValue(value);
    }
}

