/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting.console;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessProgressDialog;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressListener;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressModel;
import com.google.security.zynamics.zylib.gui.scripting.AbstractScriptPanel;
import com.google.security.zynamics.zylib.gui.scripting.ConsoleWriter;
import com.google.security.zynamics.zylib.gui.scripting.IScriptConsole;
import com.google.security.zynamics.zylib.gui.scripting.InitStringFactory;
import com.google.security.zynamics.zylib.gui.scripting.console.ConsoleCodeDocument;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.resources.Constants;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;

public class ConsolePane
extends AbstractScriptPanel {
    private static final long serialVersionUID = 3114171042368746418L;
    private final KeyListener m_KeyListener = new InterpreterKeyListener();
    private int m_HistoryPosition = 0;
    private final ArrayList<String> m_LineHistory = new ArrayList();
    private String m_SavedTypedLine = "";
    private final TabCompletionManager m_tabCompletion = new TabCompletionManager();
    private static final boolean m_IsMultilineInput = false;
    private int m_LastAutoCompleteChunkLength = 0;
    private String m_CurrentPrompt;
    private String consoleName;
    private String currentLanguage;
    private IScriptConsole console;
    private ArrayList<Pair<String, Object>> realBindings;
    private ScriptEngine engine;
    private String buffered = "";
    private final TreeSet<String> candidates;
    private String m_libraryPath;

    public ConsolePane() {
        super(new BorderLayout());
        this.updateDocument();
        this.candidates = new TreeSet<String>(this.getDocument().getTabCompletionWords());
        this.getInputPane().addKeyListener(this.m_KeyListener);
        this.getDocument().setInputKeyListener(this.m_KeyListener);
        this.getOutputPane().setFont(new Font(GuiHelper.getMonospaceFont(), 0, 12));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    private void executeInitializer() {
        if (this.m_libraryPath == null) {
            return;
        }
        List<String> extensions = this.engine.getFactory().getExtensions();
        for (String extension2 : extensions) {
            String string2 = this.m_libraryPath;
            String string3 = String.valueOf(File.separator);
            String initFile = new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(extension2).length()).append(string2).append(string3).append("init.").append(extension2).toString();
            if (!FileUtils.exists(initFile)) continue;
            try {
                this.engine.eval(FileUtils.readTextfile(initFile));
                this.getOutputPane().setText(this.console.getOutput());
            }
            catch (IOException | ScriptException e2) {
                this.getOutputPane().setText(e2.getLocalizedMessage());
            }
        }
    }

    private int getCurrentInputLine() {
        return this.getDocument().getLineStartOffset(this.getInputPane().getCaretPosition());
    }

    private String getCurrentLine() {
        int caretPosition = this.getInputPane().getCaretPosition();
        String currentLine = null;
        int skip = this.m_CurrentPrompt.length();
        currentLine = skip < (currentLine = this.getDocument().getCurrentLine(caretPosition).trim()).length() ? currentLine.substring(skip, currentLine.length()) : "";
        return currentLine;
    }

    private ConsoleCodeDocument getDocument() {
        return (ConsoleCodeDocument)this.getInputPane().getDocument();
    }

    private int getLastInputLine() {
        return this.getDocument().getLineStartOffset(this.getInputPane().getText().length());
    }

    private void goToLastLine() {
        this.getInputPane().setCaretPosition(this.getInputPane().getText().length());
    }

    private void interpreterNewLine(boolean additionalInput) {
        int currentPosition;
        int position = this.getInputPane().getCaretPosition();
        if (position == 0) {
            currentPosition = 0;
        } else {
            this.getDocument().insertChar(position, "\n");
            currentPosition = position + 1;
        }
        this.m_CurrentPrompt = additionalInput ? "... " : ">>> ";
        this.getDocument().insertPrompt(currentPosition, this.m_CurrentPrompt);
        this.getInputPane().setCaretPosition(currentPosition + this.m_CurrentPrompt.length());
    }

    private void setCurrentLine(String line) {
        this.goToLastLine();
        this.getDocument().setCurrentLine(this.getInputPane().getCaretPosition(), this.m_CurrentPrompt.length(), line);
    }

    @Override
    protected void initConsole() {
        this.currentLanguage = this.getSelectedLanguage();
        this.console = new ConsoleWriter(new StringWriter());
        this.buffered = InitStringFactory.getInitString(this.currentLanguage, this.consoleName, this.m_libraryPath);
        this.realBindings = this.getBindings();
        if (this.consoleName != null) {
            this.realBindings.add(new Pair<String, IScriptConsole>(this.consoleName, this.console));
        }
        if (this.currentLanguage == null) {
            return;
        }
        this.engine = this.getManager().getEngineByName(this.currentLanguage);
        Preconditions.checkNotNull(this.engine, "Error: Unknown scripting language");
        this.engine.getContext().setWriter(this.console.getWriter());
        for (Pair<String, Object> pair : this.realBindings) {
            this.engine.put(pair.first(), pair.second());
        }
        this.executeInitializer();
    }

    @Override
    protected void updateDocument() {
        this.getInputPane().setDocument(new ConsoleCodeDocument());
        this.interpreterNewLine(false);
    }

    public void setConsoleName(String consoleName) {
        this.consoleName = consoleName;
        this.initConsole();
        this.updateDocument();
    }

    public void setLibraryPath(String libraryPath) {
        this.m_libraryPath = libraryPath;
        this.initConsole();
        this.updateDocument();
    }

    private class TabCompletionManager {
        private int m_completionIndex = 0;

        private TabCompletionManager() {
        }

        private String getCompletionCandidate(String[] candidates, String str, int completionIdx) {
            boolean completionsExist = false;
            for (String element : candidates) {
                if (!element.startsWith(str)) continue;
                completionsExist = true;
                if (completionIdx == 0) {
                    ++this.m_completionIndex;
                    return element;
                }
                --completionIdx;
            }
            if (completionsExist) {
                return this.getCompletionCandidate(candidates, str, completionIdx);
            }
            return null;
        }

        public String getCompletion(String str) {
            return this.getCompletionCandidate(ConsolePane.this.candidates.toArray(new String[0]), str, this.m_completionIndex);
        }

        public void reset() {
            this.m_completionIndex = 0;
        }
    }

    private class InterpreterKeyListener
    extends KeyAdapter {
        private InterpreterKeyListener() {
        }

        private void execute() {
            InternalScriptRunner loader = new InternalScriptRunner();
            CEndlessProgressDialog dlg = new CEndlessProgressDialog(null, ConsolePane.this.getProgressWindowTitle(), Constants.MESSAGE_RUNNING_SCRIPT, loader);
            loader.run();
            dlg.setVisible(true);
            if (loader.quitProperly()) {
                ConsolePane.this.getOutputPane().setText(ConsolePane.this.console.getOutput());
            }
        }

        private void handleBackspace(KeyEvent e2) {
            if (ConsolePane.this.getInputPane().getSelectionStart() == ConsolePane.this.getInputPane().getSelectionEnd() && ConsolePane.this.getDocument().getCaretOffsetInLine(ConsolePane.this.getInputPane().getCaretPosition()) <= ConsolePane.this.m_CurrentPrompt.length()) {
                e2.consume();
            }
        }

        private void handleDownKey(KeyEvent e2) {
            if (ConsolePane.this.m_HistoryPosition < ConsolePane.this.m_LineHistory.size() - 1) {
                ConsolePane.this.setCurrentLine((String)ConsolePane.this.m_LineHistory.get(++ConsolePane.this.m_HistoryPosition));
            } else if (ConsolePane.this.m_HistoryPosition == ConsolePane.this.m_LineHistory.size() - 1) {
                ConsolePane.this.m_HistoryPosition++;
                ConsolePane.this.setCurrentLine(ConsolePane.this.m_SavedTypedLine);
            }
            e2.consume();
        }

        private void handleEnter(KeyEvent e2) {
            ConsolePane.this.goToLastLine();
            String line = ConsolePane.this.getCurrentLine();
            String string2 = ConsolePane.this.buffered;
            ConsolePane.this.buffered = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(line).length()).append(string2).append(line).append("\n").toString();
            ConsolePane.this.m_SavedTypedLine = "";
            if (e2.isControlDown()) {
                this.execute();
                ConsolePane.this.buffered = InitStringFactory.getInitString(ConsolePane.this.currentLanguage, ConsolePane.this.consoleName, ConsolePane.this.m_libraryPath);
                ConsolePane.this.getOutputDocument().flip();
                if (line.trim().length() > 0) {
                    ConsolePane.this.m_LineHistory.add(line);
                }
                ConsolePane.this.m_HistoryPosition = ConsolePane.this.m_LineHistory.size();
                ConsolePane.this.interpreterNewLine(false);
            } else {
                if (line.trim().length() > 0) {
                    ConsolePane.this.m_LineHistory.add(line);
                }
                ConsolePane.this.m_HistoryPosition = ConsolePane.this.m_LineHistory.size();
                ConsolePane.this.interpreterNewLine(true);
                ConsolePane.this.getOutputDocument().flip();
            }
            ConsolePane.this.getDocument().flushRemainingText(ConsolePane.this.getInputPane().getText().length());
            e2.consume();
        }

        private void handleTabKey(KeyEvent e2) {
            String completion;
            int currPos = ConsolePane.this.getInputPane().getCaretPosition() - ConsolePane.this.m_LastAutoCompleteChunkLength;
            String word = ConsolePane.this.getDocument().getWord(currPos);
            if (word.length() > 0 && (completion = ConsolePane.this.m_tabCompletion.getCompletion(word)) != null) {
                String completionChunk = completion.substring(word.length(), completion.length());
                try {
                    ConsolePane.this.getDocument().remove(currPos, ConsolePane.this.m_LastAutoCompleteChunkLength);
                    ConsolePane.this.getDocument().insertString(currPos, completionChunk, null);
                }
                catch (BadLocationException excp) {
                    excp.printStackTrace();
                }
                ConsolePane.this.m_LastAutoCompleteChunkLength = completionChunk.length();
                e2.consume();
            }
        }

        private void handleUpKey(KeyEvent e2) {
            if (ConsolePane.this.m_HistoryPosition > 0) {
                if (ConsolePane.this.m_HistoryPosition == ConsolePane.this.m_LineHistory.size()) {
                    ConsolePane.this.goToLastLine();
                    ConsolePane.this.m_SavedTypedLine = ConsolePane.this.getCurrentLine();
                }
                ConsolePane.this.setCurrentLine((String)ConsolePane.this.m_LineHistory.get(--ConsolePane.this.m_HistoryPosition));
            } else {
                ConsolePane.this.m_HistoryPosition = 0;
            }
            e2.consume();
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            int currLineOffset;
            int lastLineOffset = ConsolePane.this.getLastInputLine();
            if (lastLineOffset != (currLineOffset = ConsolePane.this.getCurrentInputLine())) {
                ConsolePane.this.goToLastLine();
            }
            if (e2.getKeyCode() == 10) {
                this.handleEnter(e2);
            } else if (e2.getModifiers() == 0) {
                if (e2.getKeyCode() == 38) {
                    this.handleUpKey(e2);
                } else if (e2.getKeyCode() == 40) {
                    this.handleDownKey(e2);
                } else if (e2.getKeyCode() == 9) {
                    this.handleTabKey(e2);
                } else if (e2.getKeyCode() == 8) {
                    this.handleBackspace(e2);
                }
                if (e2.getKeyCode() != 9) {
                    ConsolePane.this.m_tabCompletion.reset();
                    ConsolePane.this.m_LastAutoCompleteChunkLength = 0;
                }
            }
        }

        private class InternalScriptRunner
        implements IEndlessProgressModel {
            private final ListenerProvider<IEndlessProgressListener> listeners = new ListenerProvider();
            private Thread m_thread;
            private boolean quitProperly = true;

            private InternalScriptRunner() {
            }

            @Override
            public void addProgressListener(IEndlessProgressListener listener) {
                this.listeners.addListener(listener);
            }

            @Override
            public void closeRequested() {
                this.m_thread.stop();
                for (IEndlessProgressListener listener : this.listeners) {
                    listener.finished();
                }
            }

            public boolean quitProperly() {
                return this.quitProperly;
            }

            @Override
            public void removeProgressListener(IEndlessProgressListener listener) {
                this.listeners.removeListener(listener);
            }

            public void run() {
                this.m_thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ConsolePane.this.engine.eval(ConsolePane.this.buffered);
                        }
                        catch (ScriptException e2) {
                            ConsolePane.this.getOutputPane().setText(e2.getLocalizedMessage());
                            InternalScriptRunner.this.quitProperly = false;
                        }
                        for (IEndlessProgressListener listener : InternalScriptRunner.this.listeners) {
                            listener.finished();
                        }
                    }
                };
                this.m_thread.start();
            }
        }
    }
}

