/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting.console;

import com.google.security.zynamics.zylib.gui.scripting.SyntaxDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;

public class ConsoleHelpers {
    private final SyntaxDocument document;
    private final MutableAttributeSet normal;

    public ConsoleHelpers(SyntaxDocument document, MutableAttributeSet normal) {
        this.document = document;
        this.normal = normal;
    }

    public int getCaretOffsetInLine(int pos) {
        return pos - this.document.getParagraphElement(pos).getStartOffset();
    }

    public String getCurrentLine(int pos) {
        Element element = this.document.getParagraphElement(pos);
        String line = "";
        try {
            line = this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (BadLocationException e2) {
            System.out.println("Bad location!");
            e2.printStackTrace();
        }
        return line;
    }

    public int getLineStartOffset(int position) {
        return this.document.getParagraphElement(position).getStartOffset();
    }

    public MutableAttributeSet getNormal() {
        return this.normal;
    }

    public String getWord(int position) {
        String elementText;
        int offset = position;
        Element element = this.document.getParagraphElement(offset);
        try {
            elementText = this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (Exception excp) {
            return "";
        }
        int elementTextLength = elementText.length();
        if (elementTextLength == 0) {
            return "";
        }
        int i2 = 0;
        if (element.getStartOffset() > 0) {
            offset -= element.getStartOffset();
        }
        for (i2 = offset - 1; i2 >= 0; --i2) {
            char c2 = elementText.charAt(i2);
            if (!this.document.isDelimiter(new StringBuilder(1).append(c2).toString()) && i2 != 0) continue;
            return elementText.substring(i2 + 1, offset).trim();
        }
        return "";
    }
}

