/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting.console;

import com.google.security.zynamics.zylib.gui.scripting.CodeDocumentPython;
import com.google.security.zynamics.zylib.gui.scripting.console.ConsoleHelpers;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ConsoleCodeDocument
extends CodeDocumentPython {
    private static final long serialVersionUID = -4854242616532427400L;
    private final SimpleAttributeSet pythonPromptAttr = new SimpleAttributeSet();
    private KeyListener inputKeyListener;
    private String remainingTextString = null;
    private AttributeSet remainingTextAttr = null;
    private final ConsoleHelpers helpers = new ConsoleHelpers(this, this.normal);

    public ConsoleCodeDocument() {
        super(false);
        this.putProperty("__EndOfLine__", "\n");
        StyleConstants.setForeground(this.pythonPromptAttr, Color.LIGHT_GRAY);
        StyleConstants.setBold(this.pythonPromptAttr, true);
        StyleConstants.setFontSize(this.pythonPromptAttr, 13);
    }

    public void flushRemainingText(int lastPos) {
        if (this.remainingTextString == null) {
            return;
        }
        try {
            this.insertString(lastPos, this.remainingTextString, this.remainingTextAttr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.remainingTextString = null;
        this.remainingTextAttr = null;
    }

    public int getCaretOffsetInLine(int caretPosition) {
        return this.helpers.getCaretOffsetInLine(caretPosition);
    }

    public String getCurrentLine(int caretPosition) {
        return this.helpers.getCurrentLine(caretPosition);
    }

    public int getLineStartOffset(int caretPosition) {
        return this.helpers.getLineStartOffset(caretPosition);
    }

    public String getWord(int currPos) {
        return this.helpers.getWord(currPos);
    }

    public void insertChar(int offs, String str) {
        if (offs < 0) {
            return;
        }
        try {
            super.insertString(offs, str, this.normal);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void insertPrompt(int pos, String prompt) {
        try {
            super.insertString(pos, prompt, this.pythonPromptAttr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet attr) {
        if (offs < 0) {
            return;
        }
        if (str.length() > 1) {
            for (int i2 = 0; i2 < str.length(); ++i2) {
                if (str.charAt(i2) == '\n') {
                    this.remainingTextString = str.substring(i2 + 1);
                    this.remainingTextAttr = attr;
                    this.inputKeyListener.keyPressed(new KeyEvent(new Container(), 401, 0L, 0, 10, '\n'));
                    break;
                }
                char c2 = str.charAt(i2);
                this.insertChar(offs + i2, new StringBuilder(1).append(c2).toString());
            }
        } else if (str.length() == 1) {
            this.insertChar(offs, str);
        }
    }

    public void setCurrentLine(int pos, int skip, String line) {
        Element element = this.getParagraphElement(pos);
        int start = element.getStartOffset();
        int end = element.getEndOffset();
        try {
            this.remove(start + skip, end - (start + skip + 1));
            super.insertString(start + skip, line, this.normal);
        }
        catch (BadLocationException e2) {
            System.out.println("Bad location!");
            e2.printStackTrace();
        }
    }

    public void setInputKeyListener(KeyListener kl) {
        this.inputKeyListener = kl;
    }
}

