/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.security.zynamics.zylib.general.Convert;
import java.awt.Color;
import java.util.HashSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class SyntaxDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 5437418885392724717L;
    private static final int DEFAULT_FONT_SIZE = 13;
    private final DefaultStyledDocument doc;
    private final Element rootElement;
    private boolean multiLineComment;
    private final MutableAttributeSet comment = new SimpleAttributeSet();
    private final MutableAttributeSet keyword = new SimpleAttributeSet();
    private final MutableAttributeSet type = new SimpleAttributeSet();
    private final MutableAttributeSet constant = new SimpleAttributeSet();
    private final MutableAttributeSet number = new SimpleAttributeSet();
    private final MutableAttributeSet quote = new SimpleAttributeSet();
    private final boolean m_addBraces;
    protected final MutableAttributeSet normal = new SimpleAttributeSet();

    public SyntaxDocument(boolean addBraces) {
        this.doc = this;
        this.m_addBraces = addBraces;
        this.rootElement = this.doc.getDefaultRootElement();
        this.putProperty("__EndOfLine__", "\n");
        StyleConstants.setForeground(this.normal, Color.black);
        StyleConstants.setFontSize(this.normal, 13);
        StyleConstants.setForeground(this.comment, Color.gray);
        StyleConstants.setItalic(this.comment, true);
        StyleConstants.setFontSize(this.comment, 13);
        StyleConstants.setForeground(this.keyword, Color.blue.darker());
        StyleConstants.setFontSize(this.keyword, 13);
        StyleConstants.setForeground(this.quote, Color.red);
        StyleConstants.setFontSize(this.quote, 13);
        StyleConstants.setForeground(this.type, Color.PINK.darker());
        StyleConstants.setFontSize(this.type, 13);
        StyleConstants.setForeground(this.number, Color.green.darker());
        StyleConstants.setFontSize(this.number, 13);
        StyleConstants.setForeground(this.constant, Color.red.darker().darker());
        StyleConstants.setFontSize(this.constant, 13);
    }

    private void applyHighlighting(String content, int line) {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.doc.setCharacterAttributes(startOffset, endOffset - startOffset + 1, this.comment, false);
            return;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, this.comment, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private void commentLinesAfter(String content, int line) {
        int offset = this.rootElement.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.doc.setCharacterAttributes(offset, endDelimiter - offset + 1, this.comment, false);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        int offset = this.rootElement.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, this.comment, false);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) {
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token2 = content.substring(startOffset, endOfToken);
        if (this.isKeyword(token2)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword, false);
        } else if (this.isType(token2)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.type, false);
        } else if (this.isConstant(token2)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.constant, false);
        } else if (Convert.isDecString(token2)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.number, false);
        }
        return endOfToken + 1;
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this.quote, false);
        return endOfQuote + 1;
    }

    private void highlightLinesAfter(String content, int line) {
        int delimiter;
        int offset = this.rootElement.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.rootElement.getElementIndex(delimiter);
        for (int i2 = line + 1; i2 < endLine; ++i2) {
            Element branch = this.rootElement.getElement(i2);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as2 = leaf.getAttributes();
            if (!as2.isEqual(this.comment)) continue;
            this.applyHighlighting(content, i2);
        }
    }

    private int indexOf(String content, String needle, int offset) {
        String text2;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text2 = this.getLine(content, index).trim()).startsWith(needle) && !text2.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text2;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text2 = this.getLine(content, index).trim()).startsWith(needle) && !text2.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private void setMultiLineComment(boolean value) {
        this.multiLineComment = value;
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) {
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    protected String addMatchingBrace(int offset) throws BadLocationException {
        String temp;
        StringBuffer whiteSpace = new StringBuffer();
        int line = this.rootElement.getElementIndex(offset);
        int i2 = this.rootElement.getElement(line).getStartOffset();
        while ((temp = this.doc.getText(i2, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i2;
        }
        String string2 = String.valueOf(whiteSpace.toString());
        String string3 = String.valueOf(whiteSpace.toString());
        return new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("{\n").append(string2).append("\t\n").append(string3).append("}").toString();
    }

    protected abstract String getEndDelimiter();

    protected abstract String getEscapeString(String var1);

    protected abstract String getSingleLineDelimiter();

    protected abstract String getStartDelimiter();

    protected abstract HashSet<String> getTabCompletionWords();

    protected abstract boolean isConstant(String var1);

    protected abstract boolean isKeyword(String var1);

    protected abstract boolean isQuoteDelimiter(String var1);

    protected abstract boolean isType(String var1);

    @Override
    public void insertString(int offset, String str, AttributeSet a2) throws BadLocationException {
        if (this.m_addBraces && str.equals("{")) {
            str = this.addMatchingBrace(offset);
        }
        super.insertString(offset, str, a2);
        this.processChangedLines(offset, str.length());
    }

    public abstract boolean isDelimiter(String var1);

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i2 = startLine; i2 <= endLine; ++i2) {
            this.applyHighlighting(content, i2);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }
}

