/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.security.zynamics.zylib.resources.Constants;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

public abstract class ScriptingMenuBar
extends JMenuBar {
    private static final int CTRL_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private final CutAction cutAction = new CutAction();
    private final CopyAction copyAction = new CopyAction();
    private final PasteAction pasteAction = new PasteAction();
    private final ExecuteAgainAction executeAgainAction = new ExecuteAgainAction();
    private File lastExecutedFile = null;

    protected ScriptingMenuBar() {
        JMenu fileMenu = new JMenu(Constants.MENU_FILE);
        fileMenu.addSeparator();
        fileMenu.add(new ExecuteAction());
        fileMenu.add(this.executeAgainAction);
        fileMenu.addSeparator();
        fileMenu.add(new NewConsoleTabAction());
        fileMenu.add(new CloseTabAction());
        this.add(fileMenu);
        JMenu editMenu = new JMenu(Constants.MENU_EDIT);
        editMenu.addSeparator();
        editMenu.add(this.cutAction);
        editMenu.add(this.copyAction);
        editMenu.add(this.pasteAction);
        this.add(editMenu);
    }

    protected abstract void closeTabMenuClicked();

    protected abstract void copyMenuClicked();

    protected abstract void cutMenuClicked();

    protected abstract void executeAgainMenuClicked();

    protected abstract void executeMenuClicked();

    protected File getLastExecutedScriptFile() {
        return this.lastExecutedFile;
    }

    protected abstract void newConsoleTabMenuClicked();

    protected abstract void pasteMenuClicked();

    protected void setLastExecutedScriptFile(File file) {
        this.lastExecutedFile = file;
        this.executeAgainAction.setFile(file);
    }

    public void updateGui(boolean hasOptions) {
        this.cutAction.setEnabled(hasOptions);
        this.copyAction.setEnabled(hasOptions);
        this.pasteAction.setEnabled(hasOptions);
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super(Constants.MENU_EDIT_PASTE);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, CTRL_MASK));
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("page_white_paste.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptingMenuBar.this.pasteMenuClicked();
        }
    }

    private class NewConsoleTabAction
    extends AbstractAction {
        public NewConsoleTabAction() {
            super(Constants.MENU_SCRIPTING_CONSOLE);
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("application_xp_terminal.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptingMenuBar.this.newConsoleTabMenuClicked();
        }
    }

    private class ExecuteAgainAction
    extends AbstractAction {
        public ExecuteAgainAction() {
            super(String.format(Constants.MENU_EXECUTE_AGAIN_SCRIPT, "-"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, CTRL_MASK | 1));
            this.setFile(null);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptingMenuBar.this.executeAgainMenuClicked();
        }

        public void setFile(File file) {
            if (file != null) {
                this.putValue("Name", String.format(Constants.MENU_EXECUTE_AGAIN_SCRIPT, file.getAbsolutePath()));
            } else {
                this.putValue("Name", String.format(Constants.MENU_EXECUTE_AGAIN_SCRIPT, "-"));
            }
            this.setEnabled(file != null);
        }
    }

    private class ExecuteAction
    extends AbstractAction {
        public ExecuteAction() {
            super(Constants.MENU_EXECUTE_SCRIPT);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, CTRL_MASK));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptingMenuBar.this.executeMenuClicked();
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super(Constants.MENU_EDIT_CUT);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, CTRL_MASK));
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("cut.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptingMenuBar.this.cutMenuClicked();
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(Constants.MENU_EDIT_COPY);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, CTRL_MASK));
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("page_white_copy.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptingMenuBar.this.copyMenuClicked();
        }
    }

    private class CloseTabAction
    extends AbstractAction {
        public CloseTabAction() {
            super(Constants.MENU_CLOSE_ACTIVE_TAB);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, CTRL_MASK));
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("folder_delete.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptingMenuBar.this.closeTabMenuClicked();
        }
    }
}

