/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.scripting.IScriptConsole;
import com.google.security.zynamics.zylib.gui.scripting.IScriptConsoleListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ConsoleWriter
extends PrintWriter
implements IScriptConsole {
    private final StringWriter m_writer;
    private final ListenerProvider<IScriptConsoleListener> m_listeners = new ListenerProvider();
    public boolean softspace = false;

    public ConsoleWriter(StringWriter writer) {
        super(writer);
        this.m_writer = writer;
    }

    @Override
    public void addListener(IScriptConsoleListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public String getOutput() {
        return this.m_writer.toString();
    }

    public String getOutputAndClearBuffer() {
        String currentBuffer = this.getOutput();
        this.m_writer.getBuffer().delete(0, this.m_writer.getBuffer().length());
        return currentBuffer;
    }

    @Override
    public Writer getWriter() {
        return this;
    }

    @Override
    public void removeListener(IScriptConsoleListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void write(String s2) {
        super.write(s2);
        for (IScriptConsoleListener listener : this.m_listeners) {
            try {
                listener.changedOutput(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

