/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.security.zynamics.zylib.gui.scripting.SyntaxDocument;
import java.util.HashSet;

public class CodeDocumentPython
extends SyntaxDocument {
    private static final long serialVersionUID = 3801352080461814771L;
    private static HashSet<String> keywords = new HashSet();

    public CodeDocumentPython(boolean addBraces) {
        super(addBraces);
        keywords.add("import");
        keywords.add("for");
        keywords.add("from");
        keywords.add("print");
        keywords.add("in");
        keywords.add("while");
        keywords.add("if");
        keywords.add("is");
        keywords.add("and");
        keywords.add("not");
        keywords.add("or");
        keywords.add("else");
        keywords.add("elif");
        keywords.add("lambda");
        keywords.add("continue");
        keywords.add("break");
        keywords.add("return");
        keywords.add("assert");
        keywords.add("class");
        keywords.add("def");
        keywords.add("del");
        keywords.add("except");
        keywords.add("exec");
        keywords.add("finally");
        keywords.add("global");
        keywords.add("pass");
        keywords.add("raise");
        keywords.add("try");
        keywords.add("yield");
    }

    @Override
    protected String getEndDelimiter() {
        return "\"\"\"";
    }

    @Override
    protected String getEscapeString(String quoteDelimiter) {
        String string2 = String.valueOf(quoteDelimiter);
        return string2.length() != 0 ? "\\".concat(string2) : new String("\\");
    }

    @Override
    protected String getSingleLineDelimiter() {
        return "#";
    }

    @Override
    protected String getStartDelimiter() {
        return "\"\"\"";
    }

    @Override
    protected boolean isConstant(String token2) {
        return token2.equals("True") || token2.equals("False") || token2.equals("None");
    }

    @Override
    protected boolean isKeyword(String token2) {
        return keywords.contains(token2);
    }

    @Override
    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"'";
        return "\"'".indexOf(character) >= 0;
    }

    @Override
    protected boolean isType(String token2) {
        return false;
    }

    @Override
    public HashSet<String> getTabCompletionWords() {
        return keywords;
    }

    @Override
    public boolean isDelimiter(String character) {
        String operands = ";:{}()[]+-/%<=>!&|^~*,";
        return Character.isWhitespace(character.charAt(0)) || ";:{}()[]+-/%<=>!&|^~*,".indexOf(character) != -1;
    }
}

