/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.jtree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeHelpers {
    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e2 = node.children();
            while (e2.hasMoreElements()) {
                TreeNode n2 = e2.nextElement();
                TreePath path = parent.pathByAddingChild(n2);
                TreeHelpers.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private static boolean isDescendant(TreePath path1, TreePath path2) {
        int count2;
        int count1 = path1.getPathCount();
        if (count1 <= (count2 = path2.getPathCount())) {
            return false;
        }
        while (count1 != count2) {
            path1 = path1.getParentPath();
            --count1;
        }
        return path1.equals(path2);
    }

    public static boolean contains(JTree tree, TreeNode node) {
        return TreeHelpers.isAncestor(node, (TreeNode)tree.getModel().getRoot());
    }

    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeHelpers.expandAll(tree, new TreePath(root), expand);
    }

    public static String getExpansionState(JTree tree, int row) {
        TreePath rowPath = tree.getPathForRow(row);
        StringBuffer buf = new StringBuffer();
        int rowCount = tree.getRowCount();
        for (int i2 = row; i2 < rowCount; ++i2) {
            TreePath path = tree.getPathForRow(i2);
            if (i2 != row && !TreeHelpers.isDescendant(path, rowPath)) break;
            if (!tree.isExpanded(path)) continue;
            buf.append(",");
            buf.append(String.valueOf(i2 - row));
        }
        return buf.toString();
    }

    public static List<DefaultMutableTreeNode> getLastExpandedNodes(JTree tree) {
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
        int rowCount = tree.getRowCount();
        for (int i2 = 0; i2 < rowCount; ++i2) {
            TreePath path = tree.getPathForRow(i2);
            DefaultMutableTreeNode lastPathComponent = null;
            try {
                lastPathComponent = (DefaultMutableTreeNode)path.getLastPathComponent();
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Cast failed! JTree must contain DefaultMuteableTreeNode or derived instances.");
            }
            if (!lastPathComponent.isLeaf() && tree.isExpanded(path)) continue;
            nodeList.add((DefaultMutableTreeNode)lastPathComponent.getParent());
        }
        return nodeList;
    }

    public static Object getNodeAt(JTree tree, int x2, int y2) {
        TreePath selPath = tree.getPathForLocation(x2, y2);
        return selPath != null ? selPath.getLastPathComponent() : null;
    }

    public static boolean isAncestor(TreeNode node, TreeNode parent) {
        if (parent == node) {
            return true;
        }
        for (int i2 = 0; i2 < parent.getChildCount(); ++i2) {
            if (!TreeHelpers.isAncestor(node, parent.getChildAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static void restoreExpansionState(JTree tree, int row, String expansionState) {
        StringTokenizer stok = new StringTokenizer(expansionState, ",");
        while (stok.hasMoreTokens()) {
            int token2 = row + Integer.parseInt(stok.nextToken());
            tree.expandRow(token2);
        }
    }
}

