/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.imagecombobox;

import com.google.security.zynamics.zylib.gui.imagecombobox.ImageElement;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class JImageComboBox
extends JComboBox<ImageElement> {
    public JImageComboBox(ImageElement[] items) {
        super(items);
        this.setRenderer(new ComboBoxRenderer(0));
    }

    public JImageComboBox(ImageElement[] items, int labelAlignment) {
        super(items);
        if (labelAlignment != 2 && labelAlignment != 0 && labelAlignment != 4) {
            throw new IllegalArgumentException("Erorr: Label alignment in invalid.");
        }
        this.setRenderer(new ComboBoxRenderer(labelAlignment));
    }

    private static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 2728401247866641230L;
        private Font uhOhFont;

        public ComboBoxRenderer(int alignment) {
            this.setOpaque(true);
            this.setHorizontalAlignment(alignment);
            this.setVerticalAlignment(0);
            if (alignment == 2) {
                this.setBorder(new EmptyBorder(0, 5, 0, 0));
            }
        }

        protected void setUhOhText(String uhOhText, Font normalFont) {
            if (this.uhOhFont == null) {
                this.uhOhFont = normalFont.deriveFont(2);
            }
            this.setFont(this.uhOhFont);
            this.setText(uhOhText);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageElement element = (ImageElement)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (element == null) {
                return this;
            }
            ImageIcon icon = element.getIcon();
            String text2 = element.getObject().toString();
            this.setIcon(icon);
            if (icon != null) {
                this.setText(text2);
                this.setFont(list.getFont());
            } else {
                this.setUhOhText(String.valueOf(text2).concat(" (no image available)"), list.getFont());
            }
            return this;
        }
    }
}

