/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.errordialog;

import com.google.security.zynamics.zylib.general.StackTrace;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public abstract class ErrorDialog
extends JDialog {
    private final String description;
    private final Throwable exception;
    private final String message;

    public ErrorDialog(Window owner, String message2, String description) {
        this(owner, message2, description, null);
    }

    public ErrorDialog(Window owner, String message2, String description, Throwable exception) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.message = message2;
        this.description = description;
        this.exception = exception;
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        this.createGui();
        this.setMinimumSize(new Dimension(600, 400));
        this.setSize(600, 400);
    }

    private void createGui() {
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel messagePanel = new JPanel(new BorderLayout());
        JTextField messageField = new JTextField();
        messageField.setEditable(false);
        messageField.setText(this.message);
        messageField.setBackground(Color.WHITE);
        messagePanel.add(messageField);
        messagePanel.setBorder(new TitledBorder("Error Message"));
        topPanel.add((Component)messagePanel, "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        JTextArea descriptionArea = new JTextArea();
        descriptionArea.setEditable(false);
        descriptionArea.setText(this.description);
        descriptionArea.setLineWrap(true);
        descriptionArea.setWrapStyleWord(true);
        tabbedPane.addTab("Description", descriptionArea);
        if (this.exception != null) {
            JTextArea traceArea = new JTextArea();
            traceArea.setEditable(false);
            traceArea.setText(StackTrace.toString(this.exception.getStackTrace()));
            tabbedPane.addTab("Stack Trace", new JScrollPane(traceArea));
        }
        this.add((Component)topPanel, "North");
        this.add(tabbedPane);
        JPanel bottomButtonPanel = new JPanel(new BorderLayout());
        JPanel leftButtonPanelBottom = new JPanel();
        JButton reportButton = new JButton(new ReportAction());
        reportButton.setMinimumSize(new Dimension(180, reportButton.getHeight()));
        leftButtonPanelBottom.add(reportButton);
        bottomButtonPanel.add((Component)leftButtonPanelBottom, "West");
        JPanel rightButtonPanelBottom = new JPanel();
        JButton okButton = new JButton(new CloseButtonListener());
        this.getRootPane().setDefaultButton(okButton);
        rightButtonPanelBottom.add(okButton);
        bottomButtonPanel.add((Component)rightButtonPanelBottom, "East");
        this.add((Component)bottomButtonPanel, "South");
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        String string2 = String.valueOf(path);
        System.err.println(string2.length() != 0 ? "Couldn't find file: ".concat(string2) : new String("Couldn't find file: "));
        return null;
    }

    protected abstract void report();

    private class ReportAction
    extends AbstractAction {
        private ReportAction() {
            super("Report");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ErrorDialog.this.report();
        }
    }

    private class CloseButtonListener
    extends AbstractAction {
        private CloseButtonListener() {
            super("Close");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ErrorDialog.this.dispose();
        }
    }
}

