/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.dndtree;

import com.google.security.zynamics.zylib.gui.dndtree.DNDTree;
import com.google.security.zynamics.zylib.gui.dndtree.TransferableNode;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTransferHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static DefaultMutableTreeNode draggedNode;
    private static BufferedImage image;
    private final DNDTree tree;
    private final DragSource dragSource;
    private final DropTarget dropTarget;
    private DefaultMutableTreeNode draggedNodeParent;
    private final Rectangle rect2D = new Rectangle();
    private final boolean drawImage;

    protected AbstractTreeTransferHandler(DNDTree tree, int action, boolean drawIcon) {
        this.tree = tree;
        this.drawImage = drawIcon;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(tree, action, this);
        this.dropTarget = new DropTarget(tree, action, this);
    }

    private final void clearImage() {
        this.tree.paintImmediately(this.rect2D.getBounds());
    }

    private final void paintImage(Point pt) {
        if (image != null) {
            this.tree.paintImmediately(this.rect2D.getBounds());
            this.rect2D.setRect((int)pt.getX(), (int)pt.getY(), image.getWidth(), image.getHeight());
            this.tree.getGraphics().drawImage(image, (int)pt.getX(), (int)pt.getY(), this.tree);
        }
    }

    protected abstract boolean canPerformAction(DNDTree var1, DataFlavor var2, Transferable var3, int var4, Point var5);

    protected abstract boolean executeDrop(DNDTree var1, Transferable var2, DefaultMutableTreeNode var3, int var4);

    public abstract boolean canPerformAction(DNDTree var1, DefaultMutableTreeNode var2, int var3, Point var4);

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2 && this.draggedNodeParent != null) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.draggedNodeParent);
        }
    }

    @Override
    public final void dragEnter(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragEnter(DropTargetDragEvent dtde) {
        Transferable transferable;
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (!(transferable = dtde.getTransferable()).isDataFlavorSupported(TransferableNode.NODE_FLAVOR)) {
            if (this.canPerformAction(this.tree, dtde.getCurrentDataFlavorsAsList().get(0), dtde.getTransferable(), action, pt)) {
                dtde.acceptDrag(action);
            } else {
                dtde.rejectDrag();
            }
        } else if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public final void dragExit(DropTargetEvent dte) {
        if (this.drawImage) {
            this.clearImage();
        }
    }

    @Override
    public final void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.tree.getPathForLocation(dge.getDragOrigin().x, dge.getDragOrigin().y);
        if (path != null) {
            draggedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.draggedNodeParent = (DefaultMutableTreeNode)draggedNode.getParent();
            if (this.drawImage) {
                Rectangle pathBounds = this.tree.getPathBounds(path);
                JComponent lbl = (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, draggedNode, false, this.tree.isExpanded(path), ((DefaultTreeModel)this.tree.getModel()).isLeaf(path.getLastPathComponent()), 0, false);
                lbl.setBounds(pathBounds);
                image = new BufferedImage(lbl.getWidth(), lbl.getHeight(), 3);
                Graphics2D graphics = image.createGraphics();
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                lbl.setOpaque(false);
                lbl.paint(graphics);
                graphics.dispose();
            }
            this.dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, image, new Point(0, 0), new TransferableNode(draggedNode), this);
        }
    }

    @Override
    public final void dragOver(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragOver(DropTargetDragEvent dtde) {
        Transferable transferable;
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        this.tree.autoscroll(pt);
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (!(transferable = dtde.getTransferable()).isDataFlavorSupported(TransferableNode.NODE_FLAVOR)) {
            if (this.canPerformAction(this.tree, dtde.getCurrentDataFlavorsAsList().get(0), dtde.getTransferable(), action, pt)) {
                dtde.acceptDrag(action);
            } else {
                dtde.rejectDrag();
            }
        } else if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void drop(DropTargetDropEvent dtde) {
        if (this.drawImage) {
            this.clearImage();
        }
        int action = dtde.getDropAction();
        Transferable transferable = dtde.getTransferable();
        Point pt = dtde.getLocation();
        if (transferable.isDataFlavorSupported(TransferableNode.NODE_FLAVOR) && this.canPerformAction(this.tree, draggedNode, action, pt)) {
            TreePath pathTarget;
            DefaultMutableTreeNode newParentNode;
            boolean gotData = false;
            DefaultMutableTreeNode node = null;
            try {
                node = (DefaultMutableTreeNode)transferable.getTransferData(TransferableNode.NODE_FLAVOR);
                gotData = true;
            }
            catch (IOException e2) {
                System.out.println(e2);
            }
            catch (UnsupportedFlavorException e3) {
                System.out.println(e3);
            }
            if (gotData && this.executeDrop(this.tree, node, newParentNode = (DefaultMutableTreeNode)(pathTarget = this.tree.getPathForLocation(pt.x, pt.y)).getLastPathComponent(), action)) {
                dtde.acceptDrop(action);
                dtde.dropComplete(true);
                return;
            }
        } else if (this.canPerformAction(this.tree, dtde.getCurrentDataFlavors()[0], dtde.getTransferable(), action, pt)) {
            TreePath pathTarget = this.tree.getPathForLocation(pt.x, pt.y);
            DefaultMutableTreeNode newParentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
            if (this.executeDrop(this.tree, dtde.getTransferable(), newParentNode, action)) {
                dtde.acceptDrop(action);
                dtde.dropComplete(true);
                return;
            }
        }
        dtde.rejectDrop();
        dtde.dropComplete(false);
    }

    @Override
    public final void dropActionChanged(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dropActionChanged(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (draggedNode == null) {
            if (this.canPerformAction(this.tree, dtde.getCurrentDataFlavorsAsList().get(0), dtde.getTransferable(), action, pt)) {
                dtde.acceptDrag(action);
            } else {
                dtde.rejectDrag();
            }
        } else if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    public abstract boolean executeDrop(DNDTree var1, DefaultMutableTreeNode var2, DefaultMutableTreeNode var3, int var4);

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    static {
        image = null;
    }
}

