/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.UrlLabel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class UrlLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static MouseListener linker = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent event) {
            UrlLabel self = (UrlLabel)event.getSource();
            if (self.url == null) {
                return;
            }
            try {
                Desktop.getDesktop().browse(self.url.toURI());
            }
            catch (IOException | URISyntaxException e2) {
                System.out.println(e2);
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            event.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }
    };
    private URL url;

    public UrlLabel(String label) {
        super(label);
        this.setForeground(Color.BLUE);
        this.addMouseListener(linker);
    }

    public UrlLabel(String label, String tip) {
        this(label);
        this.setToolTipText(tip);
    }

    public UrlLabel(String label, String tip, URL url) {
        this(label, url);
        this.setToolTipText(tip);
    }

    public UrlLabel(String label, URL url) {
        this(label);
        this.url = url;
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        Border border = this.getBorder();
        int realLeft = 0;
        int realWidth = this.getWidth();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            realWidth -= insets.right;
            realWidth -= insets.left;
            realLeft += insets.left;
        }
        g2.drawLine(realLeft, this.getHeight() - 2, realWidth, this.getHeight() - 2);
    }

    public void setUrl(URL url) {
        this.url = url;
    }
}

