/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import com.google.security.zynamics.zylib.resources.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class CProgressPanel
extends JPanel {
    private static final long serialVersionUID = 8176524035621381995L;
    private final JLabel m_label = new JLabel();
    private final JProgressBar m_progressBar = new JProgressBar();
    private String m_description;
    private final ActionListener m_listener = new InternalActionListener();
    private final ActionListener m_externalCancelButtonListener;
    private final Timer m_timer = new Timer(1000, this.m_listener);
    private int m_seconds = 0;
    private final boolean m_showSeconds;

    public CProgressPanel(String description, boolean indeterminate, boolean showCancelButton) {
        this(description, indeterminate, true, showCancelButton);
    }

    public CProgressPanel(String description, boolean indeterminate, boolean showSeconds, ActionListener cancelButtonListener) {
        this.m_externalCancelButtonListener = Preconditions.checkNotNull(cancelButtonListener, "Error: Cancel button listener can't be null.");
        this.m_description = description;
        this.m_showSeconds = showSeconds;
        this.createPanel(indeterminate, showSeconds, true, true);
    }

    public CProgressPanel(String description, boolean indeterminate, boolean showSeconds, boolean showCancelButton) {
        this.m_description = description;
        this.m_showSeconds = showSeconds;
        this.m_externalCancelButtonListener = null;
        this.createPanel(indeterminate, showSeconds, showCancelButton, false);
    }

    public CProgressPanel(String description, boolean indeterminate, boolean showSeconds, boolean border, boolean showCancelButton) {
        this.m_description = description;
        this.m_showSeconds = showSeconds;
        this.m_externalCancelButtonListener = null;
        this.createPanel(indeterminate, showSeconds, showCancelButton, border);
    }

    private static String convertTextToHtml(String text2) {
        String string2 = String.valueOf(text2.replaceAll("\n", "<br>"));
        return new StringBuilder(13 + String.valueOf(string2).length()).append("<html>").append(string2).append("</html>").toString();
    }

    private void createPanel(boolean indeterminate, boolean showSeconds, boolean showCancelButton, boolean addBorder) {
        this.setLayout(new BorderLayout());
        JPanel pPb = new JPanel(new BorderLayout());
        pPb.setBorder(new TitledBorder(""));
        if (this.m_description == null) {
            this.m_label.setVisible(false);
        } else {
            this.m_label.setText(CProgressPanel.convertTextToHtml(this.m_description));
        }
        pPb.add((Component)this.m_label, "North");
        this.m_progressBar.setIndeterminate(indeterminate);
        this.m_progressBar.setStringPainted(true);
        JPanel borderPanel = new JPanel(new BorderLayout());
        if (addBorder) {
            borderPanel.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.GRAY), new EmptyBorder(1, 1, 1, 1)));
        }
        if (showCancelButton) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            JButton cancelButton = new JButton(new CancelAction());
            cancelButton.setFocusable(false);
            JPanel paddingPanel = new JPanel(new BorderLayout());
            paddingPanel.setBorder(new EmptyBorder(0, 1, 0, 0));
            paddingPanel.setMinimumSize(new Dimension(1, 0));
            buttonPanel.add((Component)paddingPanel, "West");
            buttonPanel.add((Component)cancelButton, "East");
            borderPanel.add((Component)buttonPanel, "East");
        }
        borderPanel.add((Component)this.m_progressBar, "Center");
        pPb.add((Component)borderPanel, "Center");
        if (indeterminate && showSeconds) {
            this.updateSecondsText();
            this.m_timer.setRepeats(true);
        }
        this.add((Component)pPb, "North");
    }

    private void updateSecondsText() {
        this.m_progressBar.setString(String.format("%d seconds", ++this.m_seconds));
    }

    protected void closeRequested() {
    }

    public String fitTextToLabel(String text2) {
        FontMetrics metrics = this.m_label.getFontMetrics(this.m_label.getFont());
        double labelWidth = this.getWidth() - 50;
        boolean fits = false;
        do {
            double textWidth;
            if (labelWidth > (textWidth = (double)metrics.stringWidth(text2))) {
                fits = true;
                continue;
            }
            if (text2.length() <= 4) break;
            text2 = String.valueOf(text2.substring(0, text2.length() - 4)).concat("...");
        } while (!fits && text2.length() > 4);
        return text2;
    }

    public void next() {
        this.m_progressBar.setValue(this.m_progressBar.getValue() + 1);
    }

    public void reset() {
        this.m_progressBar.setValue(0);
    }

    public void setMaximum(int maximum) {
        this.m_progressBar.setMaximum(maximum);
    }

    public void setProgressText(String displayString) {
        this.m_progressBar.setString(displayString);
    }

    public void setSubText(String subDescription) {
        String text2 = String.valueOf(this.fitTextToLabel(this.m_description)).concat("\n");
        String string2 = String.valueOf(text2);
        String string3 = String.valueOf(this.fitTextToLabel(subDescription));
        text2 = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        this.m_label.setText(CProgressPanel.convertTextToHtml(text2));
        new SwingInvoker(){

            @Override
            public void operation() {
                CProgressPanel.this.m_label.updateUI();
            }
        }.invokeLater();
    }

    public void setText(String description) {
        this.m_description = description;
        String text2 = CProgressPanel.convertTextToHtml(description);
        text2 = this.fitTextToLabel(text2);
        this.m_label.setText(text2);
        new SwingInvoker(){

            @Override
            public void operation() {
                CProgressPanel.this.m_label.updateUI();
            }
        }.invokeLater();
    }

    public void setValue(int value) {
        this.m_progressBar.setValue(value);
    }

    public void start() {
        if (this.m_progressBar.isIndeterminate() && this.m_showSeconds) {
            this.m_seconds = 0;
            this.updateSecondsText();
            this.m_timer.start();
        }
    }

    public void stop() {
        if (this.m_progressBar.isIndeterminate() && this.m_showSeconds) {
            this.m_timer.stop();
        }
    }

    private class InternalActionListener
    implements ActionListener {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CProgressPanel.this.updateSecondsText();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 3809222494243730570L;

        public CancelAction() {
            super("", new ImageIcon(Constants.class.getResource("cancel.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (CProgressPanel.this.m_externalCancelButtonListener != null) {
                CProgressPanel.this.m_externalCancelButtonListener.actionPerformed(e2);
            }
            CProgressPanel.this.closeRequested();
        }
    }
}

