/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressListener;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressModel;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.border.EmptyBorder;

public class CEndlessProgressDialog
extends JDialog {
    private boolean m_finished = false;
    private final IEndlessProgressModel m_progressModel;
    private final InternalListener m_internalListener = new InternalListener();
    private final CProgressPanel m_progressPanel;

    public CEndlessProgressDialog(Window parent, String title, String description, IEndlessProgressModel progressModel) {
        super(parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.m_progressModel = progressModel;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new InternalWindowListener());
        progressModel.addProgressListener(this.m_internalListener);
        this.m_progressPanel = new CProgressPanel(description, true, false);
        this.m_progressPanel.start();
        this.m_progressPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setSubDescription("Please wait...");
        this.getContentPane().add(this.m_progressPanel);
        this.pack();
        this.setSubDescription("Please wait...");
        if (parent != null) {
            GuiHelper.centerChildToParent(parent, this, true);
        } else {
            GuiHelper.centerOnScreen(this);
        }
    }

    public static CEndlessProgressDialog show(Window parent, String title, String description, CEndlessHelperThread thread2) {
        CEndlessProgressDialog dlg = new CEndlessProgressDialog(parent, title, description, thread2);
        thread2.start();
        dlg.setVisible(true);
        return dlg;
    }

    public void setDescription(String description) {
        this.m_progressPanel.setText(description);
    }

    public void setSubDescription(String subDescription) {
        this.m_progressPanel.setSubText(subDescription);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.m_finished) {
            try {
                super.setVisible(visible);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class InternalWindowListener
    extends WindowAdapter {
        private InternalWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
            CEndlessProgressDialog.this.m_progressPanel.stop();
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            CEndlessProgressDialog.this.m_progressModel.closeRequested();
        }
    }

    private class InternalListener
    implements IEndlessProgressListener {
        private InternalListener() {
        }

        @Override
        public void changedDescription(String description) {
            CEndlessProgressDialog.this.setSubDescription(description);
        }

        @Override
        public void changedGeneralDescription(String description) {
            CEndlessProgressDialog.this.setDescription(description);
        }

        @Override
        public void finished() {
            CEndlessProgressDialog.this.m_finished = true;
            CEndlessProgressDialog.this.m_progressModel.removeProgressListener(this);
            CEndlessProgressDialog.this.dispose();
        }
    }
}

