/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JStackView;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import com.google.security.zynamics.zylib.gui.JStackView.AddressMode;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModel;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.Timer;

public final class JStackPanel
extends JPanel {
    private static final long serialVersionUID = -7850318708757157383L;
    private static final int PADDING_OFFSETVIEW = 20;
    private static final int PADDING_LEFT = 10;
    private static final int SIZEOF_DWORD = 4;
    private static final int SIZEOF_QWORD = 8;
    private final IStackModel m_model;
    private final Font m_font = new Font(GuiHelper.getMonospaceFont(), 0, 12);
    private int m_rowHeight;
    private int m_charHeight;
    private int m_charWidth;
    private int m_offsetViewWidth;
    private boolean m_firstDraw = true;
    private static final int m_hexElementWidth = 10;
    private final InternalListener m_listener = new InternalListener();
    private int m_firstRow = 0;
    private static final int m_paddingTop = 16;
    private final Color m_fontColorOffsets = Color.WHITE;
    private final Color m_fontColorValues = Color.BLACK;
    private final Color m_disabledColor = Color.GRAY;
    private final Color m_bgColorOffset = Color.GRAY;
    private Timer m_updateTimer;
    private JHexView.DefinitionStatus m_status = JHexView.DefinitionStatus.UNDEFINED;
    private final AddressMode m_addressMode = AddressMode.BIT32;
    private int m_firstColumn = 0;

    public JStackPanel(IStackModel model) {
        super(new BorderLayout());
        Preconditions.checkNotNull(model, "Error: Model argument can not be null");
        this.m_model = model;
        this.m_model.addListener(this.m_listener);
        this.setFocusable(true);
        this.setFont(this.m_font);
        this.setPreferredSize(new Dimension(400, 400));
    }

    private static int getCharacterWidth(Graphics g2) {
        return (int)g2.getFontMetrics().getStringBounds("0", g2).getWidth();
    }

    private static int getCharHeight(Graphics g2) {
        return g2.getFontMetrics().getAscent();
    }

    private static int getRowHeight(Graphics g2) {
        return g2.getFontMetrics().getHeight();
    }

    private void calculateSizes(Graphics g2) {
        this.m_rowHeight = JStackPanel.getRowHeight(g2);
        this.m_charHeight = JStackPanel.getCharHeight(g2);
        this.m_charWidth = JStackPanel.getCharacterWidth(g2);
    }

    private void drawBackground(Graphics g2) {
        g2.setColor(this.m_bgColorOffset);
        g2.fillRect(-this.m_firstColumn * this.m_charWidth, 0, this.m_offsetViewWidth, this.getHeight());
    }

    private void drawElements(Graphics g2) {
        if (this.isEnabled()) {
            g2.setColor(this.m_fontColorValues);
        } else {
            g2.setColor(this.m_disabledColor != this.m_bgColorOffset ? this.m_disabledColor : Color.WHITE);
        }
        int x2 = 10 + this.m_offsetViewWidth - this.m_charWidth * this.m_firstColumn;
        int linesToDraw = this.getNumberOfVisibleRows();
        if (this.m_firstRow + linesToDraw >= this.m_model.getNumberOfEntries() && (linesToDraw = this.m_model.getNumberOfEntries() - this.m_firstRow) < 0) {
            return;
        }
        if (this.m_model.getStartAddress() == -1L) {
            return;
        }
        long elementSize = this.getElementSize();
        if (this.m_status == JHexView.DefinitionStatus.DEFINED) {
            long numberOfBytes;
            long startAddress = this.m_model.getStartAddress() + (long)this.m_firstRow * elementSize;
            if (!this.m_model.hasData(startAddress, numberOfBytes = (long)linesToDraw * elementSize)) {
                this.setDefinitionStatus(JHexView.DefinitionStatus.UNDEFINED);
                this.setEnabled(false);
                if (this.m_updateTimer != null) {
                    this.m_updateTimer.setRepeats(false);
                    this.m_updateTimer.stop();
                }
                this.m_updateTimer = new Timer(1000, new WaitingForDataAction(startAddress, numberOfBytes));
                this.m_updateTimer.setRepeats(true);
                this.m_updateTimer.start();
                return;
            }
            for (int i2 = 0; i2 < linesToDraw; ++i2) {
                long elementAddress = startAddress + (long)i2 * elementSize;
                g2.drawString(this.m_model.getElement(elementAddress), x2, 16 + i2 * this.m_rowHeight);
            }
        } else {
            for (int i3 = 0; i3 < linesToDraw; ++i3) {
                g2.drawString(Strings.repeat("?", 2 * this.getElementSize()), x2, 16 + i3 * this.m_rowHeight);
            }
        }
    }

    private void drawOffsets(Graphics g2) {
        int linesToDraw = this.getNumberOfVisibleRows();
        String formatString = this.m_addressMode == AddressMode.BIT32 ? "%08X" : "%016X";
        long elementSize = this.getElementSize();
        long baseAddress = this.m_model.getStartAddress() == -1L ? 0L : this.m_model.getStartAddress();
        for (int i2 = 0; i2 < linesToDraw; ++i2) {
            int elementIndex = this.m_firstRow + i2;
            long elementAddress = baseAddress + (long)elementIndex * elementSize;
            String offsetString = String.format(formatString, elementAddress);
            if (elementAddress == this.m_model.getStackPointer()) {
                this.highlightStackPointer(g2, i2);
            }
            if (this.isEnabled()) {
                g2.setColor(this.m_fontColorOffsets);
            } else {
                g2.setColor(this.m_disabledColor != this.m_bgColorOffset ? this.m_disabledColor : Color.WHITE);
            }
            g2.drawString(offsetString, 10 - this.m_charWidth * this.m_firstColumn, 16 + i2 * this.m_rowHeight);
        }
    }

    private int getElementSize() {
        return this.m_addressMode == AddressMode.BIT32 ? 4 : 8;
    }

    private void highlightStackPointer(Graphics g2, int row) {
        g2.setColor(Color.RED);
        double width = g2.getFontMetrics().getStringBounds(Strings.repeat("0", 2 * this.getElementSize()), g2).getWidth();
        g2.fillRect(8 - this.m_charWidth * this.m_firstColumn, 16 + row * this.m_rowHeight - this.m_charHeight, (int)width + 4, this.m_charHeight + 2);
    }

    private void updateOffsetViewWidth() {
        int addressBytes = this.m_addressMode == AddressMode.BIT32 ? 8 : 16;
        this.m_offsetViewWidth = 20 + this.m_charWidth * addressBytes;
    }

    private void updatePreferredSize() {
        int width = this.m_offsetViewWidth + 10 + 18 * this.m_charWidth;
        this.setPreferredSize(new Dimension(width, this.getHeight()));
        this.revalidate();
    }

    protected int getNumberOfVisibleRows() {
        if (this.m_rowHeight == 0) {
            return 0;
        }
        int rawHeight = this.getHeight() - 16;
        return rawHeight / this.m_rowHeight + (rawHeight % this.m_rowHeight == 0 ? 0 : 1);
    }

    protected void setFirstRow(int value) {
        this.m_firstRow = value;
        this.repaint();
    }

    public int getCharWidth() {
        return this.m_charWidth;
    }

    public int getOffsetViewWidth() {
        return this.m_offsetViewWidth;
    }

    public String getValueAt(Point point) {
        int line = (point.y - 16 + this.m_rowHeight) / this.m_rowHeight;
        long elementSize = this.getElementSize();
        long startAddress = this.m_model.getStartAddress() + (long)this.m_firstRow * elementSize;
        long elementAddress = startAddress + (long)line * elementSize;
        return this.m_model.hasData(elementAddress, elementSize) ? this.m_model.getElement(elementAddress) : null;
    }

    public void gotoOffset(long offset) {
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        this.calculateSizes(g2);
        this.updateOffsetViewWidth();
        if (this.m_firstDraw) {
            this.m_firstDraw = false;
            this.updatePreferredSize();
        }
        this.drawBackground(g2);
        this.drawOffsets(g2);
        this.drawElements(g2);
    }

    public void setDefinitionStatus(JHexView.DefinitionStatus status) {
        Preconditions.checkNotNull(status, "Error: Status argument can not be null");
        this.m_status = status;
        this.repaint();
    }

    public void setFirstColumn(int value) {
        this.m_firstColumn = value;
    }

    private class WaitingForDataAction
    extends AbstractAction {
        private static final long serialVersionUID = -610823391617272365L;
        private final long m_startAddress;
        private final long m_numberOfBytes;

        private WaitingForDataAction(long startAddress, long numberOfBytes) {
            this.m_startAddress = startAddress;
            this.m_numberOfBytes = numberOfBytes;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (JStackPanel.this.m_model.hasData(this.m_startAddress, this.m_numberOfBytes)) {
                JStackPanel.this.setEnabled(true);
                JStackPanel.this.setDefinitionStatus(JHexView.DefinitionStatus.DEFINED);
                ((Timer)event.getSource()).stop();
            } else if (!JStackPanel.this.m_model.keepTrying()) {
                ((Timer)event.getSource()).stop();
            }
        }
    }

    private class InternalListener
    implements IStackModelListener {
        private InternalListener() {
        }

        @Override
        public void dataChanged() {
            JStackPanel.this.repaint();
        }
    }
}

