/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JRegisterView;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.JCaret.ICaretListener;
import com.google.security.zynamics.zylib.gui.JCaret.JCaret;
import com.google.security.zynamics.zylib.gui.JRegisterView.IMenuProvider;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegisterModel;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegistersChangedListener;
import com.google.security.zynamics.zylib.gui.JRegisterView.RegisterInformationInternal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.math.BigInteger;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;

public class JRegisterView
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = -918576778293064213L;
    private final Font m_font = new Font(GuiHelper.getMonospaceFont(), 0, 12);
    private final IRegisterModel m_registerModel;
    private int m_longestRegisterName = 0;
    private int m_highlightedRegister = -1;
    private int m_charWidth;
    private final Color m_modifiedColor = Color.RED;
    private final Color m_textColor = Color.BLACK;
    private static final int m_paddingLeft = 10;
    private final Color m_bgColorEdit = new Color(16765152);
    private final Color m_bgColorHighlight = Color.WHITE;
    private int m_editedRegister = -1;
    private final JCaret m_caret = new JCaret();
    private int m_caretPosition = 0;
    private BigInteger m_editValue = BigInteger.ZERO;
    private final Color m_backgroundColor = new Color(0xCCCCFF);
    private final Color m_disabledColor = Color.GRAY;
    private IMenuProvider m_menuProvider;
    private final InternalListener m_listener = new InternalListener();

    public JRegisterView(IRegisterModel registerModel) {
        Preconditions.checkNotNull(registerModel, "Error: Argument registerModel can't be null");
        registerModel.addListener(this.m_listener);
        this.setFocusable(true);
        this.setOpaque(true);
        this.initializeListeners();
        this.m_registerModel = registerModel;
        this.updateLongestRegisterName();
        this.setBackground(this.m_backgroundColor);
        this.updatePreferredSize();
    }

    private void drawCaret(Graphics g2) {
        if (this.hasFocus() && this.m_editedRegister != -1) {
            Rectangle r2 = this.getRegisterBounds(this.m_editedRegister);
            int characterHeight = this.m_font.getSize();
            int x2 = r2.x + this.m_caretPosition * this.m_charWidth + this.m_longestRegisterName * this.m_charWidth + 5 - 1;
            int y2 = r2.y;
            this.m_caret.draw(g2, x2, y2, characterHeight);
        }
    }

    private void drawHighlightedRegister(Graphics g2) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_editedRegister != -1) {
            g2.setColor(this.m_bgColorEdit);
            Rectangle r2 = this.getRegisterBounds(this.m_editedRegister);
            g2.fillRect(r2.x, r2.y, r2.width, r2.height);
        } else if (this.m_highlightedRegister != -1) {
            g2.setColor(this.m_bgColorHighlight);
            Rectangle r3 = this.getRegisterBounds(this.m_highlightedRegister);
            g2.fillRect(r3.x, r3.y, r3.width, r3.height);
        }
    }

    private void drawRegisters(Graphics g2) {
        int PADDING_TOP;
        int y2 = PADDING_TOP = this.m_font.getSize() + 5;
        int lineHeight = this.m_font.getSize();
        int registerCounter = 0;
        for (RegisterInformationInternal register2 : this.m_registerModel.getRegisterInformation()) {
            String valueString;
            if (this.isEnabled()) {
                g2.setColor(register2.isModified() || registerCounter == this.m_editedRegister ? this.m_modifiedColor : this.m_textColor);
            } else {
                g2.setColor(this.m_disabledColor);
            }
            g2.drawString(register2.getRegisterName(), 10, y2);
            BigInteger value = (registerCounter == this.m_editedRegister ? this.m_editValue : register2.getValue()).and(register2.getRegisterSize() == 8 ? BigInteger.valueOf(Long.MAX_VALUE) : BigInteger.valueOf(0xFFFFFFFFL));
            if (register2.getRegisterSize() != 0) {
                int n2 = 2 * register2.getRegisterSize();
                String formatMask = new StringBuilder(14).append("%0").append(n2).append("X").toString();
                valueString = String.format(formatMask, value);
            } else {
                valueString = String.valueOf(value.and(BigInteger.ONE));
            }
            g2.drawString(valueString, 15 + this.m_charWidth * this.m_longestRegisterName, y2);
            ++registerCounter;
            y2 += lineHeight;
        }
    }

    private void enterEditMode(int register2) {
        this.requestFocusInWindow();
        this.m_caret.setVisible(true);
        this.m_editedRegister = register2;
        this.m_caretPosition = 0;
        this.m_editValue = this.m_registerModel.getRegisterInformation(register2).getValue();
        this.repaint();
    }

    private Rectangle getRegisterBounds(int registerNumber) {
        RegisterInformationInternal register2 = this.m_registerModel.getRegisterInformation(registerNumber);
        int x2 = 10;
        int y2 = 7 + registerNumber * this.m_font.getSize();
        int width = 5 + this.m_charWidth * (this.m_longestRegisterName + register2.getRegisterSize() * 2);
        int height = this.m_font.getSize() - 1;
        return new Rectangle(10, y2, width, height);
    }

    private int getRegisterNumber(int x2, int y2) {
        int lineHeight = this.m_font.getSize();
        if (y2 >= 7 && y2 <= 7 + lineHeight * this.m_registerModel.getNumberOfRegisters()) {
            int registerNumber = (y2 - 7) / lineHeight;
            if ((registerNumber = Math.min(registerNumber, this.m_registerModel.getNumberOfRegisters() - 1)) == -1) {
                return -1;
            }
            RegisterInformationInternal r2 = this.m_registerModel.getRegisterInformation(registerNumber);
            int valuePrintSize = r2.getRegisterSize() == 0 ? 1 : r2.getRegisterSize() * 2;
            int maxWidth = 15 + this.m_charWidth * (this.m_longestRegisterName + valuePrintSize);
            if (x2 >= 10 && x2 <= maxWidth) {
                return registerNumber;
            }
        }
        return -1;
    }

    private void initializeListeners() {
        this.addMouseListener(this.m_listener);
        this.addMouseMotionListener(this.m_listener);
        this.addKeyListener(this.m_listener);
        this.addFocusListener(this.m_listener);
        this.m_caret.addCaretListener(this.m_listener);
    }

    private void leaveEditMode(boolean update) {
        RegisterInformationInternal editedRegister;
        if (update && !Objects.equals(this.m_editValue, (editedRegister = this.m_registerModel.getRegisterInformation(this.m_editedRegister)).getValue())) {
            this.beginRegisterUpdate();
            this.m_registerModel.setValue(editedRegister.getRegisterName(), this.m_editValue);
            this.endRegisterUpdate();
        }
        this.m_caret.setVisible(false);
        this.m_editedRegister = -1;
        this.m_caretPosition = 0;
        this.repaint();
    }

    private void updateLongestRegisterName() {
        this.m_longestRegisterName = Integer.MIN_VALUE;
        for (RegisterInformationInternal register2 : this.m_registerModel.getRegisterInformation()) {
            if (register2.getRegisterName().length() <= this.m_longestRegisterName) continue;
            this.m_longestRegisterName = register2.getRegisterName().length();
        }
    }

    private void updatePreferredSize() {
        int PADDING_TOP = this.m_font.getSize() + 5;
        int lineHeight = this.m_font.getSize();
        int height = PADDING_TOP + this.m_registerModel.getNumberOfRegisters() * lineHeight;
        this.setPreferredSize(new Dimension(200, height));
        this.revalidate();
        this.updateUI();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        g2.setFont(this.m_font);
        this.m_charWidth = (int)g2.getFontMetrics().getStringBounds("0", g2).getWidth();
        if (this.m_registerModel != null) {
            this.drawHighlightedRegister(g2);
            this.drawRegisters(g2);
            if (this.m_caret.isVisible()) {
                this.drawCaret(g2);
            }
        }
    }

    public void beginRegisterUpdate() {
        for (RegisterInformationInternal register2 : this.m_registerModel.getRegisterInformation()) {
            register2.setModified(false);
        }
    }

    public void dispose() {
        this.removeMouseListener(this.m_listener);
        this.removeMouseMotionListener(this.m_listener);
        this.removeKeyListener(this.m_listener);
        this.removeFocusListener(this.m_listener);
        this.m_caret.removeListener(this.m_listener);
        this.m_caret.stop();
    }

    public void endRegisterUpdate() {
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5 * this.m_font.getSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.m_font.getSize();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.repaint();
    }

    public void setMenuProvider(IMenuProvider provider) {
        this.m_menuProvider = provider;
    }

    private class InternalListener
    implements MouseMotionListener,
    MouseListener,
    KeyListener,
    FocusListener,
    ICaretListener,
    IRegistersChangedListener {
        private InternalListener() {
        }

        private int hexToValue(char c2) {
            if (c2 >= 'A' && c2 <= 'F') {
                return c2 - 65 + 10;
            }
            if (c2 >= 'a' && c2 <= 'f') {
                return c2 - 97 + 10;
            }
            return c2 - 48;
        }

        private boolean isHexChar(char c2) {
            return c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F' || c2 >= '0' && c2 <= '9';
        }

        @Override
        public void caretStatusChanged(JCaret source) {
            JRegisterView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (JRegisterView.this.m_editedRegister != 1) {
                JRegisterView.this.leaveEditMode(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 39) {
                if (JRegisterView.this.m_caretPosition != 2 * JRegisterView.this.m_registerModel.getRegisterInformation(JRegisterView.this.m_editedRegister).getRegisterSize()) {
                    JRegisterView.this.m_caretPosition++;
                }
                event.consume();
                JRegisterView.this.m_caret.setVisible(true);
                JRegisterView.this.repaint();
            } else if (event.getKeyCode() == 37) {
                if (JRegisterView.this.m_caretPosition != 0) {
                    JRegisterView.this.m_caretPosition--;
                }
                event.consume();
                JRegisterView.this.m_caret.setVisible(true);
                JRegisterView.this.repaint();
            } else if (event.getKeyCode() == 10) {
                if (JRegisterView.this.m_editedRegister == -1) {
                    if (JRegisterView.this.m_highlightedRegister != -1) {
                        JRegisterView.this.enterEditMode(JRegisterView.this.m_highlightedRegister);
                    }
                } else {
                    JRegisterView.this.leaveEditMode(true);
                }
                JRegisterView.this.repaint();
            } else if (this.isHexChar(event.getKeyChar())) {
                int regSize = JRegisterView.this.m_registerModel.getRegisterInformation(JRegisterView.this.m_editedRegister).getRegisterSize();
                if (JRegisterView.this.m_caretPosition == 2 * regSize) {
                    return;
                }
                long val = this.hexToValue(event.getKeyChar());
                long relevantBits = regSize * 8 - 4 - JRegisterView.this.m_caretPosition * 4;
                long mask = 15L << (int)relevantBits;
                long shiftedNew = val << (int)relevantBits;
                JRegisterView.this.m_editValue = JRegisterView.this.m_editValue.and(BigInteger.valueOf(mask ^ 0xFFFFFFFFFFFFFFFFL)).or(BigInteger.valueOf(shiftedNew));
                JRegisterView.this.m_caretPosition++;
                JRegisterView.this.m_caret.setVisible(true);
                JRegisterView.this.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int registerNumber = JRegisterView.this.getRegisterNumber(event.getX(), event.getY());
            if (event.getButton() == 1) {
                if (event.getClickCount() == 1) {
                    if (JRegisterView.this.m_editedRegister != -1 && registerNumber != JRegisterView.this.m_editedRegister) {
                        JRegisterView.this.leaveEditMode(false);
                    }
                } else if (event.getClickCount() == 2 && registerNumber != -1 && JRegisterView.this.m_editedRegister == -1) {
                    RegisterInformationInternal register2 = JRegisterView.this.m_registerModel.getRegisterInformation(registerNumber);
                    if (register2.getRegisterSize() == 0) {
                        JRegisterView.this.m_registerModel.setValue(register2.getRegisterName(), register2.getValue().xor(BigInteger.ONE));
                    } else {
                        JRegisterView.this.enterEditMode(JRegisterView.this.m_highlightedRegister);
                    }
                }
            } else if (event.getButton() == 3 && event.getClickCount() == 1) {
                JPopupMenu menu;
                if (JRegisterView.this.m_editedRegister != -1 && registerNumber != JRegisterView.this.m_editedRegister) {
                    JRegisterView.this.leaveEditMode(false);
                }
                if ((menu = JRegisterView.this.m_menuProvider.getRegisterMenu(registerNumber)) != null) {
                    menu.show(JRegisterView.this, event.getX(), event.getY());
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (JRegisterView.this.m_editedRegister == -1) {
                JRegisterView.this.m_highlightedRegister = -1;
                JRegisterView.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            JRegisterView.this.m_highlightedRegister = JRegisterView.this.getRegisterNumber(event.getX(), event.getY());
            JRegisterView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void registerDataChanged() {
            JRegisterView.this.updatePreferredSize();
            JRegisterView.this.updateLongestRegisterName();
            JRegisterView.this.repaint();
        }
    }
}

