/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JHexPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.JCaret.ICaretListener;
import com.google.security.zynamics.zylib.gui.JCaret.JCaret;
import com.google.security.zynamics.zylib.gui.JHexPanel.ColoredRange;
import com.google.security.zynamics.zylib.gui.JHexPanel.ColoredRangeManager;
import com.google.security.zynamics.zylib.gui.JHexPanel.IColormap;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataChangedListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataProvider;
import com.google.security.zynamics.zylib.gui.JHexPanel.IHexPanelListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.IMenuCreator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public final class JHexView
extends JComponent {
    private static final long serialVersionUID = -2402458562501988128L;
    private static final int CHARACTERS_PER_BYTE = 2;
    private static final String[] HEX_BYTES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
    private static final int PADDING_OFFSETVIEW = 20;
    private static final int NIBBLES_PER_BYTE = 2;
    private final ArrayList<IHexPanelListener> m_listeners = new ArrayList();
    private IDataProvider m_dataProvider;
    private int m_bytesPerRow = 16;
    private Font m_font = new Font(GuiHelper.getMonospaceFont(), 0, 12);
    private long m_selectionStart = 0L;
    private long m_selectionLength = 0L;
    private Views m_activeView = Views.HEX_VIEW;
    private int m_hexViewWidth = 270;
    private int m_columnSpacing = 4;
    private int m_bytesPerColumn = 2;
    private Color m_bgColorOffset = Color.GRAY;
    private Color m_bgColorHex = Color.WHITE;
    private Color m_bgColorAscii = Color.WHITE;
    private Color m_fontColorOffsets = Color.WHITE;
    private Color m_fontColorHex1 = Color.BLUE;
    private Color m_fontColorHex2 = new Color(0x3399FF);
    private Color m_fontColorAscii = new Color(0x339900);
    private int m_rowHeight = 12;
    private int m_charWidth = 8;
    private final JScrollBar m_scrollbar = new JScrollBar(1, 0, 1, 0, 1);
    private final JScrollBar m_horizontalScrollbar = new JScrollBar(0, 0, 1, 0, 1);
    private int m_firstRow = 0;
    private int m_firstColumn = 0;
    private long m_baseAddress = 0L;
    private int m_lastMouseX = 0;
    private int m_lastMouseY = 0;
    private boolean m_enabled = false;
    private final Color m_disabledColor = Color.GRAY;
    private final JCaret m_caret = new JCaret();
    private static final int m_paddingHexLeft = 10;
    private static final int m_paddingAsciiLeft = 10;
    private static final int m_paddingTop = 16;
    private int m_charHeight = 8;
    private final Color m_colorHighlight = Color.LIGHT_GRAY;
    private DefinitionStatus m_status = DefinitionStatus.UNDEFINED;
    private IMenuCreator m_menuCreator;
    private AddressMode m_addressMode = AddressMode.BIT32;
    private int m_offsetViewWidth;
    private final ColoredRangeManager[] m_coloredRanges = new ColoredRangeManager[10];
    private Graphics bufferGraphics;
    private BufferedImage img;
    private Timer m_updateTimer;
    private boolean m_firstDraw = true;
    private final InternalListener m_listener = new InternalListener();
    private final LeftAction m_leftAction = new LeftAction();
    private final RightAction m_rightAction = new RightAction();
    private final UpAction m_upAction = new UpAction();
    private final DownAction m_downAction = new DownAction();
    private final PageUpAction m_pageUpAction = new PageUpAction();
    private final PageDownAction m_pageDownAction = new PageDownAction();
    private final TabAction m_tabAction = new TabAction();
    private int m_lastHighlightedNibble;
    private IColormap m_colormap;
    private Color m_selectionColor = Color.YELLOW;
    private boolean m_flipBytes = false;

    public JHexView() {
        for (int i2 = 0; i2 < this.m_coloredRanges.length; ++i2) {
            this.m_coloredRanges[i2] = new ColoredRangeManager();
        }
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setFont(this.m_font);
        this.initListeners();
        this.initHotkeys();
        this.initScrollbar();
        this.img = new BufferedImage(this.getWidth() + 1 - this.m_scrollbar.getWidth(), this.getHeight() + 1 - this.m_horizontalScrollbar.getHeight(), 1);
        this.bufferGraphics = this.img.getGraphics();
        this.updateOffsetViewWidth();
        this.setEnabled(false);
    }

    private void calculateSizes() {
        this.m_rowHeight = this.getRowHeight(this.bufferGraphics);
        this.m_charHeight = this.getCharHeight(this.bufferGraphics);
        this.m_charWidth = this.getCharacterWidth(this.bufferGraphics);
    }

    private void changeBy(ActionEvent event, int length) {
        if (event.getModifiers() == 1) {
            if (this.getSelectionStart() + this.getSelectionLength() + (long)length < 0L) {
                this.setSelectionLength(-this.getSelectionStart());
            } else if (this.getSelectionStart() + this.getSelectionLength() + (long)length < (long)(2 * this.m_dataProvider.getDataLength())) {
                this.setSelectionLength(this.getSelectionLength() + (long)length);
            } else {
                this.setSelectionLength((long)(2 * this.m_dataProvider.getDataLength()) - this.getSelectionStart());
            }
        } else {
            if (this.getSelectionStart() + this.getSelectionLength() + (long)length < 0L) {
                this.setSelectionStart(0L);
            } else if (this.getSelectionStart() + this.getSelectionLength() + (long)length < (long)(2 * this.m_dataProvider.getDataLength())) {
                this.setSelectionStart(this.getSelectionStart() + this.getSelectionLength() + (long)length);
            } else {
                this.setSelectionStart(2 * this.m_dataProvider.getDataLength());
            }
            this.setSelectionLength(0L);
        }
        long newPosition = this.getSelectionStart() + this.getSelectionLength();
        if (newPosition < (long)(2 * this.getFirstVisibleByte())) {
            this.scrollToPosition(newPosition);
        } else if (newPosition >= (long)(2 * (this.getFirstVisibleByte() + this.getMaximumVisibleBytes()))) {
            long invisibleNibbles = newPosition - (long)(2 * (this.getFirstVisibleByte() + this.getMaximumVisibleBytes()));
            long scrollpos = (long)(2 * this.getFirstVisibleByte() + 2 * this.m_bytesPerRow) + invisibleNibbles;
            this.scrollToPosition(scrollpos);
        }
        this.m_caret.setVisible(true);
        this.repaint();
    }

    private void drawAsciiPanel(Graphics g2) {
        int bytesToDraw;
        int initx;
        if (this.isEnabled()) {
            g2.setColor(this.m_fontColorAscii);
        } else {
            g2.setColor(this.m_disabledColor != this.m_bgColorAscii ? this.m_disabledColor : Color.WHITE);
        }
        int characterWidth = this.getCharacterWidth(g2);
        int x2 = initx = this.getAsciiViewLeft() + 10;
        int y2 = 16;
        byte[] data = null;
        if (this.m_status == DefinitionStatus.DEFINED) {
            bytesToDraw = this.getBytesToDraw();
            data = this.m_dataProvider.getData(this.getFirstVisibleOffset(), bytesToDraw);
        } else {
            bytesToDraw = this.getMaximumVisibleBytes();
        }
        long currentOffset = this.getFirstVisibleOffset();
        int i2 = 0;
        while (i2 < bytesToDraw) {
            ColoredRange range = this.findColoredRange(currentOffset);
            if (range != null && currentOffset + (long)bytesToDraw < range.getStart()) {
                range = null;
            }
            if (i2 != 0 && i2 % this.m_bytesPerRow == 0) {
                x2 = initx;
                y2 += this.m_rowHeight;
            }
            if (this.m_status == DefinitionStatus.DEFINED) {
                int c2 = data[i2];
                c2 = Convert.isPrintableCharacter((char)c2) ? c2 : 46;
                String dataString = String.valueOf((char)c2);
                if (this.isEnabled()) {
                    long normalizedOffset;
                    long l2 = normalizedOffset = this.m_flipBytes ? (currentOffset & (long)(-this.m_bytesPerColumn)) + (long)this.m_bytesPerColumn - currentOffset % (long)this.m_bytesPerColumn - 1L : currentOffset;
                    if (this.isSelectedOffset(normalizedOffset)) {
                        g2.setColor(this.m_selectionColor);
                        g2.fillRect(x2, y2 - this.m_charHeight, this.m_charWidth, this.m_charHeight + 2);
                        g2.setColor(this.m_fontColorAscii);
                    } else if (range != null && range.containsOffset(currentOffset)) {
                        Color bgColor = range.getBackgroundColor();
                        if (bgColor != null) {
                            g2.setColor(bgColor);
                        } else {
                            System.out.println("FOO");
                        }
                        g2.fillRect(x2, y2 - this.m_charHeight, this.m_charWidth, this.m_charHeight + 2);
                        g2.setColor(range.getColor());
                    } else if (this.m_colormap != null && this.m_colormap.colorize(data, i2)) {
                        Color backgroundColor = this.m_colormap.getBackgroundColor(data, i2);
                        Color foregroundColor = this.m_colormap.getForegroundColor(data, i2);
                        if (backgroundColor != null) {
                            g2.setColor(backgroundColor);
                            g2.fillRect(x2, y2 - this.m_charHeight, this.m_charWidth, this.m_charHeight + 2);
                        }
                        if (foregroundColor != null) {
                            g2.setColor(foregroundColor);
                        }
                    } else {
                        g2.setColor(this.m_fontColorAscii);
                    }
                } else {
                    g2.setColor(this.m_disabledColor != this.m_bgColorAscii ? this.m_disabledColor : Color.WHITE);
                }
                g2.drawString(dataString, x2, y2);
            } else {
                g2.drawString("?", x2, y2);
            }
            x2 += characterWidth;
            if (range != null && range.getStart() + (long)range.getSize() <= currentOffset && (range = this.findColoredRange(currentOffset)) != null && currentOffset + (long)bytesToDraw < range.getStart()) {
                range = null;
            }
            ++i2;
            ++currentOffset;
        }
    }

    private void drawBackground(Graphics g2) {
        g2.setColor(this.m_bgColorOffset);
        g2.fillRect(-this.m_firstColumn * this.m_charWidth, 0, this.m_offsetViewWidth, this.getHeight());
        g2.setColor(this.m_bgColorHex);
        g2.fillRect(-this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth, 0, this.m_hexViewWidth, this.getHeight());
        g2.setColor(this.m_bgColorAscii);
        g2.fillRect(-this.m_firstColumn * this.m_charWidth + this.m_hexViewWidth + this.m_offsetViewWidth, 0, this.m_firstColumn * this.m_charWidth + this.getWidth() - (this.m_hexViewWidth + this.m_offsetViewWidth) - this.m_scrollbar.getWidth(), this.getHeight() - this.m_horizontalScrollbar.getHeight());
        g2.setColor(Color.BLACK);
        g2.drawLine(-this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth, 0, -this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth, this.getHeight());
        g2.drawLine(-this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth + this.m_hexViewWidth, 0, -this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth + this.m_hexViewWidth, this.getHeight());
    }

    private void drawCaret(Graphics g2) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentOffset() < (long)this.getFirstVisibleByte() || this.getCurrentColumn() > this.getFirstVisibleByte() + this.getMaximumVisibleBytes()) {
            return;
        }
        int characterSize = this.getCharacterWidth(g2);
        if (this.m_activeView == Views.HEX_VIEW) {
            this.drawCaretHexWindow(g2, characterSize, this.m_rowHeight);
        } else {
            this.drawCaretAsciiWindow(g2, characterSize, this.m_rowHeight);
        }
    }

    private void drawCaretAsciiWindow(Graphics g2, int characterWidth, int characterHeight) {
        int currentRow = this.getCurrentRow() - this.m_firstRow;
        int currentColumn = this.getCurrentColumn();
        int currentCharacter = currentColumn / 2;
        int startLeft = 9 + this.m_offsetViewWidth + this.m_hexViewWidth;
        int x2 = -this.m_firstColumn * this.m_charWidth + startLeft + currentCharacter * characterWidth;
        int y2 = 19 - characterHeight + characterHeight * currentRow;
        this.m_caret.draw(g2, x2, y2, characterHeight);
    }

    private void drawCaretHexWindow(Graphics g2, int characterWidth, int characterHeight) {
        int currentRow = this.getCurrentRow() - this.m_firstRow;
        int currentColumn = this.getCurrentColumn();
        int startLeft = 9 + this.m_offsetViewWidth;
        int paddingColumns = currentColumn / (2 * this.m_bytesPerColumn) * this.m_columnSpacing;
        int x2 = -this.m_firstColumn * this.m_charWidth + startLeft + currentColumn * characterWidth + paddingColumns;
        int y2 = 19 - characterHeight + characterHeight * currentRow;
        this.m_caret.draw(g2, x2, y2, characterHeight);
    }

    private void drawHexView(Graphics g2) {
        int bytesToDraw;
        int firstX;
        int standardSize = 2 * this.getCharacterWidth(g2);
        int x2 = firstX = -this.m_firstColumn * this.m_charWidth + 10 + this.m_offsetViewWidth;
        int y2 = 16;
        boolean evenColumn = true;
        byte[] data = null;
        if (this.m_status == DefinitionStatus.DEFINED) {
            bytesToDraw = this.getBytesToDraw();
            data = this.m_dataProvider.getData(this.getFirstVisibleOffset(), bytesToDraw);
        } else {
            bytesToDraw = this.getMaximumVisibleBytes();
        }
        long currentOffset = this.getFirstVisibleOffset();
        int i2 = 0;
        while (i2 < bytesToDraw) {
            ColoredRange range = this.findColoredRange(currentOffset);
            if (i2 != 0) {
                if (i2 % this.m_bytesPerRow == 0) {
                    x2 = firstX;
                    y2 += this.m_rowHeight;
                    evenColumn = true;
                } else if (i2 % this.m_bytesPerColumn == 0) {
                    x2 += this.m_columnSpacing;
                    boolean bl2 = evenColumn = !evenColumn;
                }
            }
            if (this.isEnabled()) {
                if (this.isSelectedOffset(currentOffset)) {
                    g2.setColor(this.m_selectionColor);
                    g2.fillRect(x2, y2 - this.m_charHeight, 2 * this.m_charWidth, this.m_charHeight + 2);
                    g2.setColor(evenColumn ? this.m_fontColorHex1 : this.m_fontColorHex2);
                } else if (range != null && range.containsOffset(currentOffset)) {
                    Color bgColor = range.getBackgroundColor();
                    if (bgColor != null) {
                        g2.setColor(bgColor);
                    }
                    g2.fillRect(x2, y2 - this.m_charHeight, 2 * this.m_charWidth, this.m_charHeight + 2);
                    if (range.getColor() != null) {
                        g2.setColor(range.getColor());
                    } else {
                        g2.setColor(evenColumn ? this.m_fontColorHex1 : this.m_fontColorHex2);
                    }
                } else if (this.m_colormap != null && this.m_colormap.colorize(data, i2)) {
                    Color backgroundColor = this.m_colormap.getBackgroundColor(data, i2);
                    Color foregroundColor = this.m_colormap.getForegroundColor(data, i2);
                    if (backgroundColor != null) {
                        g2.setColor(backgroundColor);
                        g2.fillRect(x2, y2 - this.m_charHeight, 2 * this.m_charWidth, this.m_charHeight + 2);
                    }
                    if (foregroundColor != null) {
                        g2.setColor(foregroundColor);
                    }
                } else {
                    g2.setColor(evenColumn ? this.m_fontColorHex1 : this.m_fontColorHex2);
                }
            } else {
                g2.setColor(this.m_disabledColor != this.m_bgColorHex ? this.m_disabledColor : Color.WHITE);
            }
            if (this.m_status == DefinitionStatus.DEFINED) {
                int columnBytes = Math.min(this.m_dataProvider.getDataLength() - i2, this.m_bytesPerColumn);
                int dataPosition = this.m_flipBytes ? i2 / this.m_bytesPerColumn * this.m_bytesPerColumn + (columnBytes - i2 % columnBytes - 1) : i2;
                g2.drawString(HEX_BYTES[data[dataPosition] & 0xFF], x2, y2);
            } else {
                g2.drawString("??", x2, y2);
            }
            x2 += standardSize;
            ++i2;
            ++currentOffset;
        }
    }

    private void drawMouseOverHighlighting(Graphics g2) {
        Rectangle r2;
        Views lastHighlightedView;
        g2.setColor(this.m_colorHighlight);
        this.m_lastHighlightedNibble = this.getNibbleAtCoordinate(this.m_lastMouseX, this.m_lastMouseY);
        if (this.m_lastHighlightedNibble == -1) {
            return;
        }
        Views views = lastHighlightedView = this.m_lastMouseX >= this.getAsciiViewLeft() ? Views.ASCII_VIEW : Views.HEX_VIEW;
        if (lastHighlightedView == Views.HEX_VIEW) {
            r2 = this.getNibbleBoundsHex(this.m_lastHighlightedNibble);
            g2.fillRect((int)r2.getX(), (int)r2.getY(), (int)r2.getWidth(), (int)r2.getHeight());
        } else if (lastHighlightedView == Views.ASCII_VIEW) {
            int first = 2 * this.m_lastHighlightedNibble / 2;
            Rectangle r3 = this.getNibbleBoundsHex(first);
            g2.fillRect((int)r3.getX(), (int)r3.getY(), (int)r3.getWidth(), (int)r3.getHeight());
            r3 = this.getNibbleBoundsHex(first + 1);
            g2.fillRect((int)r3.getX(), (int)r3.getY(), (int)r3.getWidth(), (int)r3.getHeight());
        }
        r2 = this.getByteBoundsAscii(this.m_lastHighlightedNibble);
        g2.fillRect((int)r2.getX(), (int)r2.getY(), (int)r2.getWidth(), (int)r2.getHeight());
    }

    private void drawOffsets(Graphics g2) {
        if (this.isEnabled()) {
            g2.setColor(this.m_fontColorOffsets);
        } else {
            g2.setColor(this.m_disabledColor != this.m_bgColorOffset ? this.m_disabledColor : Color.WHITE);
        }
        int x2 = -this.m_firstColumn * this.m_charWidth + 10;
        int bytesToDraw = this.getMaximumVisibleBytes();
        String formatString = this.m_addressMode == AddressMode.BIT32 ? "%08X" : "%016X";
        for (int i2 = 0; i2 < bytesToDraw; i2 += this.m_bytesPerRow) {
            long address = this.m_baseAddress + (long)(this.m_firstRow * this.m_bytesPerRow) + (long)i2;
            String offsetString = String.format(formatString, address);
            int currentRow = i2 / this.m_bytesPerRow;
            g2.drawString(offsetString, x2, 16 + currentRow * this.m_rowHeight);
        }
    }

    private ColoredRange findColoredRange(long currentOffset) {
        for (ColoredRangeManager element : this.m_coloredRanges) {
            ColoredRange range = element.findRangeWith(currentOffset);
            if (range == null) continue;
            return range;
        }
        return null;
    }

    private int getAsciiViewLeft() {
        return this.getHexViewLeft() + this.getHexViewWidth();
    }

    private Rectangle getByteBoundsAscii(int position) {
        if (position < 2 * this.getFirstVisibleByte()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        if (position > 2 * this.getFirstVisibleByte() + 2 * this.getMaximumVisibleBytes()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        int relativePosition = (position - 2 * this.getFirstVisibleByte()) / 2;
        int row = relativePosition / this.m_bytesPerRow;
        int character = relativePosition % this.m_bytesPerRow;
        int x2 = this.getAsciiViewLeft() + 10 + character * this.m_charWidth;
        int y2 = 16 - this.m_charHeight + row * this.m_rowHeight;
        return new Rectangle(x2, y2, this.m_charWidth, this.m_charHeight);
    }

    private int getBytesToDraw() {
        int firstVisibleByte = this.getFirstVisibleByte();
        int maxBytes = this.getMaximumVisibleBytes();
        int restBytes = this.m_dataProvider.getDataLength() - firstVisibleByte;
        return Math.min(maxBytes, restBytes);
    }

    private int getCharacterWidth(Graphics g2) {
        return (int)g2.getFontMetrics().getStringBounds("0", g2).getWidth();
    }

    private int getCharHeight(Graphics g2) {
        return g2.getFontMetrics().getAscent();
    }

    private int getColumnSize() {
        return 2 * this.m_bytesPerColumn * this.m_charWidth + this.m_columnSpacing;
    }

    private int getCurrentColumn() {
        return (int)this.getCurrentNibble() % (2 * this.m_bytesPerRow);
    }

    private long getCurrentNibble() {
        return this.getSelectionStart() + this.getSelectionLength();
    }

    private int getCurrentRow() {
        return (int)this.getCurrentNibble() / (2 * this.m_bytesPerRow);
    }

    private int getEarlierBytes() {
        return this.m_firstRow * this.m_bytesPerRow;
    }

    private int getFirstVisibleByte() {
        return this.m_firstRow * this.m_bytesPerRow;
    }

    private int getHexViewLeft() {
        return -this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth;
    }

    private int getMaximumVisibleBytes() {
        return this.getNumberOfVisibleRows() * this.m_bytesPerRow;
    }

    private int getNibbleAtCoordinate(int x2, int y2) {
        if (this.m_dataProvider == null) {
            return -1;
        }
        if (x2 < this.getHexViewLeft() + 10) {
            return -1;
        }
        if (y2 >= 16 - this.m_font.getSize()) {
            if (x2 >= this.getHexViewLeft() && x2 < this.getHexViewLeft() + this.getHexViewWidth()) {
                return this.getNibbleAtCoordinatesHex(x2, y2);
            }
            if (x2 >= this.getAsciiViewLeft()) {
                return this.getNibbleAtCoordinatesAscii(x2, y2);
            }
        }
        return -1;
    }

    private int getNibbleAtCoordinatesAscii(int x2, int y2) {
        int normalizedX = x2 - (this.getAsciiViewLeft() + 10);
        if (normalizedX < 0) {
            return -1;
        }
        int row = (y2 - (16 - this.m_charHeight)) / this.m_rowHeight;
        int earlierPositions = 2 * this.getEarlierBytes();
        if (normalizedX / this.m_charWidth >= this.m_bytesPerRow) {
            return -1;
        }
        int character = 2 * (normalizedX / this.m_charWidth);
        int position = earlierPositions + 2 * row * this.m_bytesPerRow + character;
        if (position >= 2 * this.m_dataProvider.getDataLength()) {
            return -1;
        }
        return position;
    }

    private int getNibbleAtCoordinatesHex(int x2, int y2) {
        int columnSize;
        int normalizedX = x2 - (this.getHexViewLeft() + 10);
        int column = normalizedX / (columnSize = this.getColumnSize());
        if (column >= this.m_bytesPerRow / this.m_bytesPerColumn) {
            return -1;
        }
        int xInColumn = normalizedX % columnSize;
        int nibbleInColumn = xInColumn / this.m_charWidth;
        if (nibbleInColumn >= 2 * this.m_bytesPerColumn) {
            return -1;
        }
        int row = (y2 - (16 - this.m_charHeight)) / this.m_rowHeight;
        int earlierPositions = 2 * this.getEarlierBytes();
        int position = earlierPositions + 2 * (row * this.m_bytesPerRow + column * this.m_bytesPerColumn) + nibbleInColumn;
        if (position >= 2 * this.m_dataProvider.getDataLength()) {
            return -1;
        }
        return position;
    }

    private Rectangle getNibbleBoundsHex(int position) {
        if (position < 2 * this.getFirstVisibleByte()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        if (position > 2 * this.getFirstVisibleByte() + 2 * this.getMaximumVisibleBytes()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        int relativePosition = position - 2 * this.getFirstVisibleByte();
        int columnSize = this.getColumnSize();
        int row = relativePosition / (2 * this.m_bytesPerRow);
        int column = relativePosition % (2 * this.m_bytesPerRow) / (2 * this.m_bytesPerColumn);
        int nibble = relativePosition % (2 * this.m_bytesPerRow) % (2 * this.m_bytesPerColumn);
        int x2 = this.getHexViewLeft() + 10 + column * columnSize + nibble * this.m_charWidth;
        int y2 = 16 - this.m_charHeight + row * this.m_rowHeight;
        return new Rectangle(x2, y2, this.m_charWidth, this.m_charHeight);
    }

    private int getNumberOfVisibleRows() {
        int rawHeight = this.getHeight() - 16 - this.m_horizontalScrollbar.getHeight();
        return rawHeight / this.m_rowHeight + (rawHeight % this.m_rowHeight == 0 ? 0 : 1);
    }

    private int getRowHeight(Graphics g2) {
        return g2.getFontMetrics().getHeight();
    }

    private long getSelectionStart() {
        return this.m_selectionStart;
    }

    private void initHotkeys() {
        this.setFocusTraversalKeys(0, new HashSet());
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "LEFT");
        actionMap.put("LEFT", this.m_leftAction);
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "shift LEFT");
        actionMap.put("shift LEFT", this.m_leftAction);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "RIGHT");
        actionMap.put("RIGHT", this.m_rightAction);
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "shift RIGHT");
        actionMap.put("shift RIGHT", this.m_rightAction);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "UP");
        actionMap.put("UP", this.m_upAction);
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "shift UP");
        actionMap.put("shift UP", this.m_upAction);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "DOWN");
        actionMap.put("DOWN", this.m_downAction);
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "shift DOWN");
        actionMap.put("shift DOWN", this.m_downAction);
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "PAGE_DOWN");
        actionMap.put("PAGE_DOWN", this.m_pageDownAction);
        inputMap.put(KeyStroke.getKeyStroke(34, 64), "shift PAGE_DOWN");
        actionMap.put("shift PAGE_DOWN", this.m_pageDownAction);
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "PAGE_UP");
        actionMap.put("PAGE_UP", this.m_pageUpAction);
        inputMap.put(KeyStroke.getKeyStroke(33, 64), "shift PAGE_UP");
        actionMap.put("shift PAGE_UP", this.m_pageUpAction);
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "TAB");
        actionMap.put("TAB", this.m_tabAction);
    }

    private void initListeners() {
        this.addMouseListener(this.m_listener);
        this.addMouseMotionListener(this.m_listener);
        this.addMouseWheelListener(this.m_listener);
        this.addFocusListener(this.m_listener);
        this.addComponentListener(this.m_listener);
        this.addKeyListener(this.m_listener);
        this.m_caret.addCaretListener(this.m_listener);
    }

    private void initScrollbar() {
        this.m_scrollbar.addAdjustmentListener(this.m_listener);
        this.add((Component)this.m_scrollbar, "East");
        this.m_horizontalScrollbar.addAdjustmentListener(this.m_listener);
        this.add((Component)this.m_horizontalScrollbar, "South");
    }

    private boolean isDataAvailable() {
        return this.m_dataProvider != null;
    }

    private boolean isInsideAsciiView(int x2, int y2) {
        return y2 >= 16 - this.m_font.getSize() && x2 >= this.getAsciiViewLeft();
    }

    private boolean isInsideHexView(int x2, int y2) {
        return y2 >= 16 - this.m_font.getSize() && x2 >= this.getHexViewLeft() && x2 < this.getHexViewLeft() + this.getHexViewWidth();
    }

    private boolean isPositionVisible(long position) {
        int firstVisible = this.getFirstVisibleByte();
        int lastVisible = firstVisible + this.getMaximumVisibleBytes();
        return position >= (long)(2 * firstVisible) && position <= (long)(2 * lastVisible);
    }

    private boolean isSelectedOffset(long currentOffset) {
        currentOffset -= this.m_baseAddress;
        if (this.getSelectionLength() == 0L) {
            return false;
        }
        if (this.getSelectionLength() > 0L) {
            return currentOffset >= this.getSelectionStart() / 2L && 2L * currentOffset < this.getSelectionStart() + this.getSelectionLength();
        }
        return currentOffset >= (this.getSelectionStart() + this.getSelectionLength()) / 2L && 2L * currentOffset < this.getSelectionStart();
    }

    private void resetBufferedGraphic() {
        this.bufferGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.bufferGraphics.setFont(this.m_font);
    }

    private void scrollToPosition(long position) {
        this.m_scrollbar.setValue((int)position / (2 * this.m_bytesPerRow));
    }

    private void setCurrentPosition(long newPosition) {
        this.m_selectionStart = newPosition;
        if (!this.isPositionVisible(this.getSelectionStart())) {
            this.scrollToPosition(this.getSelectionStart());
        }
        for (IHexPanelListener listener : this.m_listeners) {
            listener.selectionChanged(this.getSelectionStart(), 1L);
        }
    }

    private void setScrollBarMaximum() {
        if (this.m_dataProvider == null) {
            this.m_scrollbar.setMaximum(1);
            this.m_horizontalScrollbar.setMaximum(1);
        } else {
            int visibleRows = this.getNumberOfVisibleRows();
            int totalRows = this.m_dataProvider.getDataLength() / this.m_bytesPerRow;
            int scrollRange = 2 + totalRows - visibleRows;
            if (scrollRange < 0) {
                scrollRange = 0;
                this.m_scrollbar.setValue(0);
                this.m_scrollbar.setEnabled(false);
            } else {
                this.m_scrollbar.setEnabled(true);
            }
            this.m_scrollbar.setMaximum(scrollRange);
            int totalWidth = this.getAsciiViewLeft() + 10 + this.m_charWidth * this.m_bytesPerRow;
            int realWidth = this.getWidth() - this.m_scrollbar.getWidth();
            if (realWidth >= totalWidth) {
                this.m_horizontalScrollbar.setValue(0);
                this.m_horizontalScrollbar.setEnabled(false);
            } else {
                this.m_horizontalScrollbar.setMaximum((totalWidth - realWidth) / this.m_charWidth + 1);
                this.m_horizontalScrollbar.setEnabled(true);
            }
        }
    }

    private void setSelectionStart(long selectionStart) {
        this.m_selectionStart = selectionStart;
        for (IHexPanelListener listener : this.m_listeners) {
            listener.selectionChanged(this.m_selectionStart, this.m_selectionLength);
        }
    }

    private void updateHexViewWidth() {
        this.m_hexViewWidth = 15 + this.getColumnSize() * this.getBytesPerRow() / this.getBytesPerColumn();
    }

    private void updateOffsetViewWidth() {
        int addressBytes = this.m_addressMode == AddressMode.BIT32 ? 8 : 16;
        this.m_offsetViewWidth = 20 + this.m_charWidth * addressBytes;
    }

    private void updatePreferredSize() {
        int width = this.m_offsetViewWidth + this.m_hexViewWidth + 18 * this.m_charWidth + this.m_scrollbar.getWidth();
        this.setPreferredSize(new Dimension(width, this.getHeight()));
        this.revalidate();
    }

    @Override
    protected void paintComponent(Graphics gx) {
        int bytesToDraw;
        super.paintComponent(gx);
        this.resetBufferedGraphic();
        this.calculateSizes();
        this.updateOffsetViewWidth();
        if (this.m_firstDraw) {
            this.m_firstDraw = false;
            this.updateHexViewWidth();
            this.updatePreferredSize();
        }
        this.drawBackground(this.bufferGraphics);
        this.drawOffsets(this.bufferGraphics);
        if (this.isEnabled()) {
            this.drawMouseOverHighlighting(this.bufferGraphics);
        }
        if (this.m_status == DefinitionStatus.DEFINED && this.m_dataProvider != null && (bytesToDraw = this.getBytesToDraw()) != 0 && !this.m_dataProvider.hasData(this.getFirstVisibleOffset(), bytesToDraw)) {
            this.setDefinitionStatus(DefinitionStatus.UNDEFINED);
            this.setEnabled(false);
            if (this.m_updateTimer != null) {
                this.m_updateTimer.setRepeats(false);
                this.m_updateTimer.stop();
            }
            this.m_updateTimer = new Timer(1000, new WaitingForDataAction(this.getFirstVisibleOffset(), bytesToDraw));
            this.m_updateTimer.setRepeats(true);
            this.m_updateTimer.start();
            return;
        }
        if (this.isDataAvailable() || this.m_status == DefinitionStatus.UNDEFINED) {
            this.drawHexView(this.bufferGraphics);
            this.drawAsciiPanel(this.bufferGraphics);
            if (this.m_caret.isVisible() && this.hasFocus()) {
                this.drawCaret(this.bufferGraphics);
            }
        }
        gx.drawImage(this.img, 0, 0, this);
    }

    public void addHexListener(IHexPanelListener listener) {
        Preconditions.checkNotNull(listener, "Error: Listener can't be null");
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void colorize(int level, long offset, int size, Color color, Color bgcolor) {
        Preconditions.checkArgument(offset >= 0L, "Error: offset argument must be greater or equal to zero");
        Preconditions.checkArgument(size >= 0, "Error: size argument must be greater or equal to zero");
        Preconditions.checkArgument(level >= 0 && level < this.m_coloredRanges.length, "Error: level argument must be greater or equal to zero");
        this.m_coloredRanges[level].addRange(new ColoredRange(offset, size, color, bgcolor));
        this.repaint();
    }

    public void dispose() {
        this.removeMouseListener(this.m_listener);
        this.removeMouseMotionListener(this.m_listener);
        this.removeMouseWheelListener(this.m_listener);
        this.removeFocusListener(this.m_listener);
        this.removeComponentListener(this.m_listener);
        this.removeKeyListener(this.m_listener);
        this.m_caret.removeListener(this.m_listener);
        this.m_caret.stop();
    }

    public boolean doFlipBytes() {
        return this.m_flipBytes;
    }

    public AddressMode getAddressMode() {
        return this.m_addressMode;
    }

    public Color getBackgroundColorAsciiView() {
        return this.m_bgColorAscii;
    }

    public Color getBackgroundColorHexView() {
        return this.m_bgColorHex;
    }

    public Color getBackgroundColorOffsetView() {
        return this.m_bgColorOffset;
    }

    public long getBaseAddress() {
        return this.m_baseAddress;
    }

    public int getBytesPerColumn() {
        return this.m_bytesPerColumn;
    }

    public int getBytesPerRow() {
        return this.m_bytesPerRow;
    }

    public int getColumnSpacing() {
        return this.m_columnSpacing;
    }

    public long getCurrentOffset() {
        long currentOffset = this.m_baseAddress + this.getCurrentNibble() / 2L;
        return this.m_flipBytes ? (currentOffset & (long)(-this.m_bytesPerColumn)) + (long)this.m_bytesPerColumn - currentOffset % (long)this.m_bytesPerColumn - 1L : currentOffset;
    }

    public IDataProvider getData() {
        return this.m_dataProvider;
    }

    public DefinitionStatus getDefinitionStatus() {
        return this.m_status;
    }

    public long getFirstSelectedOffset() {
        if (this.m_selectionLength >= 0L) {
            return (this.m_baseAddress + this.m_selectionStart) / 2L;
        }
        return (this.m_baseAddress + this.m_selectionStart + this.m_selectionLength) / 2L;
    }

    public long getFirstVisibleOffset() {
        return this.getBaseAddress() + (long)this.getFirstVisibleByte();
    }

    public Color getFontColorAsciiView() {
        return this.m_fontColorAscii;
    }

    public Color getFontColorHexView1() {
        return this.m_fontColorHex1;
    }

    public Color getFontColorHexView2() {
        return this.m_fontColorHex2;
    }

    public Color getFontColorOffsetView() {
        return this.m_fontColorOffsets;
    }

    public int getFontSize() {
        return this.m_font.getSize();
    }

    public int getHexViewWidth() {
        return this.m_hexViewWidth;
    }

    public long getLastOffset() {
        return this.getBaseAddress() + (long)this.m_dataProvider.getDataLength();
    }

    public long getLastSelectedOffset() {
        if (this.m_selectionLength >= 0L) {
            return (this.m_baseAddress + this.m_selectionStart + this.m_selectionLength) / 2L + (this.m_baseAddress + this.m_selectionStart + this.m_selectionLength) % 2L;
        }
        return (this.m_baseAddress + this.m_selectionStart) / 2L + (this.m_baseAddress + this.m_selectionStart) % 2L;
    }

    public long getSelectionLength() {
        return this.m_selectionLength;
    }

    public int getVisibleBytes() {
        int visibleBytes = this.getMaximumVisibleBytes();
        if (this.m_dataProvider.getDataLength() - this.getFirstVisibleByte() >= visibleBytes) {
            return visibleBytes;
        }
        return this.m_dataProvider.getDataLength() - this.getFirstVisibleByte();
    }

    public void gotoOffset(long offset) {
        Preconditions.checkNotNull(this.m_dataProvider, "Error: No data provider active");
        if (this.getCurrentOffset() == offset) {
            if (!this.isPositionVisible(this.getSelectionStart())) {
                this.scrollToPosition(this.getSelectionStart());
            }
            return;
        }
        long realOffset = offset < this.m_baseAddress ? offset : offset - this.m_baseAddress;
        if (realOffset < 0L || realOffset >= (long)this.m_dataProvider.getDataLength()) {
            throw new IllegalArgumentException("Error: Invalid offset");
        }
        this.setCurrentPosition(2L * realOffset);
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void removeHexListener(IHexPanelListener listener) {
        Preconditions.checkNotNull(listener, "Internal Error: Listener can't be null");
        if (!this.m_listeners.remove(listener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
    }

    public void setAddressMode(AddressMode mode) {
        this.m_addressMode = Preconditions.checkNotNull(mode, "Error: Address mode can't be null");
        this.updateOffsetViewWidth();
        this.updatePreferredSize();
    }

    public void setBackgroundColorAsciiView(Color color) {
        this.m_bgColorAscii = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setBackgroundColorHexView(Color color) {
        this.m_bgColorHex = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setBackgroundColorOffsetView(Color color) {
        this.m_bgColorOffset = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setBaseAddress(long baseAddress) {
        Preconditions.checkArgument(baseAddress >= 0L, "Error: Base address can't be negative");
        this.m_baseAddress = baseAddress;
        this.repaint();
    }

    public void setBytesPerColumn(int bytes) {
        Preconditions.checkArgument(bytes > 0, "Error: Number of bytes must be positive");
        Preconditions.checkArgument(bytes <= this.m_bytesPerRow, "Error: Number of bytes can't be more than the number of bytes per row");
        this.m_bytesPerColumn = bytes;
        this.updateHexViewWidth();
        this.updatePreferredSize();
        this.repaint();
    }

    public void setBytesPerRow(int value) {
        Preconditions.checkArgument(value > 0, "Error: Value must be positive");
        this.m_bytesPerRow = value;
        this.repaint();
    }

    public void setColormap(IColormap colormap) {
        this.m_colormap = Preconditions.checkNotNull(colormap, "Error: colormap argument can not be null");
        this.repaint();
    }

    public void setColumnSpacing(int spacing) {
        Preconditions.checkArgument(spacing > 0, "Error: Spacing must be positive");
        this.m_columnSpacing = spacing;
        this.repaint();
    }

    public void setCurrentOffset(long offset) {
        if (this.m_dataProvider == null) {
            return;
        }
        Preconditions.checkArgument(offset >= this.getBaseAddress() || offset <= this.getBaseAddress() + (long)this.m_dataProvider.getDataLength(), "Error: Invalid offset");
        this.setCurrentPosition(2L * (offset - this.m_baseAddress));
    }

    public void setData(IDataProvider data) {
        if (this.m_dataProvider != null) {
            this.m_dataProvider.removeListener(this.m_listener);
        }
        this.m_dataProvider = data;
        if (data != null) {
            this.m_dataProvider.addListener(this.m_listener);
        }
        this.setCurrentPosition(0L);
        this.setScrollBarMaximum();
        this.repaint();
    }

    public void setDefinitionStatus(DefinitionStatus status) {
        this.m_status = Preconditions.checkNotNull(status, "Error: Definition status can't be null");
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.m_enabled) {
            return;
        }
        this.m_enabled = enabled;
        this.repaint();
    }

    public void setFlipBytes(boolean flip) {
        if (this.m_flipBytes == flip) {
            return;
        }
        this.m_flipBytes = flip;
        this.repaint();
    }

    public void setFontColorAsciiView(Color color) {
        this.m_fontColorAscii = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setFontColorHexView1(Color color) {
        this.m_fontColorHex1 = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setFontColorHexView2(Color color) {
        this.m_fontColorHex2 = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setFontColorOffsetView(Color color) {
        this.m_fontColorOffsets = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setFontSize(int size) {
        Preconditions.checkArgument(size > 0, "Error: Font size must be positive");
        this.m_font = new Font(GuiHelper.getMonospaceFont(), 0, size);
        this.setFont(this.m_font);
        this.m_firstDraw = true;
        this.repaint();
    }

    public void setHexViewWidth(int width) {
        Preconditions.checkArgument(width > 0, "Error: Width must be positive");
        this.m_hexViewWidth = width;
        this.repaint();
    }

    public void setMenuCreator(IMenuCreator creator) {
        this.m_menuCreator = creator;
    }

    public void setSelectionColor(Color color) {
        this.m_selectionColor = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setSelectionLength(long selectionLength) {
        this.m_selectionLength = selectionLength;
        for (IHexPanelListener listener : this.m_listeners) {
            listener.selectionChanged(this.m_selectionStart, this.m_selectionLength);
        }
        this.repaint();
    }

    public void uncolorize(int level, long offset, int size) {
        Preconditions.checkArgument(offset >= 0L, "Error: Offset can't be negative");
        Preconditions.checkArgument(size > 0, "Error: Size must be positive");
        Preconditions.checkArgument(level >= 0 && level < this.m_coloredRanges.length, "Error: Invalid level");
        this.m_coloredRanges[level].removeRange(offset, size);
        this.repaint();
    }

    public void uncolorizeAll() {
        for (ColoredRangeManager coloredRange : this.m_coloredRanges) {
            coloredRange.clear();
        }
    }

    public void uncolorizeAll(int level) {
        this.m_coloredRanges[level].clear();
        this.repaint();
    }

    public static enum DefinitionStatus {
        DEFINED,
        UNDEFINED;

    }

    public static enum AddressMode {
        BIT32,
        BIT64;

    }

    private class WaitingForDataAction
    extends AbstractAction {
        private static final long serialVersionUID = -610823391617272365L;
        private final long m_offset;
        private final int m_size;

        private WaitingForDataAction(long offset, int size) {
            this.m_offset = offset;
            this.m_size = size;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (JHexView.this.m_dataProvider.hasData(this.m_offset, this.m_size)) {
                JHexView.this.setEnabled(true);
                JHexView.this.setDefinitionStatus(DefinitionStatus.DEFINED);
                ((Timer)arg0.getSource()).stop();
            } else if (!JHexView.this.m_dataProvider.keepTrying()) {
                ((Timer)arg0.getSource()).stop();
            }
        }
    }

    private static enum Views {
        HEX_VIEW,
        ASCII_VIEW;

    }

    private class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = -3513103611571283106L;

        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, -2 * JHexView.this.m_bytesPerRow);
        }
    }

    private class TabAction
    extends AbstractAction {
        private static final long serialVersionUID = -3265020583339369531L;

        private TabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (JHexView.this.m_activeView == Views.HEX_VIEW) {
                JHexView.this.m_activeView = Views.ASCII_VIEW;
                JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() - JHexView.this.getSelectionStart() % 2L);
            } else {
                JHexView.this.m_activeView = Views.HEX_VIEW;
            }
            JHexView.this.m_caret.setVisible(true);
            JHexView.this.repaint();
        }
    }

    private class RightAction
    extends AbstractAction {
        private static final long serialVersionUID = 3857972387525998636L;

        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, JHexView.this.m_activeView == Views.HEX_VIEW ? 1 : 2);
        }
    }

    private class PageUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -7424423002191015929L;

        private PageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, -JHexView.this.getNumberOfVisibleRows() * JHexView.this.m_bytesPerRow * 2);
        }
    }

    private class PageDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 490837791577654025L;

        private PageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, JHexView.this.getNumberOfVisibleRows() * JHexView.this.m_bytesPerRow * 2);
        }
    }

    private class LeftAction
    extends AbstractAction {
        private static final long serialVersionUID = -9032577023548944503L;

        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, JHexView.this.m_activeView == Views.HEX_VIEW ? -1 : -2);
        }
    }

    private class InternalListener
    implements AdjustmentListener,
    MouseListener,
    MouseMotionListener,
    FocusListener,
    ICaretListener,
    IDataChangedListener,
    ComponentListener,
    KeyListener,
    MouseWheelListener {
        private InternalListener() {
        }

        private void keyPressedInAsciiView(KeyEvent event) {
            byte[] data = JHexView.this.m_dataProvider.getData(JHexView.this.getCurrentOffset(), 1);
            if (JHexView.this.getSelectionStart() >= (long)(JHexView.this.m_dataProvider.getDataLength() * 2)) {
                return;
            }
            data[0] = (byte)event.getKeyChar();
            JHexView.this.m_dataProvider.setData(JHexView.this.getCurrentOffset(), data);
            JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() + 2L);
        }

        private void keyPressedInHexView(KeyEvent key) {
            byte[] data = JHexView.this.m_dataProvider.getData(JHexView.this.getCurrentOffset(), 1);
            long pos = JHexView.this.m_baseAddress + JHexView.this.getSelectionStart();
            if (JHexView.this.getSelectionStart() >= (long)(JHexView.this.m_dataProvider.getDataLength() * 2)) {
                return;
            }
            int value = Character.digit(key.getKeyChar(), 16);
            if (value == -1) {
                return;
            }
            data[0] = pos % 2L == 0L ? (byte)(data[0] & 0xF | value << 4) : (byte)(data[0] & 0xF0 | value);
            JHexView.this.m_dataProvider.setData(JHexView.this.getCurrentOffset(), data);
            JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() + 1L);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            if (event.getSource() == JHexView.this.m_scrollbar) {
                JHexView.this.m_firstRow = event.getValue();
            } else {
                JHexView.this.m_firstColumn = event.getValue();
            }
            JHexView.this.repaint();
        }

        @Override
        public void caretStatusChanged(JCaret source) {
            JHexView.this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent event) {
        }

        @Override
        public void componentMoved(ComponentEvent event) {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            JHexView.this.setScrollBarMaximum();
            int width = JHexView.this.getWidth() + 1 - JHexView.this.m_scrollbar.getWidth();
            int height = JHexView.this.getHeight() + 1 - JHexView.this.m_horizontalScrollbar.getHeight();
            width = Math.max(1, width);
            height = Math.max(1, height);
            JHexView.this.img = new BufferedImage(width, height, 1);
            JHexView.this.bufferGraphics = JHexView.this.img.getGraphics();
        }

        @Override
        public void componentShown(ComponentEvent event) {
        }

        @Override
        public void dataChanged() {
            JHexView.this.setScrollBarMaximum();
            JHexView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent event) {
            JHexView.this.m_caret.setVisible(true);
            JHexView.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent event) {
            JHexView.this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            if (JHexView.this.m_activeView == Views.HEX_VIEW) {
                if (JHexView.this.m_dataProvider.isEditable() && Convert.isHexCharacter(event.getKeyChar())) {
                    this.keyPressedInHexView(event);
                }
            } else if (JHexView.this.m_dataProvider.isEditable() && Convert.isPrintableCharacter(event.getKeyChar())) {
                this.keyPressedInAsciiView(event);
            }
            JHexView.this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            int x2 = event.getX();
            int y2 = event.getY();
            if (y2 < 16 - (JHexView.this.m_rowHeight - JHexView.this.m_charHeight)) {
                JHexView.this.scrollToPosition(2 * JHexView.this.getFirstVisibleByte() - 2 * JHexView.this.m_bytesPerRow);
                if (JHexView.this.getSelectionLength() - (long)(2 * JHexView.this.m_bytesPerRow) < 0L) {
                    return;
                }
                JHexView.this.setSelectionLength(JHexView.this.getSelectionLength() - (long)(2 * JHexView.this.m_bytesPerRow));
            } else if (y2 >= JHexView.this.m_rowHeight * JHexView.this.getNumberOfVisibleRows()) {
                JHexView.this.scrollToPosition(2 * JHexView.this.getFirstVisibleByte() + 2 * JHexView.this.m_bytesPerRow);
                if (JHexView.this.getSelectionLength() + (long)(2 * JHexView.this.m_bytesPerRow) > 2L * ((long)JHexView.this.m_dataProvider.getDataLength() - JHexView.this.getSelectionStart())) {
                    return;
                }
                JHexView.this.setSelectionLength(JHexView.this.getSelectionLength() + (long)(2 * JHexView.this.m_bytesPerRow));
            } else {
                int position = JHexView.this.getNibbleAtCoordinate(x2, y2);
                if (position != -1) {
                    JHexView.this.setSelectionLength((long)position - JHexView.this.getSelectionStart());
                    JHexView.this.repaint();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            JHexView.this.m_lastMouseX = event.getX();
            JHexView.this.m_lastMouseY = event.getY();
            JHexView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent event) {
            int position;
            int y2;
            int x2;
            if (!JHexView.this.isEnabled()) {
                return;
            }
            if (event.getButton() == 1 || event.getButton() == 3) {
                JHexView.this.m_selectionLength = 0L;
                JHexView.this.requestFocusInWindow();
                x2 = event.getX();
                y2 = event.getY();
                position = JHexView.this.getNibbleAtCoordinate(x2, y2);
                if (position != -1) {
                    JHexView.this.m_caret.setVisible(true);
                    JHexView.this.setCurrentPosition(position);
                    if (JHexView.this.isInsideHexView(x2, y2)) {
                        JHexView.this.m_activeView = Views.HEX_VIEW;
                    } else if (JHexView.this.isInsideAsciiView(x2, y2)) {
                        JHexView.this.m_activeView = Views.ASCII_VIEW;
                    }
                    JHexView.this.repaint();
                } else {
                    for (IHexPanelListener listener : JHexView.this.m_listeners) {
                        listener.selectionChanged(JHexView.this.m_selectionStart, JHexView.this.m_selectionLength);
                    }
                    JHexView.this.repaint();
                }
            }
            if (event.getButton() == 3 && (position = JHexView.this.getNibbleAtCoordinate(x2 = event.getX(), y2 = event.getY())) != -1) {
                JPopupMenu menu;
                JHexView.this.m_caret.setVisible(true);
                if (JHexView.this.m_menuCreator != null && (menu = JHexView.this.m_menuCreator.createMenu(JHexView.this.getCurrentOffset())) != null) {
                    menu.show(JHexView.this, x2, y2);
                }
                JHexView.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e2) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            int notches = e2.getWheelRotation();
            JHexView.this.m_scrollbar.setValue(JHexView.this.m_scrollbar.getValue() + notches);
        }
    }

    private class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6501310447863685486L;

        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, 2 * JHexView.this.m_bytesPerRow);
        }
    }
}

