/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JHexPanel;

import com.google.security.zynamics.zylib.gui.JHexPanel.ColoredRange;
import java.util.ArrayList;
import java.util.Collections;

public class ColoredRangeManager {
    private final ArrayList<ColoredRange> ranges = new ArrayList();

    public void addRange(ColoredRange range) {
        this.ranges.add(range);
        Collections.sort(this.ranges);
    }

    public void clear() {
        this.ranges.clear();
    }

    public ColoredRange findRange(long offset) {
        for (ColoredRange range : this.ranges) {
            if (range.getStart() < offset) continue;
            return range;
        }
        return null;
    }

    public ColoredRange findRangeWith(long offset) {
        for (ColoredRange range : this.ranges) {
            if (!range.containsOffset(offset)) continue;
            return range;
        }
        return null;
    }

    public void removeRange(long offset, int size) {
        ColoredRange range = this.findRangeWith(offset);
        if (range == null) {
            range = this.findRange(offset);
        }
        if (range == null) {
            return;
        }
        if (offset <= range.getStart()) {
            if (range.getSize() == size) {
                this.ranges.remove(range);
            } else if (range.getSize() < size) {
                this.ranges.remove(range);
                this.removeRange(range.getStart() + (long)range.getSize(), size - range.getSize());
            } else {
                this.ranges.remove(range);
                this.addRange(new ColoredRange(offset + (long)size, range.getSize() - size, range.getColor(), range.getBackgroundColor()));
            }
        } else if (offset + (long)size == range.getStart() + (long)range.getSize()) {
            this.ranges.remove(range);
            long newStart = range.getStart();
            int newSize = range.getSize() - size;
            this.addRange(new ColoredRange(newStart, newSize, range.getColor(), range.getBackgroundColor()));
        } else if (offset + (long)size < range.getStart() + (long)range.getSize()) {
            this.ranges.remove(range);
            long newStartFirst = range.getStart();
            int newSizeFirst = (int)(offset - range.getStart());
            this.addRange(new ColoredRange(newStartFirst, newSizeFirst, range.getColor(), range.getBackgroundColor()));
            long newStartLast = offset + (long)size;
            int newSizeLast = (int)(range.getStart() + (long)range.getSize() - offset - (long)size);
            this.addRange(new ColoredRange(newStartLast, newSizeLast, range.getColor(), range.getBackgroundColor()));
        } else {
            this.ranges.remove(range);
            long newStart = range.getStart();
            int newSize = (int)(offset - range.getStart());
            this.addRange(new ColoredRange(newStart, newSize, range.getColor(), range.getBackgroundColor()));
            this.removeRange(range.getStart() + (long)range.getSize(), size - (int)(range.getStart() + (long)range.getSize() - offset));
        }
    }
}

