/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;

public class JCheckedListbox<T>
extends JList<T> {
    private final boolean[] m_selected;
    private boolean m_selectCompleteLine = true;

    public JCheckedListbox(ListModel<T> model) {
        super(model);
        this.m_selected = new boolean[model.getSize()];
        this.setCellRenderer(new CheckedListboxRenderer());
        this.addMouseListener(new InternalListener());
    }

    public JCheckedListbox(T[] listData) {
        super(listData);
        this.m_selected = new boolean[listData.length];
        this.setCellRenderer(new CheckedListboxRenderer());
        this.addMouseListener(new InternalListener());
    }

    public JCheckedListbox(Vector<T> listData) {
        super(listData);
        this.m_selected = new boolean[listData.size()];
        this.setCellRenderer(new CheckedListboxRenderer());
        this.addMouseListener(new InternalListener());
    }

    public JCheckedListbox(Vector<T> listData, boolean selectCompleteLine) {
        super(listData);
        this.m_selectCompleteLine = selectCompleteLine;
        this.m_selected = new boolean[listData.size()];
        this.setCellRenderer(new CheckedListboxRenderer());
        this.addMouseListener(new InternalListener());
    }

    public boolean isChecked(int index) {
        return this.m_selected[index];
    }

    public void setChecked(int index, boolean isSelected) {
        this.m_selected[index] = isSelected;
        this.updateUI();
        this.fireSelectionValueChanged(index, index, false);
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    private class InternalListener
    extends MouseAdapter {
        private InternalListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (!JCheckedListbox.this.isEnabled()) {
                return;
            }
            if (event.getPoint().x > 20) {
                return;
            }
            int row = JCheckedListbox.this.locationToIndex(event.getPoint());
            ((JCheckedListbox)JCheckedListbox.this).m_selected[row] = !JCheckedListbox.this.m_selected[row];
            JCheckedListbox.this.updateUI();
            JCheckedListbox.this.fireSelectionValueChanged(row, row, false);
        }
    }

    private class CheckedListboxRenderer<T>
    extends JPanel
    implements ListCellRenderer<T> {
        private static final long serialVersionUID = 7446207257969469739L;
        private final JCheckBox checkBox;
        private final LineBorder SELECTED_BORDER;
        private final LineBorder UNSELECTED_BORDER;
        private final Color SELECTED_COLOR;
        private final Color UNSELECTED_COLOR;

        public CheckedListboxRenderer() {
            super(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.SELECTED_BORDER = new LineBorder(Color.DARK_GRAY);
            this.UNSELECTED_BORDER = new LineBorder(Color.WHITE);
            this.SELECTED_COLOR = new Color(12439527);
            this.UNSELECTED_COLOR = Color.WHITE;
            this.setBorder(this.UNSELECTED_BORDER);
            this.setBackground(this.UNSELECTED_COLOR);
            this.checkBox.setBackground(this.UNSELECTED_COLOR);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean iss, boolean chf) {
            this.checkBox.setEnabled(JCheckedListbox.this.isEnabled());
            if (JCheckedListbox.this.m_selectCompleteLine) {
                this.setBorder(iss ? this.SELECTED_BORDER : this.UNSELECTED_BORDER);
                this.setBackground(iss ? this.SELECTED_COLOR : this.UNSELECTED_COLOR);
                this.checkBox.setBackground(iss ? this.SELECTED_COLOR : this.UNSELECTED_COLOR);
            }
            this.checkBox.setText(value.toString());
            this.checkBox.setSelected(JCheckedListbox.this.m_selected[index]);
            this.checkBox.updateUI();
            this.add((Component)this.checkBox, "West");
            return this;
        }
    }
}

