/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JCaret;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.JCaret.ICaretListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class JCaret {
    private static final int DEFAULT_BLINK_TIME = 600;
    private static final Color DEFAULT_CARET_COLOR = Color.RED;
    private final List<ICaretListener> m_listeners = new ArrayList<ICaretListener>();
    private final Timer m_caretTimer;
    private boolean m_isCaretVisible = false;
    private final Color m_caretColor = Color.RED;
    private final InternalListener m_listener = new InternalListener();

    public JCaret() {
        this(600, DEFAULT_CARET_COLOR);
    }

    public JCaret(Color caretColor) {
        this(600, caretColor);
    }

    public JCaret(int blinkPeriod) {
        this(blinkPeriod, DEFAULT_CARET_COLOR);
    }

    public JCaret(int blinkPeriod, Color caretColor) {
        Preconditions.checkArgument(blinkPeriod >= 0, "Error: Blink period can't be negative");
        Preconditions.checkNotNull(caretColor, "Error: Caret color can't be null");
        this.m_caretTimer = new Timer(blinkPeriod, this.m_listener);
        this.m_caretTimer.setRepeats(true);
        this.m_caretTimer.start();
    }

    private void notifyListeners() {
        for (ICaretListener listener : this.m_listeners) {
            listener.caretStatusChanged(this);
        }
    }

    public void addCaretListener(ICaretListener listener) {
        Preconditions.checkNotNull(listener, "Error: Listener can't be null");
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void draw(Graphics g2, int x2, int y2, int height) {
        Preconditions.checkNotNull(g2, "Error: Graphics context can't be null");
        if (this.isVisible()) {
            Color oldColor = g2.getColor();
            g2.setColor(this.m_caretColor);
            g2.drawLine(x2, y2, x2, y2 + height - 1);
            g2.setColor(oldColor);
        }
    }

    public boolean isVisible() {
        return this.m_isCaretVisible;
    }

    public void removeListener(ICaretListener listener) {
        this.m_listeners.remove(listener);
    }

    public void setVisible(boolean isCaretVisible) {
        this.m_isCaretVisible = isCaretVisible;
        this.notifyListeners();
    }

    public void stop() {
        this.m_caretTimer.stop();
        this.m_caretTimer.removeActionListener(this.m_listener);
        this.setVisible(false);
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JCaret.this.m_isCaretVisible = !JCaret.this.m_isCaretVisible;
            JCaret.this.notifyListeners();
        }
    }
}

