/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.FileChooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;

public class FileChooserPanel
extends JPanel {
    private final JTextField inputField;
    private final JButton browseButton;

    public FileChooserPanel(String defaultText, ActionListener listener) {
        this(defaultText, listener, "...", 0, 0, 0);
    }

    public FileChooserPanel(String defaultText, ActionListener listener, String buttonText) {
        this(defaultText, listener, buttonText, 0, 0, 0);
    }

    public FileChooserPanel(String defaultText, ActionListener listener, String buttonText, int width, int height, int buttonWidth) {
        super(new BorderLayout());
        this.setBorder(new LineBorder(Color.GRAY));
        this.inputField = new JTextField(defaultText);
        this.inputField.setEditable(false);
        if (width > 0 || height > 0) {
            this.setPreferredSize(new Dimension(width, height));
        }
        JPanel p1extBt = new JPanel(new BorderLayout());
        this.browseButton = new JButton(buttonText);
        this.browseButton.setBorder(new MatteBorder(0, 1, 0, 0, Color.GRAY));
        Dimension prefSide = this.browseButton.getPreferredSize();
        this.browseButton.setPreferredSize(new Dimension(prefSide.width + 15, prefSide.height));
        if (buttonWidth > 0) {
            this.browseButton.setPreferredSize(new Dimension(buttonWidth, height));
        }
        p1extBt.add((Component)this.browseButton, "Center");
        this.browseButton.setFocusable(false);
        this.add((Component)this.inputField, "Center");
        this.add((Component)p1extBt, "East");
        this.browseButton.addActionListener(listener);
        ToolTipManager.sharedInstance().registerComponent(this.inputField);
        this.inputField.setToolTipText(this.getText());
    }

    public JButton getButton() {
        return this.browseButton;
    }

    public String getText() {
        return this.inputField.getText();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.browseButton.setEnabled(enable);
        super.setEnabled(enable);
    }

    public void setText(String text2) {
        this.inputField.setText(text2);
    }
}

