/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ColorPanel;

import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.CColorChooser;
import com.google.security.zynamics.zylib.gui.ColorPanel.IColorPanelListener;
import com.google.security.zynamics.zylib.resources.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class ColorPanel
extends JPanel {
    private final ListenerProvider<IColorPanelListener> m_listeners = new ListenerProvider();
    private boolean m_editable = true;
    private final boolean m_showColorText;
    private final JLabel m_textLabel = new JLabel("");
    private Set<Color> m_defaultColors = null;

    public ColorPanel(Color color) {
        this(color, false, false);
    }

    public ColorPanel(Color color, boolean editable) {
        this(color, editable, false);
    }

    public ColorPanel(Color color, boolean editable, boolean showColorText) {
        super(new BorderLayout());
        this.m_editable = editable;
        this.m_showColorText = showColorText;
        this.setColor(color);
        this.setBackground(color);
        this.m_textLabel.setHorizontalAlignment(0);
        this.add((Component)this.m_textLabel, "Center");
        this.setBorder(new LineBorder(Color.BLACK));
        this.setPreferredSize(new Dimension(100, 20));
        this.addMouseListener(new InternalListener());
        this.updateUI();
    }

    public ColorPanel(Color color, boolean editable, boolean showColorText, Set<Color> defaultColors) {
        this(color, editable, showColorText);
        this.m_defaultColors = defaultColors;
        this.setColor(color);
    }

    private void chooseColor() {
        Color col = CColorChooser.showDialog((Component)this, Constants.COLOR_CHOOSER, this.getBackground(), this.m_defaultColors == null ? null : this.m_defaultColors.toArray(new Color[0]));
        if (col != null) {
            this.setColor(col);
        }
    }

    private void setTextColor(Color color) {
        if (this.m_showColorText) {
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if ((double)hsb[2] > 0.65) {
                Color dcolor = new Color(32, 32, 32);
                this.m_textLabel.setForeground(dcolor);
            } else {
                Color bcolor = new Color(222, 222, 222);
                this.m_textLabel.setForeground(bcolor);
            }
            this.updateUI();
        }
    }

    public void addListener(IColorPanelListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Color getColor() {
        return this.getBackground();
    }

    public void removeListener(IColorPanelListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setColor(Color color) {
        this.setBackground(color);
        if (this.m_showColorText) {
            this.setTextColor(color);
            this.m_textLabel.setText(String.format("#%s (%d, %d, %d)", Convert.colorToHexString(color).toUpperCase(), color.getRed(), color.getGreen(), color.getBlue()));
            this.m_textLabel.updateUI();
        }
        for (IColorPanelListener listener : this.m_listeners) {
            listener.changedColor(this);
        }
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public void setText(String text2) {
        if (this.m_showColorText) {
            this.m_textLabel.setText(text2);
        }
    }

    private class InternalListener
    extends MouseAdapter {
        private InternalListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (ColorPanel.this.m_editable && event.getButton() == 1 && event.getClickCount() == 1) {
                ColorPanel.this.chooseColor();
            }
        }
    }
}

