/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ColorGrid;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JPanel;

public class ColorGrid
extends JPanel {
    private static final long serialVersionUID = -5981626927250840656L;
    private static final int squareSize = 40;
    private final List<Color> m_colors;
    private final int m_columns;

    public ColorGrid(List<Color> colors2, int columns) {
        this.m_colors = Preconditions.checkNotNull(colors2, "Error: colors argument can not be null");
        this.m_columns = columns;
        int rows = this.m_colors.size() / this.m_columns + (this.m_colors.size() % this.m_columns == 0 ? 0 : 1);
        this.setPreferredSize(new Dimension(columns * 40, rows * 40));
    }

    public Color getColorAt(int x2, int y2) {
        int row = y2 / 40;
        int col = x2 / 40;
        if (row * this.m_columns + col < this.m_colors.size()) {
            return this.m_colors.get(row * this.m_columns + col);
        }
        return null;
    }

    @Override
    public void paint(Graphics g2) {
        int rows = this.m_colors.size() / this.m_columns + (this.m_colors.size() % this.m_columns == 0 ? 0 : 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int j2 = 0; j2 < this.m_columns && i2 * this.m_columns + j2 < this.m_colors.size(); ++j2) {
                g2.setColor(this.m_colors.get(i2 * this.m_columns + j2));
                g2.fillRect(j2 * 40, i2 * 40, 40, 40);
                g2.setColor(Color.BLACK);
                g2.drawRect(j2 * 40, i2 * 40, 40, 40);
            }
        }
    }
}

