/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.CodeDisplay;

import com.google.common.base.Preconditions;

public class CodeDisplayCoordinate {
    private int rowIndex;
    private int columnIndex;
    private int lineIndex;
    private int fieldIndex;

    public CodeDisplayCoordinate(int row, int line, int column, int indexIntoField) {
        this.rowIndex = row;
        this.lineIndex = line;
        this.columnIndex = column;
        this.fieldIndex = indexIntoField;
    }

    CodeDisplayCoordinate(CodeDisplayCoordinate coordinate) {
        this.rowIndex = coordinate.getRow();
        this.lineIndex = coordinate.getLine();
        this.columnIndex = coordinate.getColumn();
        this.fieldIndex = coordinate.getFieldIndex();
    }

    public int getRow() {
        return this.rowIndex;
    }

    public int getColumn() {
        return this.columnIndex;
    }

    public int getLine() {
        return this.lineIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public void setRow(int row) {
        Preconditions.checkArgument(row >= 0, "Row should be >= 0: %s", row);
        this.rowIndex = row;
    }

    public void setColumn(int column) {
        Preconditions.checkArgument(column >= 0, "Column should be >= 0: %s", column);
        this.columnIndex = column;
    }

    public void setLine(int line) {
        Preconditions.checkArgument(line >= 0, "Line should be >= 0: %s", line);
        this.lineIndex = line;
    }

    public void setFieldIndex(int index) {
        Preconditions.checkArgument(index >= 0, "Index should be >= 0: %s", index);
        this.fieldIndex = index;
    }

    public String toString() {
        String string2 = String.valueOf(Integer.toString(this.rowIndex));
        String string3 = String.valueOf(Integer.toString(this.columnIndex));
        String string4 = String.valueOf(Integer.toString(this.lineIndex));
        String string5 = String.valueOf(Integer.toString(this.fieldIndex));
        return new StringBuilder(24 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Row: ").append(string2).append(", Column: ").append(string3).append(", Line: ").append(string4).append(",").append(string5).toString();
    }
}

