/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.security.zynamics.zylib.io.FileUtils;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CPathLabel
extends JLabel {
    protected String m_textEllipsis = null;
    protected JPopupMenu m_popup = new JPopupMenu();

    public CPathLabel() {
        this("", null, 10);
    }

    public CPathLabel(Icon image2) {
        this(null, image2, 0);
    }

    public CPathLabel(Icon image2, int horizontalAlignment) {
        this(null, image2, horizontalAlignment);
    }

    public CPathLabel(String text2) {
        this(text2, null, 10);
    }

    public CPathLabel(String text2, Icon icon, int horizontalAlignment) {
        super(text2, icon, horizontalAlignment);
        JMenuItem copyPathMenuItem = new JMenuItem("Copy Path", 67);
        copyPathMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                StringSelection data = new StringSelection(CPathLabel.super.getText());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(data, data);
            }
        });
        this.m_popup.add(copyPathMenuItem);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                CPathLabel.this.updatePathEllipsis();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            private void handlePopupEvent(MouseEvent e2) {
                if (e2.isPopupTrigger()) {
                    CPathLabel.this.m_popup.show(e2.getComponent(), e2.getX(), e2.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                this.handlePopupEvent(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                this.handlePopupEvent(e2);
            }
        });
    }

    public CPathLabel(String text2, int horizontalAlignment) {
        this(text2, null, horizontalAlignment);
    }

    protected void updatePathEllipsis() {
        if (this.getGraphics() == null) {
            return;
        }
        FontMetrics fm = this.getGraphics().getFontMetrics();
        this.m_textEllipsis = super.getText();
        String newValue = this.m_textEllipsis;
        int width = this.getWidth();
        for (int maxlen = this.m_textEllipsis.length(); maxlen >= 12 && fm.stringWidth(newValue) > width; --maxlen) {
            newValue = FileUtils.getPathEllipsis(this.m_textEllipsis, maxlen);
        }
        this.m_textEllipsis = newValue;
    }

    @Override
    public String getText() {
        return this.m_textEllipsis;
    }

    @Override
    public void repaint() {
        this.updatePathEllipsis();
        super.repaint();
    }
}

