/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.security.zynamics.zylib.general.Pair;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public final class CMessageBox {
    public static final String DEFAULT_WINDOW_TITLE_PROPERTY = String.valueOf(CMessageBox.class.getCanonicalName()).concat(".DEFAULT_WINDOW_TITLE");

    private CMessageBox() {
    }

    private static boolean isIconified(Component c2) {
        if (c2 != null && c2 instanceof Frame) {
            return (((Frame)c2).getExtendedState() & 1) != 0;
        }
        return false;
    }

    public static int showCustomQuestionMessageBox(Component parent, String description, String title, JButton[] buttons, JButton defaultButton) {
        return JOptionPane.showOptionDialog(parent, description, title, -1, 3, null, buttons, defaultButton);
    }

    public static void showError(Component parent, String msg) {
        JOptionPane.showMessageDialog(CMessageBox.isIconified(parent) ? null : parent, msg, System.getProperty(DEFAULT_WINDOW_TITLE_PROPERTY), 0);
    }

    public static void showInformation(Component parent, String msg) {
        JOptionPane.showMessageDialog(CMessageBox.isIconified(parent) ? null : parent, msg, System.getProperty(DEFAULT_WINDOW_TITLE_PROPERTY), 1);
    }

    public static void showWarning(Component parent, String msg) {
        JOptionPane.showMessageDialog(CMessageBox.isIconified(parent) ? null : parent, msg, System.getProperty(DEFAULT_WINDOW_TITLE_PROPERTY), 2);
    }

    public static int showYesNoCancelQuestion(Component parent, String msg) {
        return JOptionPane.showConfirmDialog(CMessageBox.isIconified(parent) ? null : parent, msg, System.getProperty(DEFAULT_WINDOW_TITLE_PROPERTY), 1, 3);
    }

    public static int showYesNoError(Component parent, String msg) {
        return JOptionPane.showConfirmDialog(CMessageBox.isIconified(parent) ? null : parent, msg, System.getProperty(DEFAULT_WINDOW_TITLE_PROPERTY), 0, 0);
    }

    public static int showYesNoQuestion(Component parent, String msg) {
        return CMessageBox.showYesNoQuestionWithCheckbox(parent, msg, null).first();
    }

    public static Pair<Integer, Boolean> showYesNoQuestionWithCheckbox(Component parent, String msg, String checkBoxTitle) {
        Object[] params;
        JCheckBox checkbox = null;
        if (checkBoxTitle != null) {
            checkbox = new JCheckBox(checkBoxTitle);
            params = new Object[]{msg, checkbox};
        } else {
            params = msg;
        }
        int option = JOptionPane.showConfirmDialog(CMessageBox.isIconified(parent) ? null : parent, params, System.getProperty(DEFAULT_WINDOW_TITLE_PROPERTY), 0, 3);
        return Pair.make(option, checkBoxTitle != null ? checkbox.isSelected() : false);
    }

    public static int showYesNoWarning(Component parent, String msg) {
        return JOptionPane.showConfirmDialog(CMessageBox.isIconified(parent) ? null : parent, msg, System.getProperty(DEFAULT_WINDOW_TITLE_PROPERTY), 0, 2);
    }
}

