/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.resources.Constants;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class CFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -5907483378595594768L;
    private final List<CFileNameExtensionFilter> m_fileFilters = new ArrayList<CFileNameExtensionFilter>();
    private final JCheckBox m_checkBox = new JCheckBox();
    private boolean m_askFileOverwrite = false;

    public CFileChooser() {
        this("");
    }

    public CFileChooser(FileExtension ... extensions) {
        Preconditions.checkNotNull(extensions, "File extensions can't be null.");
        for (FileExtension ext : extensions) {
            CFileNameExtensionFilter fileFilter = new CFileNameExtensionFilter(Arrays.asList(ext.m_extensions), ext.m_description);
            this.m_fileFilters.add(fileFilter);
            this.addChoosableFileFilter(fileFilter);
        }
    }

    public CFileChooser(List<String> fileExtensions, String fileDescription) {
        Preconditions.checkNotNull(fileExtensions, "Error: File extensions can't be null.");
        Preconditions.checkNotNull(fileDescription, "Error: File descriptions can't be null.");
        this.addChoosableFileFilter(new CFileNameExtensionFilter(fileExtensions, fileDescription));
    }

    public CFileChooser(String extension2) {
        this(extension2, "");
    }

    public CFileChooser(final String fileExtension, final String fileDescription) {
        Preconditions.checkNotNull(fileExtension, "Error: File extension can't be null.");
        Preconditions.checkNotNull(fileDescription, "Error: File description can't be null.");
        if (fileExtension.isEmpty()) {
            return;
        }
        this.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f2) {
                if ("".equals(fileExtension)) {
                    return f2.isDirectory() || f2.canExecute();
                }
                return f2.isDirectory() || f2.getName().toLowerCase().endsWith(fileExtension.toLowerCase()) || fileExtension.equals("*");
            }

            @Override
            public String getDescription() {
                String string2 = fileDescription;
                String string3 = fileExtension;
                return new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" (*.").append(string3).append(")").toString();
            }
        });
    }

    private static int showNativeFileDialog(final JFileChooser chooser) {
        FileDialog result = new FileDialog((Frame)chooser.getParent());
        result.setDirectory(chooser.getCurrentDirectory().getPath());
        File selected = chooser.getSelectedFile();
        result.setFile(selected == null ? "" : selected.getPath());
        result.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String string2 = String.valueOf(dir.getPath());
                String string3 = String.valueOf(File.pathSeparator);
                return chooser.getFileFilter().accept(new File(new StringBuilder(0 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(name).length()).append(string2).append(string3).append(name).toString()));
            }
        });
        if (chooser.getDialogType() == 1) {
            result.setMode(1);
        } else {
            result.setMode(0);
        }
        if (chooser.getFileSelectionMode() == 1) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        result.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        if (result.getFile() == null) {
            return 1;
        }
        String selectedDir = result.getDirectory();
        String string2 = String.valueOf(FileUtils.ensureTrailingSlash(selectedDir));
        String string3 = String.valueOf(result.getFile());
        chooser.setSelectedFile(new File(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
        return 0;
    }

    @Override
    public void approveSelection() {
        if (this.m_askFileOverwrite && this.getSelectedFile().exists() && CMessageBox.showYesNoQuestion(this, Constants.ASK_FILE_OVERWRITE) == 1) {
            return;
        }
        super.approveSelection();
    }

    public boolean getAskFileOverwrite() {
        return this.m_askFileOverwrite;
    }

    public boolean isSelectedCheckBox() {
        return this.m_checkBox.isSelected();
    }

    public void setAskFileOverwrite(boolean value) {
        this.m_askFileOverwrite = value;
    }

    public void setCheckBox(String checkBoxText) {
        Container approveParent;
        this.m_checkBox.setText(checkBoxText);
        this.m_checkBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        final String approve = this.getApproveButtonText();
        JButton approveButton = (JButton)GuiHelper.findComponentByPredicate(this, new GuiHelper.ComponentFilter(){

            @Override
            public boolean accept(JComponent c2) {
                if (!(c2 instanceof JButton)) {
                    return false;
                }
                String text2 = ((JButton)c2).getText();
                if (text2 == null) {
                    return approve == null;
                }
                if (approve == null) {
                    return text2 == null;
                }
                return ((JButton)c2).getText().equals(approve);
            }
        });
        Container parent = null;
        if (approveButton != null && (approveParent = approveButton.getParent()) instanceof JComponent) {
            parent = (JComponent)approveParent;
        }
        if (parent == null) {
            this.setAccessory(this.m_checkBox);
            return;
        }
        if (SystemHelpers.isRunningMacOSX()) {
            parent.add((Component)this.m_checkBox, 0);
            return;
        }
        JPanel buttonPanel = new JPanel(parent.getLayout());
        for (Component c2 : parent.getComponents()) {
            buttonPanel.add(c2);
        }
        parent.setLayout(new BorderLayout(0, 0));
        parent.add((Component)this.m_checkBox, "Before");
        parent.add((Component)buttonPanel, "Center");
    }

    public void setFileFilter(int index) {
        this.setFileFilter(this.m_fileFilters.get(index));
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        if (!SystemHelpers.isRunningMacOSX()) {
            return super.showOpenDialog(parent);
        }
        this.setDialogType(0);
        return CFileChooser.showNativeFileDialog(this);
    }

    public static class FileExtension {
        private final String m_description;
        private final String[] m_extensions;

        public FileExtension(String desc, String ... extensions) {
            this.m_description = desc;
            this.m_extensions = extensions;
        }
    }

    private class CFileNameExtensionFilter
    extends FileFilter {
        private final List<String> m_fileExtensions;
        private final String m_fileDescription;

        public CFileNameExtensionFilter(List<String> fileExtensions, String fileDescription) {
            this.m_fileExtensions = fileExtensions;
            this.m_fileDescription = fileDescription;
        }

        @Override
        public boolean accept(File f2) {
            String ext;
            boolean accept = false;
            String filenameLower = f2.getName().toLowerCase();
            Iterator<String> iterator = this.m_fileExtensions.iterator();
            while (iterator.hasNext() && !(accept = filenameLower.endsWith((ext = iterator.next()).toLowerCase()))) {
            }
            return accept || f2.isDirectory();
        }

        @Override
        public String getDescription() {
            return this.m_fileDescription;
        }
    }
}

