/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.security.zynamics.zylib.gui.ColorPanel.ColorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public class CColorChooser
extends JColorChooser {
    final Color[] m_recentColors;

    public CColorChooser() {
        this(new DefaultColorSelectionModel(Color.WHITE), null);
    }

    public CColorChooser(Color initialColor) {
        this(new DefaultColorSelectionModel(initialColor), null);
    }

    public CColorChooser(Color initialColor, Color[] recentColors) {
        this(new DefaultColorSelectionModel(initialColor), recentColors);
    }

    public CColorChooser(ColorSelectionModel model) {
        this(model, null);
    }

    public CColorChooser(ColorSelectionModel model, Color[] recentColors) {
        super(model);
        AbstractColorChooserPanel[] panels = this.getChooserPanels();
        if (panels.length > 0) {
            this.removeChooserPanel(panels[0]);
        }
        this.m_recentColors = recentColors;
        if (this.m_recentColors != null) {
            this.addChooserPanel(new RecentColorsColorChooserPanel());
        }
    }

    public static JDialog createDialog(Component parent, String title, boolean modal, CColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
        return JColorChooser.createDialog(parent, title, modal, chooserPane, okListener, cancelListener);
    }

    public static Color showDialog(Component parent, String title, Color initialColor) throws HeadlessException {
        return CColorChooser.showDialog(parent, title, initialColor, null);
    }

    public static Color showDialog(Component parent, String title, Color initialColor, Color[] recentColors) throws HeadlessException {
        CColorChooser pane = new CColorChooser(initialColor, recentColors);
        SelectedColorActionListener ok = pane.new SelectedColorActionListener();
        JDialog dlg = CColorChooser.createDialog(parent, title, true, pane, (ActionListener)ok, null);
        dlg.setVisible(true);
        dlg.dispose();
        return ok.getColor();
    }

    class SelectedColorActionListener
    implements ActionListener {
        Color m_color;

        SelectedColorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.m_color = CColorChooser.this.getColor();
        }

        public Color getColor() {
            return this.m_color;
        }
    }

    class RecentColorsColorChooserPanel
    extends AbstractColorChooserPanel {
        RecentColorsColorChooserPanel() {
        }

        @Override
        protected void buildChooser() {
            JPanel colorList = new JPanel();
            colorList.setLayout(new GridLayout(CColorChooser.this.m_recentColors.length, 1, 1, 1));
            for (final Color col : CColorChooser.this.m_recentColors) {
                ColorPanel cp2 = new ColorPanel(col, false, true);
                cp2.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e2) {
                        if (e2.getButton() != 1) {
                            return;
                        }
                        RecentColorsColorChooserPanel.this.getColorSelectionModel().setSelectedColor(col);
                    }
                });
                cp2.setPreferredSize(new Dimension(200, 25));
                JPanel p2 = new JPanel();
                p2.setBorder(new EmptyBorder(1, 1, 1, 1));
                p2.add((Component)cp2, "First");
                colorList.add(cp2);
            }
            GridBagConstraints c2 = new GridBagConstraints();
            c2.gridx = 0;
            c2.gridy = 0;
            c2.anchor = 23;
            c2.weightx = 1.0;
            c2.fill = 2;
            JPanel innerPanel = new JPanel(new GridBagLayout());
            innerPanel.add((Component)colorList, c2);
            JPanel outerPanel = new JPanel(new BorderLayout());
            outerPanel.add((Component)innerPanel, "North");
            JScrollPane sp = new JScrollPane(outerPanel);
            sp.setBorder(null);
            sp.setHorizontalScrollBarPolicy(30);
            sp.setVerticalScrollBarPolicy(20);
            this.add((Component)sp, "Center");
        }

        @Override
        public String getDisplayName() {
            return "Recent Colors";
        }

        @Override
        public Icon getLargeDisplayIcon() {
            return null;
        }

        @Override
        public Icon getSmallDisplayIcon() {
            return null;
        }

        @Override
        public void updateChooser() {
        }
    }
}

