/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gml;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphEdge;
import com.google.security.zynamics.zylib.types.trees.ITree;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.HashMap;
import java.util.Stack;

public final class GmlConverter {
    public static String toGml(IDirectedGraph<?, ? extends IGraphEdge<?>> graph) {
        Preconditions.checkNotNull(graph, "Graph argument can not be null");
        StringBuilder sb = new StringBuilder();
        sb.append("graph\n[\n");
        int currentId = 0;
        HashMap nodeMap = new HashMap();
        for (Object obj : graph.getNodes()) {
            sb.append("\tnode\n\t[\n\tid \n");
            sb.append(currentId);
            sb.append("\tlabel \"");
            sb.append(obj);
            sb.append("\"\n\t]\n");
            nodeMap.put(obj, currentId);
            ++currentId;
        }
        for (IGraphEdge iGraphEdge : graph.getEdges()) {
            sb.append("\tedge\n\t[\n\tsource ");
            sb.append(nodeMap.get(iGraphEdge.getSource()));
            sb.append("\n\ttarget ");
            sb.append(nodeMap.get(iGraphEdge.getTarget()));
            sb.append("\n\tgraphics\n\t[\n\t\tfill \"#000000\"\n\t\ttargetArrow \"standard\"\n\t]\n\t]\n");
        }
        sb.append("]\n");
        return sb.toString();
    }

    public static String toGml(ITree<?> graph) {
        Preconditions.checkNotNull(graph, "Graph argument can not be null");
        StringBuilder sb = new StringBuilder();
        sb.append("graph\n[\n");
        int currentId = 0;
        HashMap<ITreeNode, Integer> nodeMap = new HashMap<ITreeNode, Integer>();
        Stack stack = new Stack();
        stack.push(graph.getRootNode());
        while (!stack.isEmpty()) {
            ITreeNode node = (ITreeNode)stack.pop();
            sb.append("\tnode\n\t[\n\tid ");
            sb.append(currentId);
            sb.append("\n\tlabel \"\"\n");
            sb.append(node);
            sb.append("\t]\n");
            nodeMap.put(node, currentId);
            ++currentId;
            ITreeNode parent = node.getParent();
            if (parent != null) {
                sb.append("\tedge\n\t[\n\tsource ");
                sb.append(nodeMap.get(parent));
                sb.append("\n\ttarget ");
                sb.append(nodeMap.get(node));
                sb.append("\n\tgraphics\n\t[\n\t\tfill \"#000000\"\n\t\ttargetArrow \"standard\"\n\t]\n\t]\n");
            }
            for (ITreeNode treeNode : node.getChildren()) {
                stack.push(treeNode);
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

