/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general.memmanager;

import com.google.common.base.Preconditions;

public class MemoryChunk
implements Comparable<MemoryChunk> {
    private final long m_address;
    private byte[] m_data;

    public MemoryChunk(long address, byte[] data) {
        Preconditions.checkArgument(address >= 0L, "Chunk addresses can't be less than 0");
        Preconditions.checkNotNull(data, "Initial data can't be null");
        Preconditions.checkArgument(data.length != 0, "Initial data can't be empty");
        this.m_address = address;
        this.m_data = data;
    }

    public MemoryChunk(long address, int size) {
        this(address, new byte[size]);
    }

    @Override
    public int compareTo(MemoryChunk chunk2) {
        return Long.compare(this.m_address, chunk2.m_address);
    }

    public void extend(int size) {
        Preconditions.checkArgument(size > 0, "The number of bytes to add must be positive");
        byte[] data = new byte[this.m_data.length + size];
        System.arraycopy(this.m_data, 0, data, 0, this.m_data.length);
        this.m_data = data;
    }

    public long getAddress() {
        return this.m_address;
    }

    public byte[] getBytes() {
        return this.m_data;
    }

    public int getLength() {
        return this.m_data.length;
    }

    public byte loadByte(long address) {
        return this.m_data[(int)(address - this.m_address)];
    }

    public void print() {
        System.out.printf("%08X: ", this.m_address);
        for (byte element : this.m_data) {
            System.out.printf("%02X ", element);
        }
        System.out.println();
    }

    public void store(long address, byte[] data) {
        System.arraycopy(data, 0, this.m_data, (int)(address - this.m_address), data.length);
    }

    public void storeByte(long address, byte b2) {
        this.m_data[(int)(address - this.m_address)] = b2;
    }
}

