/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general.memmanager;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.memmanager.IMemoryListener;
import com.google.security.zynamics.zylib.general.memmanager.MemoryChunk;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Memory {
    private final LinkedList<MemoryChunk> m_chunks = new LinkedList();
    private final ArrayList<IMemoryListener> m_listeners = new ArrayList();
    private final ReadWriteLock m_readWriteLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_readWriteLock.readLock();
    private final Lock m_writeLock = this.m_readWriteLock.writeLock();

    private byte[] concat(byte[] data1, byte[] data2) {
        byte[] newdata = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, newdata, 0, data1.length);
        System.arraycopy(data2, 0, newdata, data1.length, data2.length);
        return newdata;
    }

    private MemoryChunk connectChunks(MemoryChunk firstChunk, MemoryChunk secondChunk) {
        MemoryChunk newChunk;
        Preconditions.checkNotNull(firstChunk, "Error: First memory chunk can't be null");
        Preconditions.checkNotNull(secondChunk, "Error: Second memory chunk can't be null");
        Preconditions.checkArgument(secondChunk.getAddress() > firstChunk.getAddress(), "Error: Second memory chunk must start after the first memory chunk");
        long newAddress = firstChunk.getAddress();
        if (firstChunk.getAddress() + (long)firstChunk.getLength() == secondChunk.getAddress()) {
            byte[] newData = this.concat(firstChunk.getBytes(), secondChunk.getBytes());
            newChunk = new MemoryChunk(newAddress, newData);
        } else {
            int toFill = (int)(secondChunk.getAddress() - firstChunk.getAddress()) - firstChunk.getLength();
            byte[] newData = new byte[firstChunk.getLength() + toFill + secondChunk.getLength()];
            if (toFill > 0) {
                return null;
            }
            if (toFill < 0) {
                System.arraycopy(firstChunk.getBytes(), 0, newData, 0, firstChunk.getLength());
                System.arraycopy(secondChunk.getBytes(), -toFill, newData, firstChunk.getLength(), secondChunk.getLength() + toFill);
            }
            newChunk = new MemoryChunk(newAddress, newData);
        }
        this.removeChunk(firstChunk);
        this.removeChunk(secondChunk);
        this.insertChunk(newChunk);
        return newChunk;
    }

    private MemoryChunk findChunk(long address) {
        Preconditions.checkArgument(address >= 0L, "Error: Address can't be less than 0");
        for (MemoryChunk chunk2 : this.m_chunks) {
            if (address < chunk2.getAddress() || address >= chunk2.getAddress() + (long)chunk2.getLength()) continue;
            return chunk2;
        }
        return null;
    }

    private int findChunkPosition(MemoryChunk chunk2) {
        Preconditions.checkNotNull(chunk2, "Error: Memory chunk can't be null");
        long address = chunk2.getAddress();
        for (int i2 = 0; i2 < this.getNumberOfChunks(); ++i2) {
            if (address >= this.m_chunks.get(i2).getAddress()) continue;
            return i2;
        }
        return this.m_chunks.size();
    }

    private MemoryChunk findNextChunk(long address) {
        Preconditions.checkArgument(address >= 0L, "Error: Address can't be less than 0");
        for (MemoryChunk chunk2 : this.m_chunks) {
            if (chunk2.getAddress() < address) continue;
            return chunk2;
        }
        return null;
    }

    private void insertChunk(MemoryChunk chunk2) {
        Preconditions.checkNotNull(chunk2, "Error: Memory chunk can't be null");
        int index = this.findChunkPosition(chunk2);
        this.m_chunks.add(index, chunk2);
    }

    private void notifyListeners(long address, int size) {
        for (IMemoryListener listener : this.m_listeners) {
            listener.memoryChanged(address, size);
        }
    }

    private void removeChunk(MemoryChunk chunk2) {
        Preconditions.checkNotNull(chunk2, "Error: Memory chunk can't be null");
        this.m_chunks.remove(chunk2);
    }

    private void splitChunk(MemoryChunk chunk2, long address) {
        byte[] oldData = chunk2.getBytes();
        byte[] newData1 = new byte[(int)(address - chunk2.getAddress())];
        byte[] newData2 = new byte[chunk2.getLength() - newData1.length];
        System.arraycopy(oldData, 0, newData1, 0, newData1.length);
        System.arraycopy(oldData, oldData.length - newData2.length, newData2, 0, newData2.length);
        MemoryChunk newChunk1 = new MemoryChunk(chunk2.getAddress(), newData1);
        MemoryChunk newChunk2 = new MemoryChunk(chunk2.getAddress() + (long)chunk2.getLength() - (long)newData2.length, newData2);
        this.removeChunk(chunk2);
        this.insertChunk(newChunk1);
        this.insertChunk(newChunk2);
    }

    public void addMemoryListener(IMemoryListener listener) {
        Preconditions.checkNotNull(listener, "Error: Listener can't be null");
        this.m_listeners.add(listener);
    }

    public void clear() {
        this.m_writeLock.lock();
        this.m_chunks.clear();
        this.m_writeLock.unlock();
        for (IMemoryListener listener : this.m_listeners) {
            listener.memoryCleared();
        }
    }

    public byte[] getData(long address, int length) {
        Preconditions.checkArgument(address >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkArgument(length > 0, "Error: Length must be positive");
        this.m_readLock.lock();
        MemoryChunk nextChunk = this.findChunk(address);
        int nextLength = length;
        long nextAddress = address;
        byte[] data = new byte[length];
        int copied = 0;
        try {
            while (true) {
                int start;
                if (nextChunk == null) {
                    throw new IllegalArgumentException("Error: Data is not available");
                }
                if (nextChunk.getAddress() + (long)nextChunk.getLength() - nextAddress >= (long)nextLength) {
                    start = (int)(nextAddress - nextChunk.getAddress());
                    System.arraycopy(nextChunk.getBytes(), start, data, copied, nextLength);
                    byte[] byArray = data;
                    return byArray;
                }
                start = (int)(nextAddress - nextChunk.getAddress());
                int toCopy = nextChunk.getLength() - start;
                System.arraycopy(nextChunk.getBytes(), start, data, copied, toCopy);
                copied += toCopy;
                nextLength = (int)((long)nextLength - (nextChunk.getAddress() + (long)nextChunk.getLength() - nextAddress));
                nextAddress = nextChunk.getAddress() + (long)nextChunk.getLength();
                nextChunk = this.findChunk(nextAddress);
            }
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public int getMemorySize() {
        this.m_readLock.lock();
        int size = 0;
        for (MemoryChunk chunk2 : this.m_chunks) {
            size += chunk2.getLength();
        }
        this.m_readLock.unlock();
        return size;
    }

    public int getNumberOfChunks() {
        this.m_readLock.lock();
        int size = this.m_chunks.size();
        this.m_readLock.unlock();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSectionSize(long address) {
        this.m_readLock.lock();
        long start = this.getSectionStart(address);
        try {
            if (this.hasData(start, 1)) {
                MemoryChunk chunk2 = this.findChunk(start);
                long accusize = 0L;
                while (true) {
                    if (!this.hasData(chunk2.getAddress() + (long)chunk2.getLength(), 1)) {
                        long l2 = (int)(accusize + (long)chunk2.getLength());
                        return l2;
                    }
                    accusize += (long)chunk2.getLength();
                    chunk2 = this.findChunk(chunk2.getAddress() + (long)chunk2.getLength());
                }
            }
            if (this.m_chunks.size() == 0) {
                long chunk2 = 0x100000000L;
                return chunk2;
            }
            MemoryChunk chunk3 = new MemoryChunk(start, 1);
            int cpos = this.findChunkPosition(chunk3);
            if (cpos == this.m_chunks.size()) {
                MemoryChunk lc = this.m_chunks.get(cpos - 1);
                long l3 = 0x100000000L - lc.getAddress() - (long)lc.getLength();
                return l3;
            }
            long l4 = this.m_chunks.get(cpos).getAddress() - start;
            return l4;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSectionStart(long address) {
        try {
            this.m_readLock.lock();
            MemoryChunk nextChunk = this.findChunk(address);
            if (nextChunk != null) {
                long start = nextChunk.getAddress();
                if (start == 0L) {
                    long l2 = 0L;
                    return l2;
                }
                MemoryChunk c2 = this.findChunk(start - 1L);
                if (c2 != null) {
                    long l3 = this.getSectionStart(start - 1L);
                    return l3;
                }
                long l4 = start;
                return l4;
            }
            MemoryChunk mem = new MemoryChunk(address, 1);
            int cpos = this.findChunkPosition(mem);
            if (cpos == 0) {
                long c2 = 0L;
                return c2;
            }
            MemoryChunk chunkBefore = this.m_chunks.get(cpos - 1);
            long l5 = chunkBefore.getAddress() + (long)chunkBefore.getLength();
            return l5;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public boolean hasData(long address, int length) {
        Preconditions.checkArgument(address >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkArgument(length > 0, "Error: Length must be positive");
        try {
            this.m_readLock.lock();
            MemoryChunk nextChunk = this.findChunk(address);
            int nextLength = length;
            long nextAddress = address;
            while (true) {
                if (nextChunk == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (nextChunk.getAddress() + (long)nextChunk.getLength() - nextAddress >= (long)nextLength) {
                    boolean bl3 = true;
                    return bl3;
                }
                nextLength = (int)((long)nextLength - (nextChunk.getAddress() + (long)nextChunk.getLength() - nextAddress));
                nextAddress = nextChunk.getAddress() + (long)nextChunk.getLength();
                nextChunk = this.findChunk(nextAddress);
            }
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public void printMemory() {
        this.m_readLock.lock();
        for (MemoryChunk chunk2 : this.m_chunks) {
            chunk2.print();
        }
        this.m_readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long address, int length) {
        Preconditions.checkArgument(address >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkArgument(length > 0, "Error: Length must be positive");
        try {
            this.m_writeLock.lock();
            MemoryChunk chunk2 = this.findChunk(address);
            if (chunk2 == null) {
                MemoryChunk nextChunk = this.findNextChunk(address);
                if (nextChunk == null) {
                    return;
                }
                if (nextChunk.getAddress() >= address + (long)length) {
                    return;
                }
                int toRemove = (int)(address + (long)length - nextChunk.getAddress());
                this.remove(nextChunk.getAddress(), toRemove);
            } else if (chunk2.getAddress() == address) {
                if (chunk2.getLength() <= length) {
                    this.removeChunk(chunk2);
                    int toDelete = length - chunk2.getLength();
                    if (toDelete > 0) {
                        this.remove(address + (long)chunk2.getLength(), toDelete);
                    }
                } else {
                    this.splitChunk(chunk2, address + (long)length);
                    this.removeChunk(this.findChunk(address));
                }
            } else if (chunk2.getAddress() + (long)chunk2.getLength() <= address + (long)length) {
                this.splitChunk(chunk2, address);
                MemoryChunk deleteChunk = this.findChunk(address);
                this.removeChunk(deleteChunk);
                int toRemove = length - deleteChunk.getLength();
                if (toRemove > 0) {
                    this.remove(address + (long)deleteChunk.getLength(), toRemove);
                }
            } else {
                this.splitChunk(chunk2, address);
                MemoryChunk secondChunk = this.findChunk(address);
                this.splitChunk(secondChunk, address + (long)length);
                this.removeChunk(this.findChunk(address));
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public void removeMemoryListener(IMemoryListener listener) {
        this.m_listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(long address, byte[] data) {
        Preconditions.checkArgument(address >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkNotNull(data, "Error: Data can't be null");
        try {
            this.m_writeLock.lock();
            this.remove(address, data.length);
            MemoryChunk chunk2 = new MemoryChunk(address, data);
            this.insertChunk(chunk2);
            MemoryChunk nextChunk = this.findChunk(address + (long)chunk2.getLength());
            if (nextChunk != null) {
                this.connectChunks(chunk2, nextChunk);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
        this.notifyListeners(address, data.length);
    }
}

