/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.awt.Color;
import javax.xml.bind.DatatypeConverter;

public final class Convert {
    private static String[] HEX_ARRAY = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};

    public static String asciiToHexString(String asciiString) {
        StringBuffer sb = new StringBuffer();
        for (byte b2 : asciiString.getBytes()) {
            sb.append(Convert.byteToHexString(b2));
        }
        return sb.toString();
    }

    public static String byteToHexString(byte b2) {
        return HEX_ARRAY[b2 & 0xFF];
    }

    public static String colorToHexString(Color c2) {
        String cs2 = Integer.toHexString(c2.getRGB());
        return cs2.substring(2);
    }

    public static String decStringToHexString(String decString) {
        Preconditions.checkNotNull(decString, "Error: Decimal string can't be null");
        return Long.toHexString(Long.valueOf(decString, 16));
    }

    public static String hexStringToAsciiString(String hexString) {
        String string2;
        if (hexString.length() % 2 == 0) {
            string2 = hexString;
        } else {
            String string3 = String.valueOf(hexString);
            string2 = string3.length() != 0 ? "0".concat(string3) : new String("0");
        }
        String realText = string2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < realText.length(); i2 += 2) {
            char c1 = realText.charAt(i2);
            char c2 = realText.charAt(i2 + 1);
            if (!Convert.isHexCharacter(c1) || !Convert.isHexCharacter(c2)) {
                throw new IllegalArgumentException("Error: Invalid hex string");
            }
            char code2 = (char)((Character.digit(c1, 16) << 4) + Character.digit(c2, 16));
            stringBuilder.append(Convert.isPrintableCharacter(code2) ? Character.valueOf(code2) : ".");
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        return DatatypeConverter.parseHexBinary((String)hexString);
    }

    public static long hexStringToLong(String hexString) {
        Preconditions.checkNotNull(hexString, "Error: Unicode string can't be null");
        Preconditions.checkArgument(Convert.isHexString(hexString), String.format("Error: Hex string '%s' is not a vaild hex string", hexString));
        if (hexString.length() == 16 && hexString.charAt(0) >= '\b') {
            String strAddr1 = hexString.substring(0, hexString.length() - 8);
            String strAddr2 = hexString.substring(hexString.length() - 8);
            return (Long.parseLong(strAddr1, 16) << 32) + Long.parseLong(strAddr2, 16);
        }
        return Long.parseLong(hexString, 16);
    }

    public static boolean isDecCharacter(char c2) {
        return CharMatcher.inRange('0', '9').apply(Character.valueOf(c2));
    }

    public static boolean isDecString(String string2) {
        Preconditions.checkNotNull(string2);
        CharMatcher cm2 = CharMatcher.inRange('0', '9');
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (cm2.apply(Character.valueOf(string2.charAt(i2)))) continue;
            return false;
        }
        return string2.length() != 0;
    }

    public static boolean isHexCharacter(char c2) {
        return Convert.isDecCharacter(c2) || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
    }

    public static boolean isHexString(String string2) {
        Preconditions.checkNotNull(string2, "Error: String argument can't be null");
        CharMatcher cm2 = CharMatcher.inRange('0', '9').or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('A', 'F'));
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (cm2.apply(Character.valueOf(string2.charAt(i2)))) continue;
            return false;
        }
        return string2.length() != 0;
    }

    public static boolean isMD5String(String string2) {
        Preconditions.checkNotNull(string2, "Error: String argument can't be null");
        return string2.length() == 32 && Convert.isHexString(string2);
    }

    public static boolean isPrintableCharacter(char c2) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c2);
        return !Character.isISOControl(c2) && c2 != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static boolean isSha1String(String string2) {
        Preconditions.checkNotNull(string2, "Error: String argument can't be null");
        return string2.length() == 40 && Convert.isHexString(string2);
    }

    public static String unicodeToHexString(String unicodeString) {
        Preconditions.checkNotNull(unicodeString, "Error: Unicode string can't be null");
        StringBuffer sb = new StringBuffer();
        for (byte b2 : unicodeString.getBytes()) {
            sb.append(String.format("%X00", b2));
        }
        return sb.toString();
    }
}

