/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.disassembly;

public enum ReferenceType {
    CONDITIONAL_TRUE,
    CONDITIONAL_FALSE,
    UNCONDITIONAL,
    SWITCH,
    CALL_DIRECT,
    CALL_INDIRECT,
    CALL_VIRTUAL,
    DATA,
    DATA_STRING;


    public static ReferenceType convertIntToReferenceType(int type) {
        switch (type) {
            case 0: {
                return CONDITIONAL_TRUE;
            }
            case 1: {
                return CONDITIONAL_FALSE;
            }
            case 2: {
                return UNCONDITIONAL;
            }
            case 3: {
                return SWITCH;
            }
            case 4: {
                return CALL_DIRECT;
            }
            case 5: {
                return CALL_INDIRECT;
            }
            case 6: {
                return CALL_INDIRECT;
            }
            case 7: {
                return CALL_VIRTUAL;
            }
            case 8: {
                return DATA;
            }
            case 9: {
                return DATA_STRING;
            }
        }
        throw new IllegalArgumentException("Error type is outside of reference type range");
    }

    public static int convertReferenceTypeToInt(ReferenceType referenceType) {
        return referenceType.ordinal();
    }

    public static boolean isCodeReference(ReferenceType referenceType) {
        return !ReferenceType.isDataReference(referenceType);
    }

    public static boolean isDataReference(ReferenceType referenceType) {
        return referenceType.compareTo(CALL_VIRTUAL) >= 0;
    }
}

