/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.math.BigInteger;

public class CAddress
implements IAddress {
    private final long m_address;

    public CAddress(BigInteger address) {
        Preconditions.checkNotNull(address, "Address argument can not be null");
        this.m_address = address.longValue();
    }

    public CAddress(CAddress address) {
        Preconditions.checkNotNull(address, "Address argument can not be null");
        this.m_address = address.m_address;
    }

    public CAddress(IAddress address) {
        Preconditions.checkNotNull(address, "Address argument can not be null");
        this.m_address = address.toLong();
    }

    public CAddress(long address) {
        this.m_address = address;
    }

    public CAddress(String address, int base2) {
        Preconditions.checkNotNull(address, "Address argument can not be null");
        Preconditions.checkArgument(base2 > 0, "Base must be positive");
        this.m_address = new BigInteger(address, base2).longValue();
    }

    public static int compare(long addr1, long addr2) {
        int result = addr1 < addr2 ? -1 : (addr1 > addr2 ? 1 : 0);
        return (addr1 & Long.MIN_VALUE) == (addr2 & Long.MIN_VALUE) ? result : -result;
    }

    @Override
    public int compareTo(CAddress addr) {
        return CAddress.compare(this.m_address, addr.m_address);
    }

    @Override
    public int compareTo(IAddress addr) {
        return CAddress.compare(this.m_address, addr.toLong());
    }

    @Override
    public int compareTo(long addr) {
        return CAddress.compare(this.m_address, addr);
    }

    public boolean equals(CAddress address) {
        return address != null && this.m_address == address.m_address;
    }

    public boolean equals(IAddress address) {
        return address != null && this.m_address == address.toLong();
    }

    public boolean equals(long address) {
        return this.m_address == address;
    }

    public boolean equals(Object address) {
        return address instanceof IAddress && this.m_address == ((IAddress)address).toLong();
    }

    public int hashCode() {
        return Long.valueOf(this.m_address).hashCode();
    }

    @Override
    public BigInteger toBigInteger() {
        if ((this.m_address & Long.MIN_VALUE) == 0L) {
            return BigInteger.valueOf(this.m_address);
        }
        return new BigInteger(Long.toHexString(this.m_address), 16);
    }

    @Override
    public String toHexString() {
        return Strings.padStart(Long.toHexString(this.m_address).toUpperCase(), (this.m_address & Long.MAX_VALUE) < 0x100000000L ? 8 : 16, '0');
    }

    @Override
    public long toLong() {
        return this.m_address;
    }

    public String toString() {
        return this.toHexString();
    }
}

