/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.ZyTree;

import com.google.security.zynamics.zylib.ZyTree.IZyTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Stack;

public class PostorderIterator {
    private final Stack<Pair<IZyTreeNode, Integer>> traversalStack = new Stack();
    private final IZyTreeNode m_root;
    private boolean m_started = false;

    public PostorderIterator(IZyTreeNode root) {
        this.m_root = root;
    }

    private void pushLongestPathFrom(IZyTreeNode node) {
        IZyTreeNode current = node;
        while (true) {
            this.traversalStack.push(new Pair<IZyTreeNode, Integer>(current, 0));
            if (current.getChildren().size() == 0) break;
            current = current.getChildren().get(0);
        }
    }

    public IZyTreeNode current() {
        return (IZyTreeNode)((Pair)this.traversalStack.lastElement()).first();
    }

    public boolean next() {
        if (this.m_started) {
            Pair<IZyTreeNode, Integer> parentElement;
            int childrenProcessed;
            if (this.traversalStack.empty()) {
                throw new RuntimeException("Internal Error: Traversal already finished");
            }
            do {
                if (!this.traversalStack.empty()) continue;
                return false;
            } while ((childrenProcessed = (parentElement = this.traversalStack.pop()).second() + 1) > parentElement.first().getChildren().size());
            if (childrenProcessed == parentElement.first().getChildren().size()) {
                this.traversalStack.push(new Pair<IZyTreeNode, Integer>(parentElement.first(), childrenProcessed));
                return true;
            }
            this.traversalStack.push(new Pair<IZyTreeNode, Integer>(parentElement.first(), childrenProcessed));
            this.pushLongestPathFrom(parentElement.first().getChildren().get(childrenProcessed));
            return true;
        }
        this.pushLongestPathFrom(this.m_root);
        this.m_started = true;
        return !this.traversalStack.empty();
    }
}

