/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class XlatTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "xlat");
        if (instruction.getOperands().size() != 0) {
            throw new InternalTranslationException("Error: Argument instruction is not a xlat instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        String isolatedAl = environment.getNextVariableString();
        String address = environment.getNextVariableString();
        String truncatedAddress = environment.getNextVariableString();
        String value = environment.getNextVariableString();
        String maskedEax = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, OperandSize.DWORD, "eax", OperandSize.DWORD, "255", OperandSize.DWORD, isolatedAl));
        instructions.add(ReilHelpers.createAdd(offset + 1L, OperandSize.DWORD, isolatedAl, OperandSize.DWORD, "ebx", OperandSize.QWORD, address));
        instructions.add(ReilHelpers.createAnd(offset + 2L, OperandSize.QWORD, address, OperandSize.DWORD, "4294967295", OperandSize.DWORD, truncatedAddress));
        instructions.add(ReilHelpers.createLdm(offset + 3L, OperandSize.DWORD, address, OperandSize.BYTE, value));
        instructions.add(ReilHelpers.createAnd(offset + 4L, OperandSize.DWORD, "eax", OperandSize.DWORD, "4294967040", OperandSize.DWORD, maskedEax));
        instructions.add(ReilHelpers.createOr(offset + 5L, OperandSize.BYTE, value, OperandSize.DWORD, maskedEax, OperandSize.DWORD, "eax"));
    }
}

