/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class XchgTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long reilOffsetBase;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "xchg");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a xchg instruction (invalid number of operands)");
        }
        long offset = reilOffsetBase = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree firstOperand = operands.get(0);
        IOperandTree secondOperand = operands.get(1);
        OperandSize archSize = environment.getArchitectureSize();
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, firstOperand, true);
        instructions.addAll(firstResult.getInstructions());
        offset = reilOffsetBase + (long)instructions.size();
        TranslationResult secondResult = Helpers.translateOperand(environment, offset, secondOperand, true);
        instructions.addAll(secondResult.getInstructions());
        offset = reilOffsetBase + (long)instructions.size();
        if (firstResult.getSize() != secondResult.getSize()) {
            throw new InternalTranslationException("Error: The operands of XCHG instructions must have equal size");
        }
        OperandSize size = firstResult.getSize();
        String firstRegister = firstResult.getRegister();
        String secondRegister = secondResult.getRegister();
        if (firstResult.getType() == TranslationResultType.REGISTER) {
            if (secondResult.getType() == TranslationResultType.REGISTER) {
                if (size == archSize) {
                    String temp = environment.getNextVariableString();
                    instructions.add(ReilHelpers.createStr(offset, size, firstRegister, size, temp));
                    instructions.add(ReilHelpers.createStr(offset + 1L, size, secondRegister, size, firstRegister));
                    instructions.add(ReilHelpers.createStr(offset + 2L, size, temp, size, secondRegister));
                    Helpers.writeBack(environment, offset + (long)instructions.size(), firstOperand, firstRegister, archSize, firstResult.getAddress(), firstResult.getType(), instructions);
                    Helpers.writeBack(environment, offset + (long)instructions.size(), secondOperand, secondRegister, archSize, secondResult.getAddress(), secondResult.getType(), instructions);
                } else {
                    Helpers.writeBack(environment, offset, secondOperand, firstRegister, size, secondResult.getAddress(), secondResult.getType(), instructions);
                    offset = reilOffsetBase + (long)instructions.size();
                    Helpers.writeBack(environment, offset, firstOperand, secondRegister, size, firstResult.getAddress(), firstResult.getType(), instructions);
                }
            } else if (secondResult.getType() == TranslationResultType.MEMORY_ACCESS) {
                Helpers.writeBack(environment, offset, secondOperand, firstRegister, size, secondResult.getAddress(), secondResult.getType(), instructions);
                offset = reilOffsetBase + (long)instructions.size();
                Helpers.writeBack(environment, offset, firstOperand, secondRegister, size, firstResult.getAddress(), firstResult.getType(), instructions);
            } else assert (false);
        } else assert (false);
    }
}

