/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ITranslationExtension;
import com.google.security.zynamics.reil.translators.ITranslator;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.x86.AboveGenerator;
import com.google.security.zynamics.reil.translators.x86.AdcTranslator;
import com.google.security.zynamics.reil.translators.x86.AddTranslator;
import com.google.security.zynamics.reil.translators.x86.AndTranslator;
import com.google.security.zynamics.reil.translators.x86.BelowEqualGenerator;
import com.google.security.zynamics.reil.translators.x86.BelowGenerator;
import com.google.security.zynamics.reil.translators.x86.BsfTranslator;
import com.google.security.zynamics.reil.translators.x86.BsrTranslator;
import com.google.security.zynamics.reil.translators.x86.BswapTranslator;
import com.google.security.zynamics.reil.translators.x86.BtTranslator;
import com.google.security.zynamics.reil.translators.x86.BtcTranslator;
import com.google.security.zynamics.reil.translators.x86.BtrTranslator;
import com.google.security.zynamics.reil.translators.x86.BtsTranslator;
import com.google.security.zynamics.reil.translators.x86.CallTranslator;
import com.google.security.zynamics.reil.translators.x86.CdqTranslator;
import com.google.security.zynamics.reil.translators.x86.ClcTranslator;
import com.google.security.zynamics.reil.translators.x86.CldTranslator;
import com.google.security.zynamics.reil.translators.x86.CliTranslator;
import com.google.security.zynamics.reil.translators.x86.CmcTranslator;
import com.google.security.zynamics.reil.translators.x86.CmovccTranslator;
import com.google.security.zynamics.reil.translators.x86.CmpTranslator;
import com.google.security.zynamics.reil.translators.x86.CmpsGenerator;
import com.google.security.zynamics.reil.translators.x86.CmpsbTranslator;
import com.google.security.zynamics.reil.translators.x86.CmpsdTranslator;
import com.google.security.zynamics.reil.translators.x86.CmpswTranslator;
import com.google.security.zynamics.reil.translators.x86.Cmpxchg8bTranslator;
import com.google.security.zynamics.reil.translators.x86.CmpxchgTranslator;
import com.google.security.zynamics.reil.translators.x86.CwdTranslator;
import com.google.security.zynamics.reil.translators.x86.CwdeTranslator;
import com.google.security.zynamics.reil.translators.x86.CxZeroGenerator;
import com.google.security.zynamics.reil.translators.x86.DecTranslator;
import com.google.security.zynamics.reil.translators.x86.DivTranslator;
import com.google.security.zynamics.reil.translators.x86.EcxZeroGenerator;
import com.google.security.zynamics.reil.translators.x86.GreaterEqualGenerator;
import com.google.security.zynamics.reil.translators.x86.GreaterGenerator;
import com.google.security.zynamics.reil.translators.x86.IdivTranslator;
import com.google.security.zynamics.reil.translators.x86.ImulTranslator;
import com.google.security.zynamics.reil.translators.x86.IncTranslator;
import com.google.security.zynamics.reil.translators.x86.JccTranslator;
import com.google.security.zynamics.reil.translators.x86.JmpTranslator;
import com.google.security.zynamics.reil.translators.x86.LahfTranslator;
import com.google.security.zynamics.reil.translators.x86.LeaTranslator;
import com.google.security.zynamics.reil.translators.x86.LeaveTranslator;
import com.google.security.zynamics.reil.translators.x86.LessEqualGenerator;
import com.google.security.zynamics.reil.translators.x86.LessGenerator;
import com.google.security.zynamics.reil.translators.x86.LodsGenerator;
import com.google.security.zynamics.reil.translators.x86.LodsbTranslator;
import com.google.security.zynamics.reil.translators.x86.LodsdTranslator;
import com.google.security.zynamics.reil.translators.x86.LodswTranslator;
import com.google.security.zynamics.reil.translators.x86.LoopTranslator;
import com.google.security.zynamics.reil.translators.x86.LoopeTranslator;
import com.google.security.zynamics.reil.translators.x86.LoopneTranslator;
import com.google.security.zynamics.reil.translators.x86.MovTranslator;
import com.google.security.zynamics.reil.translators.x86.MovsGenerator;
import com.google.security.zynamics.reil.translators.x86.MovsbTranslator;
import com.google.security.zynamics.reil.translators.x86.MovsdTranslator;
import com.google.security.zynamics.reil.translators.x86.MovswTranslator;
import com.google.security.zynamics.reil.translators.x86.MovsxTranslator;
import com.google.security.zynamics.reil.translators.x86.MovzxTranslator;
import com.google.security.zynamics.reil.translators.x86.MulTranslator;
import com.google.security.zynamics.reil.translators.x86.NegTranslator;
import com.google.security.zynamics.reil.translators.x86.NopTranslator;
import com.google.security.zynamics.reil.translators.x86.NotBelowEqualGenerator;
import com.google.security.zynamics.reil.translators.x86.NotBelowGenerator;
import com.google.security.zynamics.reil.translators.x86.NotLessEqualGenerator;
import com.google.security.zynamics.reil.translators.x86.NotLessGenerator;
import com.google.security.zynamics.reil.translators.x86.NotOverflowGenerator;
import com.google.security.zynamics.reil.translators.x86.NotParityGenerator;
import com.google.security.zynamics.reil.translators.x86.NotSignGenerator;
import com.google.security.zynamics.reil.translators.x86.NotTranslator;
import com.google.security.zynamics.reil.translators.x86.NotZeroGenerator;
import com.google.security.zynamics.reil.translators.x86.OrTranslator;
import com.google.security.zynamics.reil.translators.x86.OverflowGenerator;
import com.google.security.zynamics.reil.translators.x86.ParityGenerator;
import com.google.security.zynamics.reil.translators.x86.PopTranslator;
import com.google.security.zynamics.reil.translators.x86.PopaTranslator;
import com.google.security.zynamics.reil.translators.x86.PopawTranslator;
import com.google.security.zynamics.reil.translators.x86.PopfTranslator;
import com.google.security.zynamics.reil.translators.x86.PopfwTranslator;
import com.google.security.zynamics.reil.translators.x86.PushTranslator;
import com.google.security.zynamics.reil.translators.x86.PushaTranslator;
import com.google.security.zynamics.reil.translators.x86.PushawTranslator;
import com.google.security.zynamics.reil.translators.x86.PushfTranslator;
import com.google.security.zynamics.reil.translators.x86.PushfwTranslator;
import com.google.security.zynamics.reil.translators.x86.RclTranslator;
import com.google.security.zynamics.reil.translators.x86.RcrTranslator;
import com.google.security.zynamics.reil.translators.x86.RepTranslator;
import com.google.security.zynamics.reil.translators.x86.RepeTranslator;
import com.google.security.zynamics.reil.translators.x86.RepneTranslator;
import com.google.security.zynamics.reil.translators.x86.RetnTranslator;
import com.google.security.zynamics.reil.translators.x86.RolTranslator;
import com.google.security.zynamics.reil.translators.x86.RorTranslator;
import com.google.security.zynamics.reil.translators.x86.SahfTranslator;
import com.google.security.zynamics.reil.translators.x86.SarTranslator;
import com.google.security.zynamics.reil.translators.x86.SbbTranslator;
import com.google.security.zynamics.reil.translators.x86.ScasGenerator;
import com.google.security.zynamics.reil.translators.x86.ScasbTranslator;
import com.google.security.zynamics.reil.translators.x86.ScasdTranslator;
import com.google.security.zynamics.reil.translators.x86.ScaswTranslator;
import com.google.security.zynamics.reil.translators.x86.SetalcTranslator;
import com.google.security.zynamics.reil.translators.x86.SetccTranslator;
import com.google.security.zynamics.reil.translators.x86.ShlTranslator;
import com.google.security.zynamics.reil.translators.x86.ShldTranslator;
import com.google.security.zynamics.reil.translators.x86.ShrTranslator;
import com.google.security.zynamics.reil.translators.x86.ShrdTranslator;
import com.google.security.zynamics.reil.translators.x86.SignGenerator;
import com.google.security.zynamics.reil.translators.x86.StcTranslator;
import com.google.security.zynamics.reil.translators.x86.StdTranslator;
import com.google.security.zynamics.reil.translators.x86.StiTranslator;
import com.google.security.zynamics.reil.translators.x86.StosGenerator;
import com.google.security.zynamics.reil.translators.x86.StosbTranslator;
import com.google.security.zynamics.reil.translators.x86.StosdTranslator;
import com.google.security.zynamics.reil.translators.x86.StoswTranslator;
import com.google.security.zynamics.reil.translators.x86.SubTranslator;
import com.google.security.zynamics.reil.translators.x86.TestTranslator;
import com.google.security.zynamics.reil.translators.x86.XaddTranslator;
import com.google.security.zynamics.reil.translators.x86.XchgTranslator;
import com.google.security.zynamics.reil.translators.x86.XlatTranslator;
import com.google.security.zynamics.reil.translators.x86.XorTranslator;
import com.google.security.zynamics.reil.translators.x86.ZeroGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TranslatorX86<InstructionType extends IInstruction>
implements ITranslator<InstructionType> {
    private static final HashMap<String, IInstructionTranslator> translators = new HashMap();

    @Override
    public List<ReilInstruction> translate(ITranslationEnvironment environment, InstructionType instruction, List<ITranslationExtension<InstructionType>> extensions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        String mnemonic = instruction.getMnemonic();
        if (translators.containsKey(mnemonic)) {
            IInstructionTranslator translator = translators.get(mnemonic);
            ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
            translator.translate(environment, (IInstruction)instruction, (List<ReilInstruction>)instructions);
            for (ITranslationExtension<InstructionType> extension2 : extensions) {
                extension2.postProcess(environment, instruction, instructions);
            }
            return instructions;
        }
        if (mnemonic == null) {
            return new ArrayList<ReilInstruction>();
        }
        String string2 = String.valueOf(mnemonic);
        System.out.println(string2.length() != 0 ? "Unknown mnemonic: ".concat(string2) : new String("Unknown mnemonic: "));
        return Lists.newArrayList(ReilHelpers.createUnknown(ReilHelpers.toReilAddress(instruction.getAddress()).toLong()));
    }

    static {
        try {
            translators.put("adc", new AdcTranslator());
            translators.put("add", new AddTranslator());
            translators.put("and", new AndTranslator());
            translators.put("bswap", new BswapTranslator());
            translators.put("bsf", new BsfTranslator());
            translators.put("bsr", new BsrTranslator());
            translators.put("bt", new BtTranslator());
            translators.put("btc", new BtcTranslator());
            translators.put("btr", new BtrTranslator());
            translators.put("bts", new BtsTranslator());
            translators.put("call", new CallTranslator());
            translators.put("cdq", new CdqTranslator());
            translators.put("clc", new ClcTranslator());
            translators.put("cld", new CldTranslator());
            translators.put("cli", new CliTranslator());
            translators.put("cmc", new CmcTranslator());
            translators.put("cmova", new CmovccTranslator(new AboveGenerator()));
            translators.put("cmovnb", new CmovccTranslator(new NotBelowGenerator()));
            translators.put("cmovb", new CmovccTranslator(new BelowGenerator()));
            translators.put("cmovbe", new CmovccTranslator(new BelowEqualGenerator()));
            translators.put("cmovz", new CmovccTranslator(new ZeroGenerator()));
            translators.put("cmovg", new CmovccTranslator(new GreaterGenerator()));
            translators.put("cmovge", new CmovccTranslator(new GreaterEqualGenerator()));
            translators.put("cmovl", new CmovccTranslator(new LessGenerator()));
            translators.put("cmovle", new CmovccTranslator(new LessEqualGenerator()));
            translators.put("cmovnz", new CmovccTranslator(new NotZeroGenerator()));
            translators.put("cmovno", new CmovccTranslator(new NotOverflowGenerator()));
            translators.put("cmovnp", new CmovccTranslator(new NotParityGenerator()));
            translators.put("cmovns", new CmovccTranslator(new NotSignGenerator()));
            translators.put("cmovo", new CmovccTranslator(new OverflowGenerator()));
            translators.put("cmovp", new CmovccTranslator(new ParityGenerator()));
            translators.put("cmovs", new CmovccTranslator(new SignGenerator()));
            translators.put("cmp", new CmpTranslator());
            translators.put("cmpsb", new CmpsbTranslator());
            translators.put("cmpsw", new CmpswTranslator());
            translators.put("cmpsd", new CmpsdTranslator());
            translators.put("cmpxchg", new CmpxchgTranslator());
            translators.put("cmpxchg8b", new Cmpxchg8bTranslator());
            translators.put("cwd", new CwdTranslator());
            translators.put("cwde", new CwdeTranslator());
            translators.put("dec", new DecTranslator());
            translators.put("div", new DivTranslator());
            translators.put("imul", new ImulTranslator());
            translators.put("idiv", new IdivTranslator());
            translators.put("inc", new IncTranslator());
            translators.put("ja", new JccTranslator(new AboveGenerator()));
            translators.put("jae", new JccTranslator(new NotBelowGenerator()));
            translators.put("jb", new JccTranslator(new BelowGenerator()));
            translators.put("jbe", new JccTranslator(new BelowEqualGenerator()));
            translators.put("jcxz", new JccTranslator(new EcxZeroGenerator()));
            translators.put("jecxz", new JccTranslator(new CxZeroGenerator()));
            translators.put("je", new JccTranslator(new ZeroGenerator()));
            translators.put("jg", new JccTranslator(new GreaterGenerator()));
            translators.put("jge", new JccTranslator(new GreaterEqualGenerator()));
            translators.put("jl", new JccTranslator(new LessGenerator()));
            translators.put("jle", new JccTranslator(new LessEqualGenerator()));
            translators.put("jmp", new JmpTranslator());
            translators.put("jnb", new JccTranslator(new NotBelowGenerator()));
            translators.put("jne", new JccTranslator(new NotZeroGenerator()));
            translators.put("jno", new JccTranslator(new NotOverflowGenerator()));
            translators.put("jnp", new JccTranslator(new NotParityGenerator()));
            translators.put("jns", new JccTranslator(new NotSignGenerator()));
            translators.put("jnz", new JccTranslator(new NotZeroGenerator()));
            translators.put("jo", new JccTranslator(new OverflowGenerator()));
            translators.put("jp", new JccTranslator(new ParityGenerator()));
            translators.put("js", new JccTranslator(new SignGenerator()));
            translators.put("jz", new JccTranslator(new ZeroGenerator()));
            translators.put("lahf", new LahfTranslator());
            translators.put("lea", new LeaTranslator());
            translators.put("leave", new LeaveTranslator());
            translators.put("lock add", new AddTranslator());
            translators.put("lock adc", new AdcTranslator());
            translators.put("lock and", new AndTranslator());
            translators.put("lock btc", new BtcTranslator());
            translators.put("lock btr", new BtrTranslator());
            translators.put("lock bts", new BtsTranslator());
            translators.put("lock cmpxchg", new CmpxchgTranslator());
            translators.put("lock cmpxchg8b", new Cmpxchg8bTranslator());
            translators.put("lock dec", new DecTranslator());
            translators.put("lock inc", new IncTranslator());
            translators.put("lock neg", new NegTranslator());
            translators.put("lock not", new NotTranslator());
            translators.put("lock or", new OrTranslator());
            translators.put("lock sbb", new SbbTranslator());
            translators.put("lock sub", new SubTranslator());
            translators.put("lock xor", new XorTranslator());
            translators.put("lock xadd", new XaddTranslator());
            translators.put("lock xchg", new XchgTranslator());
            translators.put("lodsb", new LodsbTranslator());
            translators.put("lodsw", new LodswTranslator());
            translators.put("lodsd", new LodsdTranslator());
            translators.put("loop", new LoopTranslator());
            translators.put("loope", new LoopeTranslator());
            translators.put("loopne", new LoopneTranslator());
            translators.put("mov", new MovTranslator());
            translators.put("movsb", new MovsbTranslator());
            translators.put("movsw", new MovswTranslator());
            translators.put("movsd", new MovsdTranslator());
            translators.put("movsx", new MovsxTranslator());
            translators.put("movzx", new MovzxTranslator());
            translators.put("mul", new MulTranslator());
            translators.put("or", new OrTranslator());
            translators.put("neg", new NegTranslator());
            translators.put("nop", new NopTranslator());
            translators.put("not", new NotTranslator());
            translators.put("pop", new PopTranslator());
            translators.put("popa", new PopaTranslator());
            translators.put("popaw", new PopawTranslator());
            translators.put("popf", new PopfTranslator());
            translators.put("popfw", new PopfwTranslator());
            translators.put("push", new PushTranslator());
            translators.put("pusha", new PushaTranslator());
            translators.put("pushaw", new PushawTranslator());
            translators.put("pushf", new PushfTranslator());
            translators.put("pushfw", new PushfwTranslator());
            translators.put("rep lodsb", new RepTranslator(new LodsGenerator(), OperandSize.BYTE));
            translators.put("rep lodsw", new RepTranslator(new LodsGenerator(), OperandSize.WORD));
            translators.put("rep lodsd", new RepTranslator(new LodsGenerator(), OperandSize.DWORD));
            translators.put("rep movsb", new RepTranslator(new MovsGenerator(), OperandSize.BYTE));
            translators.put("rep movsw", new RepTranslator(new MovsGenerator(), OperandSize.WORD));
            translators.put("rep movsd", new RepTranslator(new MovsGenerator(), OperandSize.DWORD));
            translators.put("rep stosb", new RepTranslator(new StosGenerator(), OperandSize.BYTE));
            translators.put("rep stosw", new RepTranslator(new StosGenerator(), OperandSize.WORD));
            translators.put("rep stosd", new RepTranslator(new StosGenerator(), OperandSize.DWORD));
            translators.put("repe cmpsb", new RepeTranslator(new CmpsGenerator(), OperandSize.BYTE));
            translators.put("repe cmpsw", new RepeTranslator(new CmpsGenerator(), OperandSize.WORD));
            translators.put("repe cmpsd", new RepeTranslator(new CmpsGenerator(), OperandSize.DWORD));
            translators.put("repe scasb", new RepeTranslator(new ScasGenerator(), OperandSize.BYTE));
            translators.put("repe scasw", new RepeTranslator(new ScasGenerator(), OperandSize.WORD));
            translators.put("repe scasd", new RepeTranslator(new ScasGenerator(), OperandSize.DWORD));
            translators.put("repne cmpsb", new RepneTranslator(new CmpsGenerator(), OperandSize.BYTE));
            translators.put("repne cmpsw", new RepneTranslator(new CmpsGenerator(), OperandSize.WORD));
            translators.put("repne cmpsd", new RepneTranslator(new CmpsGenerator(), OperandSize.DWORD));
            translators.put("repne scasb", new RepneTranslator(new ScasGenerator(), OperandSize.BYTE));
            translators.put("repne scasw", new RepneTranslator(new ScasGenerator(), OperandSize.WORD));
            translators.put("repne scasd", new RepneTranslator(new ScasGenerator(), OperandSize.DWORD));
            translators.put("ret", new RetnTranslator());
            translators.put("retn", new RetnTranslator());
            translators.put("rcl", new RclTranslator());
            translators.put("rcr", new RcrTranslator());
            translators.put("rol", new RolTranslator());
            translators.put("ror", new RorTranslator());
            translators.put("sahf", new SahfTranslator());
            translators.put("sal", new ShlTranslator());
            translators.put("sar", new SarTranslator());
            translators.put("sbb", new SbbTranslator());
            translators.put("scasb", new ScasbTranslator());
            translators.put("scasw", new ScaswTranslator());
            translators.put("scasd", new ScasdTranslator());
            translators.put("setalc", new SetalcTranslator());
            translators.put("setb", new SetccTranslator(new BelowGenerator()));
            translators.put("setbe", new SetccTranslator(new BelowEqualGenerator()));
            translators.put("sete", new SetccTranslator(new ZeroGenerator()));
            translators.put("setl", new SetccTranslator(new LessGenerator()));
            translators.put("setle", new SetccTranslator(new LessEqualGenerator()));
            translators.put("setnb", new SetccTranslator(new NotBelowGenerator()));
            translators.put("setnbe", new SetccTranslator(new NotBelowEqualGenerator()));
            translators.put("setne", new SetccTranslator(new NotZeroGenerator()));
            translators.put("setnl", new SetccTranslator(new NotLessGenerator()));
            translators.put("setnle", new SetccTranslator(new NotLessEqualGenerator()));
            translators.put("setno", new SetccTranslator(new NotOverflowGenerator()));
            translators.put("setnp", new SetccTranslator(new NotParityGenerator()));
            translators.put("setns", new SetccTranslator(new NotSignGenerator()));
            translators.put("setnz", new SetccTranslator(new NotZeroGenerator()));
            translators.put("seto", new SetccTranslator(new OverflowGenerator()));
            translators.put("setp", new SetccTranslator(new ParityGenerator()));
            translators.put("sets", new SetccTranslator(new SignGenerator()));
            translators.put("setz", new SetccTranslator(new ZeroGenerator()));
            translators.put("shl", new ShlTranslator());
            translators.put("shr", new ShrTranslator());
            translators.put("shld", new ShldTranslator());
            translators.put("shrd", new ShrdTranslator());
            translators.put("stc", new StcTranslator());
            translators.put("std", new StdTranslator());
            translators.put("sti", new StiTranslator());
            translators.put("stosb", new StosbTranslator());
            translators.put("stosw", new StoswTranslator());
            translators.put("stosd", new StosdTranslator());
            translators.put("sub", new SubTranslator());
            translators.put("test", new TestTranslator());
            translators.put("xadd", new XaddTranslator());
            translators.put("xchg", new XchgTranslator());
            translators.put("xlat", new XlatTranslator());
            translators.put("xor", new XorTranslator());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

