/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.IStringInstructionGenerator;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.util.List;

public class StosGenerator
implements IStringInstructionGenerator {
    @Override
    public void generate(ITranslationEnvironment environment, long baseOffset, OperandSize operandSize, List<ReilInstruction> instructions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        Preconditions.checkArgument(baseOffset >= 0L, "Error: Argument offset can't be less than 0");
        long offset = baseOffset;
        int previousInstructions = (int)(baseOffset % 256L);
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(archSize);
        String maskedEax = null;
        String ediChange = String.valueOf(operandSize.getByteSize());
        String mask = String.valueOf(TranslationHelpers.getAllBitsMask(operandSize));
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        if (operandSize != archSize) {
            maskedEax = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, archSize, "eax", archSize, mask, archSize, maskedEax));
            ++offset;
        } else {
            maskedEax = "eax";
        }
        String addResult = environment.getNextVariableString();
        String subResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createStm(offset, operandSize, maskedEax, archSize, "edi"));
        String jmpGoal = String.format("%d.%d", ReilHelpers.toNativeAddress(new CAddress(baseOffset)).toLong(), previousInstructions + 5 + (operandSize != archSize ? 1 : 0));
        String jmpGoal2 = String.format("%d.%d", ReilHelpers.toNativeAddress(new CAddress(baseOffset)).toLong(), previousInstructions + 7 + (operandSize != archSize ? 1 : 0));
        instructions.add(ReilHelpers.createJcc(offset + 1L, OperandSize.BYTE, "DF", OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAdd(offset + 2L, archSize, "edi", archSize, ediChange, resultSize, addResult));
        instructions.add(ReilHelpers.createAnd(offset + 3L, resultSize, addResult, archSize, truncateMask, archSize, "edi"));
        instructions.add(ReilHelpers.createJcc(offset + 4L, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createSub(offset + 5L, archSize, "edi", archSize, ediChange, resultSize, subResult));
        instructions.add(ReilHelpers.createAnd(offset + 6L, resultSize, subResult, archSize, truncateMask, archSize, "edi"));
        instructions.add(ReilHelpers.createNop(offset + 7L));
    }
}

