/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class StcTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "stc");
        if (instruction.getOperands().size() != 0) {
            throw new InternalTranslationException("Error: Argument instruction is not a stc instruction (invalid number of operands)");
        }
        long baseOffset = instruction.getAddress().toLong() * 256L;
        instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "1", OperandSize.BYTE, "CF"));
    }
}

