/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.reil.translators.x86.IConditionGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class SetccTranslator
implements IInstructionTranslator {
    private final IConditionGenerator conditionGenerator;

    public SetccTranslator(IConditionGenerator conditionGenerator) {
        Preconditions.checkNotNull(conditionGenerator, "Error: Argument conditionGenerator can't be null");
        this.conditionGenerator = conditionGenerator;
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long reilOffsetBase;
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a conditional setcc instruction (invalid number of operands)");
        }
        long reilOffset = reilOffsetBase = instruction.getAddress().toLong() * 256L;
        IOperandTree operand = instruction.getOperands().get(0);
        TranslationResult result = Helpers.translateOperand(environment, reilOffset, operand, false);
        OperandSize size = result.getSize();
        TranslationResultType type = result.getType();
        String address = result.getAddress();
        instructions.addAll(result.getInstructions());
        reilOffset = reilOffsetBase + (long)instructions.size();
        Pair<OperandSize, String> condition = this.conditionGenerator.generate(environment, reilOffset, instructions);
        reilOffset = reilOffsetBase + (long)instructions.size();
        String conditionRegister = condition.second();
        Helpers.writeBack(environment, reilOffset, operand, conditionRegister, size, address, type, instructions);
    }
}

