/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class SetalcTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "setalc");
        if (instruction.getOperands().size() != 0) {
            throw new InternalTranslationException("Error: Argument instruction is not an setalc instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        String subResult = environment.getNextVariableString();
        String truncatedSubResult = environment.getNextVariableString();
        String clearedEax = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset++, OperandSize.BYTE, "0", OperandSize.BYTE, "CF", OperandSize.WORD, subResult));
        instructions.add(ReilHelpers.createAnd(offset++, OperandSize.WORD, subResult, OperandSize.BYTE, "255", OperandSize.BYTE, truncatedSubResult));
        instructions.add(ReilHelpers.createAnd(offset++, OperandSize.DWORD, "eax", OperandSize.DWORD, String.valueOf(0xFFFFFF00L), OperandSize.DWORD, clearedEax));
        instructions.add(ReilHelpers.createOr(offset++, OperandSize.DWORD, clearedEax, OperandSize.BYTE, truncatedSubResult, OperandSize.DWORD, "eax"));
    }
}

