/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class SarTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "sar");
        Preconditions.checkArgument(instruction.getOperands().size() == 2, "Error: Argument instruction is not a sar instruction (invalid number of operands)");
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        IOperandTree sourceOperand = operands.get(1);
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, targetOperand, true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize sourceSize = sourceResult.getSize();
        OperandSize targetSize = targetResult.getSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(sourceSize);
        String sourceRegister = sourceResult.getRegister();
        String targetRegister = targetResult.getRegister();
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(sourceSize));
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(sourceSize));
        String modValue = String.valueOf(targetSize.getBitSize());
        String shiftMask = environment.getNextVariableString();
        String shiftMaskZero = environment.getNextVariableString();
        String shiftMaskLessOne = environment.getNextVariableString();
        String shiftMaskOne = environment.getNextVariableString();
        String shiftMaskNeg = environment.getNextVariableString();
        String result = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        String msbResult = environment.getNextVariableString();
        String isPositive = environment.getNextVariableString();
        String divisor = environment.getNextVariableString();
        String divisionResult = environment.getNextVariableString();
        String negateMask = environment.getNextVariableString();
        String twoComplementResult = environment.getNextVariableString();
        String shiftBit = environment.getNextVariableString();
        String shiftedBitsMask = environment.getNextVariableString();
        String shiftedBits = environment.getNextVariableString();
        String shiftedBitsZero = environment.getNextVariableString();
        String shiftedBitsNonZero = environment.getNextVariableString();
        String shiftAmountMinOne = environment.getNextVariableString();
        String isNegative = environment.getNextVariableString();
        String roundTowNegInf = environment.getNextVariableString();
        String cfBitMask = environment.getNextVariableString();
        String cfBitResult = environment.getNextVariableString();
        String tmpCf = environment.getNextVariableString();
        Pair<String, String> targetRegister1Abs = Helpers.generateAbs(environment, offset, targetRegister, targetSize, instructions);
        String targetRegister1Absolute = targetRegister1Abs.second();
        offset = baseOffset + (long)instructions.size();
        int delta = instructions.size();
        instructions.add(ReilHelpers.createMod(offset, sourceSize, sourceRegister, targetSize, modValue, targetSize, shiftMask));
        instructions.add(ReilHelpers.createBisz(offset + 1L, targetSize, shiftMask, OperandSize.BYTE, shiftMaskZero));
        String jmpEnd = String.format("%s.%s", instruction.getAddress().toLong(), delta + 39);
        instructions.add(ReilHelpers.createJcc(offset + 2L, OperandSize.BYTE, shiftMaskZero, OperandSize.ADDRESS, jmpEnd, new String[0]));
        instructions.add(ReilHelpers.createUndef(offset + 3L, OperandSize.BYTE, "AF"));
        instructions.add(ReilHelpers.createSub(offset + 4L, OperandSize.BYTE, shiftMask, OperandSize.BYTE, "1", OperandSize.BYTE, shiftAmountMinOne));
        instructions.add(ReilHelpers.createBsh(offset + 5L, OperandSize.BYTE, "1", OperandSize.BYTE, shiftAmountMinOne, OperandSize.BYTE, cfBitMask));
        instructions.add(ReilHelpers.createAnd(offset + 6L, targetSize, targetRegister, OperandSize.BYTE, cfBitMask, OperandSize.BYTE, cfBitResult));
        instructions.add(ReilHelpers.createBisz(offset + 7L, OperandSize.BYTE, cfBitResult, OperandSize.BYTE, tmpCf));
        instructions.add(ReilHelpers.createXor(offset + 8L, OperandSize.BYTE, "1", OperandSize.BYTE, tmpCf, OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createSub(offset + 9L, targetSize, "1", targetSize, shiftMask, targetSize, shiftMaskLessOne));
        instructions.add(ReilHelpers.createBisz(offset + 10L, targetSize, shiftMaskLessOne, OperandSize.BYTE, shiftMaskOne));
        instructions.add(ReilHelpers.createSub(offset + 11L, targetSize, "0", targetSize, shiftMask, targetSize, shiftMaskNeg));
        instructions.add(ReilHelpers.createAnd(offset + 12L, sourceSize, msbMask, targetSize, targetRegister, sourceSize, msbResult));
        instructions.add(ReilHelpers.createBisz(offset + 13L, sourceSize, msbResult, OperandSize.BYTE, isPositive));
        instructions.add(ReilHelpers.createXor(offset + 14L, OperandSize.BYTE, "1", OperandSize.BYTE, isPositive, OperandSize.BYTE, isNegative));
        instructions.add(ReilHelpers.createBsh(offset + 15L, OperandSize.DWORD, "1", OperandSize.BYTE, shiftMask, OperandSize.DWORD, divisor));
        instructions.add(ReilHelpers.createDiv(offset + 16L, targetSize, targetRegister1Absolute, OperandSize.DWORD, divisor, OperandSize.DWORD, divisionResult));
        instructions.add(ReilHelpers.createSub(offset + 17L, OperandSize.BYTE, "0", OperandSize.BYTE, isNegative, OperandSize.DWORD, negateMask));
        instructions.add(ReilHelpers.createXor(offset + 18L, OperandSize.DWORD, divisionResult, OperandSize.DWORD, negateMask, OperandSize.DWORD, result));
        String jmpSkipTwosComplement = String.format("%s.%s", instruction.getAddress().toLong(), delta + 28);
        instructions.add(ReilHelpers.createJcc(offset + 19L, OperandSize.BYTE, isPositive, OperandSize.ADDRESS, jmpSkipTwosComplement, new String[0]));
        instructions.add(ReilHelpers.createAdd(offset + 20L, OperandSize.DWORD, result, OperandSize.BYTE, "1", OperandSize.DWORD, twoComplementResult));
        instructions.add(ReilHelpers.createBsh(offset + 21L, OperandSize.BYTE, "1", targetSize, shiftMask, targetSize, shiftBit));
        instructions.add(ReilHelpers.createSub(offset + 22L, targetSize, shiftBit, OperandSize.BYTE, "1", targetSize, shiftedBitsMask));
        instructions.add(ReilHelpers.createAnd(offset + 23L, targetSize, targetRegister, targetSize, shiftedBitsMask, targetSize, shiftedBits));
        instructions.add(ReilHelpers.createBisz(offset + 24L, targetSize, shiftedBits, OperandSize.BYTE, shiftedBitsZero));
        instructions.add(ReilHelpers.createXor(offset + 25L, OperandSize.BYTE, "1", OperandSize.BYTE, shiftedBitsZero, OperandSize.BYTE, shiftedBitsNonZero));
        instructions.add(ReilHelpers.createAnd(offset + 26L, OperandSize.BYTE, isNegative, OperandSize.BYTE, shiftedBitsNonZero, OperandSize.BYTE, roundTowNegInf));
        instructions.add(ReilHelpers.createSub(offset + 27L, OperandSize.DWORD, twoComplementResult, OperandSize.BYTE, roundTowNegInf, targetSize, result));
        instructions.add(ReilHelpers.createAnd(offset + 28L, resultSize, result, sourceSize, truncateMask, sourceSize, truncatedResult));
        String jmpGoal = String.format("%s.%s", instruction.getAddress().toLong(), delta + 39);
        instructions.add(ReilHelpers.createJcc(offset + 29L, OperandSize.BYTE, shiftMaskZero, OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createBisz(offset + 30L, OperandSize.BYTE, isPositive, OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createBisz(offset + 31L, sourceSize, truncatedResult, OperandSize.BYTE, "ZF"));
        String jmpDontZeroOF = String.format("%s.%s", instruction.getAddress().toLong(), delta + 34);
        instructions.add(ReilHelpers.createJcc(offset + 32L, OperandSize.BYTE, shiftMaskOne, OperandSize.ADDRESS, jmpDontZeroOF, new String[0]));
        instructions.add(ReilHelpers.createStr(offset + 33L, OperandSize.BYTE, "0", OperandSize.BYTE, "OF"));
        String shiftCountZeroOrOne = environment.getNextVariableString();
        instructions.add(ReilHelpers.createOr(offset + 34L, OperandSize.BYTE, shiftMaskOne, OperandSize.BYTE, shiftMaskZero, OperandSize.BYTE, shiftCountZeroOrOne));
        String jmpSkipUndefOF = String.format("%s.%s", instruction.getAddress().toLong(), delta + 38);
        instructions.add(ReilHelpers.createJcc(offset + 35L, OperandSize.BYTE, shiftCountZeroOrOne, OperandSize.ADDRESS, jmpSkipUndefOF, new String[0]));
        instructions.add(ReilHelpers.createUndef(offset + 36L, OperandSize.BYTE, "OF"));
        String jmpGoal3 = String.format("%s.%s", instruction.getAddress().toLong(), delta + 39);
        instructions.add(ReilHelpers.createJcc(offset + 37L, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoal3, new String[0]));
        instructions.add(ReilHelpers.createStr(offset + 38L, OperandSize.BYTE, "0", OperandSize.BYTE, "OF"));
        int sizeBefore = instructions.size();
        Helpers.writeBack(environment, offset + 39L, targetOperand, result, targetSize, targetResult.getAddress(), targetResult.getType(), instructions);
        int sizeAfter = instructions.size();
        instructions.add(ReilHelpers.createNop((long)(sizeAfter - sizeBefore - 1) + offset + 40L));
    }
}

