/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class SahfTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "sahf");
        if (instruction.getOperands().size() != 0) {
            throw new InternalTranslationException("Error: Argument instruction is not a sahf instruction (invalid number of operands)");
        }
        long baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize archSize = environment.getArchitectureSize();
        String shiftedEaxToCf = environment.getNextVariableString();
        String shiftedEaxToPf = environment.getNextVariableString();
        String shiftedEaxToAf = environment.getNextVariableString();
        String shiftedEaxToZf = environment.getNextVariableString();
        String shiftedEaxToSf = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset, archSize, "eax", archSize, "-8", archSize, shiftedEaxToCf));
        instructions.add(ReilHelpers.createAnd(baseOffset + 1L, archSize, shiftedEaxToCf, archSize, "1", OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createBsh(baseOffset + 2L, archSize, "eax", archSize, "-10", archSize, shiftedEaxToPf));
        instructions.add(ReilHelpers.createAnd(baseOffset + 3L, archSize, shiftedEaxToPf, archSize, "1", OperandSize.BYTE, "PF"));
        instructions.add(ReilHelpers.createBsh(baseOffset + 4L, archSize, "eax", archSize, "-12", archSize, shiftedEaxToAf));
        instructions.add(ReilHelpers.createAnd(baseOffset + 5L, archSize, shiftedEaxToAf, archSize, "1", OperandSize.BYTE, "AF"));
        instructions.add(ReilHelpers.createBsh(baseOffset + 6L, archSize, "eax", archSize, "-14", archSize, shiftedEaxToZf));
        instructions.add(ReilHelpers.createAnd(baseOffset + 7L, archSize, shiftedEaxToZf, archSize, "1", OperandSize.BYTE, "ZF"));
        instructions.add(ReilHelpers.createBsh(baseOffset + 8L, archSize, "eax", archSize, "-15", archSize, shiftedEaxToSf));
        instructions.add(ReilHelpers.createAnd(baseOffset + 9L, archSize, shiftedEaxToSf, archSize, "1", OperandSize.BYTE, "SF"));
    }
}

